package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class InputMouseSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(0.6841890215873718f, 0.0f, 0.0f, 1.2410709857940674f, 7.976597785949707f, -9.191010475158691f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(24.344676971435547, 32.34263610839844), 22.829447f, new Point2D.Double(24.344676971435547, 32.34263610839844), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.6194689869880676f, 2.8184919675933173E-15f, 12.30737018585205f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.174126, 32.342636);
((GeneralPath)shape).curveTo(47.174126, 40.153122, 36.953033, 46.48477, 24.344677, 46.48477);
((GeneralPath)shape).curveTo(11.736322, 46.48477, 1.5152302, 40.153122, 1.5152302, 32.342636);
((GeneralPath)shape).curveTo(1.5152302, 24.53215, 11.736322, 18.2005, 24.344677, 18.2005);
((GeneralPath)shape).curveTo(36.953033, 18.2005, 47.174126, 24.53215, 47.174126, 32.342636);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new LinearGradientPaint(new Point2D.Double(35.743350982666016, 4.375), new Point2D.Double(36.54312515258789, -1.0), new float[] {0.0f,1.0f}, new Color[] {new Color(172, 172, 172, 255),new Color(141, 141, 141, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.8405290246009827f, 0.0f, 0.0f, 1.0f, 4.170553207397461f, 0.0f));
stroke = new BasicStroke(1.0000004f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.922983, 10.5);
((GeneralPath)shape).curveTo(20.560867, 3.0, 22.031794, 1.75, 28.966158, 3.75);
((GeneralPath)shape).curveTo(35.754646, 5.7079268, 43.465282, 14.0, 42.83489, 5.25);
((GeneralPath)shape).curveTo(42.167034, -4.0199065, 33.378937, -8.75, 33.378937, -8.75);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new RadialGradientPaint(new Point2D.Double(20.588579177856445, 14.245287895202637), 13.261548f, new Point2D.Double(20.588579177856445, 14.245287895202637), new float[] {0.0f,0.37333333f,0.6031111f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(217, 217, 217, 255),new Color(197, 197, 197, 255),new Color(144, 144, 144, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.8663740158081055f, -5.5050500498667265E-25f, 1.6380670072858759E-24f, 2.3051340579986572f, -16.991689682006836f, -19.013099670410156f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(9.939883, 27.131191);
((GeneralPath)shape).curveTo(7.483519, 38.037746, 14.640836, 45.54149, 25.387142, 45.54149);
((GeneralPath)shape).curveTo(36.017143, 45.54149, 41.302036, 36.850883, 39.11298, 27.131191);
((GeneralPath)shape).lineTo(35.62336, 14.116623);
((GeneralPath)shape).curveTo(35.216236, 12.293633, 34.346813, 11.710736, 33.76223, 11.512351);
((GeneralPath)shape).curveTo(28.039312, 8.942826, 19.976755, 8.818981, 14.94167, 11.512351);
((GeneralPath)shape).curveTo(14.301906, 11.859589, 13.836623, 11.859587, 13.371341, 13.59577);
((GeneralPath)shape).lineTo(9.939883, 27.131191);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(79, 79, 79, 255);
stroke = new BasicStroke(1.0000007f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(9.939883, 27.131191);
((GeneralPath)shape).curveTo(7.483519, 38.037746, 14.640836, 45.54149, 25.387142, 45.54149);
((GeneralPath)shape).curveTo(36.017143, 45.54149, 41.302036, 36.850883, 39.11298, 27.131191);
((GeneralPath)shape).lineTo(35.62336, 14.116623);
((GeneralPath)shape).curveTo(35.216236, 12.293633, 34.346813, 11.710736, 33.76223, 11.512351);
((GeneralPath)shape).curveTo(28.039312, 8.942826, 19.976755, 8.818981, 14.94167, 11.512351);
((GeneralPath)shape).curveTo(14.301906, 11.859589, 13.836623, 11.859587, 13.371341, 13.59577);
((GeneralPath)shape).lineTo(9.939883, 27.131191);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(0.8405290246009827f, 0.0f, 0.0f, 1.0f, 4.170553207397461f, 1.0f));
// _0_0_3
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3_0
paint = new Color(255, 255, 255, 203);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(8.573669, 22.948217);
((GeneralPath)shape).curveTo(16.805824, 17.644917, 29.854662, 17.038826, 38.524693, 22.342127);
((GeneralPath)shape).curveTo(30.832369, 18.464708, 17.818977, 17.99819, 8.573669, 22.948217);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3_1
paint = new Color(0, 0, 0, 66);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(8.750446, 22.72725);
((GeneralPath)shape).curveTo(17.380348, 16.49587, 30.031439, 16.42011, 38.436306, 22.25374);
((GeneralPath)shape).curveTo(30.65559, 17.580828, 17.686396, 17.291086, 8.750446, 22.72725);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3_1);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.6663429737091064f, 0.0f, 0.0f, 1.4178069829940796f, -15.706390380859375f, 0.3478730022907257f));
// _0_0_4
paint = new LinearGradientPaint(new Point2D.Double(23.99112319946289, 12.830256462097168), new Point2D.Double(23.99112319946289, 7.187739372253418), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(169, 169, 169, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.16295, 11.331463);
((GeneralPath)shape).curveTo(26.16358, 13.028576, 25.749771, 14.5973625, 25.077545, 15.446317);
((GeneralPath)shape).curveTo(24.405321, 16.29527, 23.576925, 16.29527, 22.904701, 15.446317);
((GeneralPath)shape).curveTo(22.232475, 14.5973625, 21.818666, 13.028576, 21.819296, 11.331463);
((GeneralPath)shape).curveTo(21.818666, 9.63435, 22.232475, 8.065563, 22.904701, 7.2166085);
((GeneralPath)shape).curveTo(23.576925, 6.3676543, 24.405321, 6.3676543, 25.077545, 7.2166085);
((GeneralPath)shape).curveTo(25.749771, 8.065563, 26.16358, 9.63435, 26.16295, 11.331463);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new LinearGradientPaint(new Point2D.Double(10.80749797821045, 2.4829132556915283), new Point2D.Double(16.00248908996582, 56.39980697631836), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7714149951934814f, 0.0f, 0.0f, 1.0f, 5.848416805267334f, 1.0f));
stroke = new BasicStroke(1.0000002f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(10.487085, 28.908148);
((GeneralPath)shape).curveTo(9.079121, 37.36856, 15.125142, 44.574368, 25.45902, 44.574368);
((GeneralPath)shape).curveTo(35.792843, 44.574368, 39.74773, 35.87646, 38.57301, 28.908148);
((GeneralPath)shape).lineTo(34.847874, 14.950287);
((GeneralPath)shape).curveTo(34.538773, 12.75438, 33.628273, 12.542565, 33.08904, 12.330979);
((GeneralPath)shape).curveTo(27.237518, 10.034947, 20.414902, 9.845529, 15.647667, 12.330979);
((GeneralPath)shape).curveTo(15.050261, 12.642443, 14.555416, 12.524067, 14.192413, 14.108229);
((GeneralPath)shape).lineTo(10.487085, 28.908148);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(0.8405290246009827f, 0.0f, 0.0f, 1.0f, 4.085647106170654f, 2.7425169944763184f));
// _0_0_6
paint = new LinearGradientPaint(new Point2D.Double(23.99112319946289, 6.583745956420898), new Point2D.Double(23.99112319946289, 15.069026947021484), new float[] {0.0f,0.2f,1.0f}, new Color[] {new Color(177, 177, 177, 255),new Color(223, 223, 223, 255),new Color(86, 86, 86, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.16295, 11.331463);
((GeneralPath)shape).curveTo(26.16358, 13.028576, 25.749771, 14.5973625, 25.077545, 15.446317);
((GeneralPath)shape).curveTo(24.405321, 16.29527, 23.576925, 16.29527, 22.904701, 15.446317);
((GeneralPath)shape).curveTo(22.232475, 14.5973625, 21.818666, 13.028576, 21.819296, 11.331463);
((GeneralPath)shape).curveTo(21.818666, 9.63435, 22.232475, 8.065563, 22.904701, 7.2166085);
((GeneralPath)shape).curveTo(23.576925, 6.3676543, 24.405321, 6.3676543, 25.077545, 7.2166085);
((GeneralPath)shape).curveTo(25.749771, 8.065563, 26.16358, 9.63435, 26.16295, 11.331463);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(89, 89, 89, 255);
stroke = new BasicStroke(0.5453732f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.16295, 11.331463);
((GeneralPath)shape).curveTo(26.16358, 13.028576, 25.749771, 14.5973625, 25.077545, 15.446317);
((GeneralPath)shape).curveTo(24.405321, 16.29527, 23.576925, 16.29527, 22.904701, 15.446317);
((GeneralPath)shape).curveTo(22.232475, 14.5973625, 21.818666, 13.028576, 21.819296, 11.331463);
((GeneralPath)shape).curveTo(21.818666, 9.63435, 22.232475, 8.065563, 22.904701, 7.2166085);
((GeneralPath)shape).curveTo(23.576925, 6.3676543, 24.405321, 6.3676543, 25.077545, 7.2166085);
((GeneralPath)shape).curveTo(25.749771, 8.065563, 26.16358, 9.63435, 26.16295, 11.331463);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(0.23456500470638275f, 0.0f, 0.0f, 0.5425530076026917f, 17.98657989501953f, 6.360321998596191f));
// _0_0_7
paint = new Color(255, 255, 255, 85);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.16295, 11.331463);
((GeneralPath)shape).curveTo(26.16358, 13.028576, 25.749771, 14.5973625, 25.077545, 15.446317);
((GeneralPath)shape).curveTo(24.405321, 16.29527, 23.576925, 16.29527, 22.904701, 15.446317);
((GeneralPath)shape).curveTo(22.232475, 14.5973625, 21.818666, 13.028576, 21.819296, 11.331463);
((GeneralPath)shape).curveTo(21.818666, 9.63435, 22.232475, 8.065563, 22.904701, 7.2166085);
((GeneralPath)shape).curveTo(23.576925, 6.3676543, 24.405321, 6.3676543, 25.077545, 7.2166085);
((GeneralPath)shape).curveTo(25.749771, 8.065563, 26.16358, 9.63435, 26.16295, 11.331463);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 8;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 0;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 36;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 48;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public InputMouseSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

