package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class MediaFlashSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.43373498f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(0.9658120274543762f, 0.0f, 0.0f, 1.0f, 0.8219360709190369f, 0.0f));
// _0_0_0
paint = new Color(0, 0, 0, 255);
shape = new RoundRectangle2D.Double(3.358757257461548, 41.989593505859375, 41.365745544433594, 4.596194267272949, 4.758891582489014, 4.596194267272949);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new LinearGradientPaint(new Point2D.Double(21.617008209228516, 4.607614517211914), new Point2D.Double(26.443777084350586, 47.007381439208984), new float[] {0.0f,1.0f}, new Color[] {new Color(85, 87, 83, 255),new Color(62, 63, 60, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.9825159907341003f, 0.0f, -0.07076703011989594f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.4999976, 3.2368596);
((GeneralPath)shape).lineTo(5.4999976, 43.61886);
((GeneralPath)shape).curveTo(5.569704, 44.669067, 6.498735, 45.72121, 7.8834214, 45.616245);
((GeneralPath)shape).lineTo(39.73528, 45.616245);
((GeneralPath)shape).curveTo(40.628845, 45.573135, 41.513054, 44.830044, 41.499985, 43.35833);
((GeneralPath)shape).lineTo(41.499985, 6.42834);
((GeneralPath)shape).curveTo(41.499985, 5.711803, 41.268738, 5.2304363, 40.74373, 4.7146063);
((GeneralPath)shape).curveTo(40.74373, 4.7146063, 37.99473, 1.8791213, 37.99473, 1.8791213);
((GeneralPath)shape).curveTo(37.70747, 1.6077368, 37.530773, 1.4999993, 36.73528, 1.4999993);
((GeneralPath)shape).lineTo(6.7352915, 1.4999993);
((GeneralPath)shape).curveTo(5.7977915, 1.5614066, 5.4374976, 2.499972, 5.4999976, 3.2368596);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(46, 52, 54, 255);
stroke = new BasicStroke(0.99999976f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.4999976, 3.2368596);
((GeneralPath)shape).lineTo(5.4999976, 43.61886);
((GeneralPath)shape).curveTo(5.569704, 44.669067, 6.498735, 45.72121, 7.8834214, 45.616245);
((GeneralPath)shape).lineTo(39.73528, 45.616245);
((GeneralPath)shape).curveTo(40.628845, 45.573135, 41.513054, 44.830044, 41.499985, 43.35833);
((GeneralPath)shape).lineTo(41.499985, 6.42834);
((GeneralPath)shape).curveTo(41.499985, 5.711803, 41.268738, 5.2304363, 40.74373, 4.7146063);
((GeneralPath)shape).curveTo(40.74373, 4.7146063, 37.99473, 1.8791213, 37.99473, 1.8791213);
((GeneralPath)shape).curveTo(37.70747, 1.6077368, 37.530773, 1.4999993, 36.73528, 1.4999993);
((GeneralPath)shape).lineTo(6.7352915, 1.4999993);
((GeneralPath)shape).curveTo(5.7977915, 1.5614066, 5.4374976, 2.499972, 5.4999976, 3.2368596);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new Color(237, 212, 0, 255);
shape = new RoundRectangle2D.Double(9.499995231628418, 5.616117000579834, 27.976646423339844, 16.99999237060547, 3.7948882579803467, 3.794890880584717);
g.setPaint(paint);
g.fill(shape);
paint = new Color(46, 52, 54, 255);
stroke = new BasicStroke(3.0f,0,0,4.0f,null,0.0f);
shape = new RoundRectangle2D.Double(9.499995231628418, 5.616117000579834, 27.976646423339844, 16.99999237060547, 3.7948882579803467, 3.794890880584717);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new LinearGradientPaint(new Point2D.Double(29.374996185302734, 21.741113662719727), new Point2D.Double(22.101642608642578, 7.67861270904541), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(237, 212, 0, 255),new Color(195, 175, 7, 255),new Color(255, 235, 62, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new RoundRectangle2D.Double(9.499995231628418, 5.616117000579834, 27.976646423339844, 16.99999237060547, 3.7948882579803467, 3.794890880584717);
g.setPaint(paint);
g.fill(shape);
paint = new Color(196, 160, 0, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new RoundRectangle2D.Double(9.499995231628418, 5.616117000579834, 27.976646423339844, 16.99999237060547, 3.7948882579803467, 3.794890880584717);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, -0.005532700102776289f, 0.9999849796295166f, 0.0f, 0.0f));
// _0_0_4
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(1.0000087f,0,0,4.0f,null,0.0f);
shape = new RoundRectangle2D.Double(10.57809829711914, 6.616239547729492, 26.000003814697266, 15.000280380249023, 2.292287826538086, 2.292226552963257);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.0, 6.116117);
((GeneralPath)shape).lineTo(12.0, 12.11612);
((GeneralPath)shape).curveTo(19.204912, 9.255847, 27.058025, 16.094118, 35.0, 14.11612);
((GeneralPath)shape).lineTo(35.0, 6.1880393);
((GeneralPath)shape).lineTo(36.0, 6.1880393);
((GeneralPath)shape).lineTo(36.0, 22.11612);
((GeneralPath)shape).lineTo(35.0, 22.11612);
((GeneralPath)shape).lineTo(35.0, 16.11612);
((GeneralPath)shape).curveTo(26.337015, 18.056862, 19.445696, 11.070476, 12.0, 14.11612);
((GeneralPath)shape).lineTo(12.0, 22.11612);
((GeneralPath)shape).lineTo(11.0, 22.11612);
((GeneralPath)shape).lineTo(11.0, 6.116117);
((GeneralPath)shape).lineTo(12.0, 6.116117);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(13.0, 6.116117);
((GeneralPath)shape).lineTo(13.0, 10.850955);
((GeneralPath)shape).lineTo(14.0, 10.611733);
((GeneralPath)shape).lineTo(14.0, 6.116117);
((GeneralPath)shape).lineTo(13.0, 6.116117);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(15.0, 10.611732);
((GeneralPath)shape).lineTo(15.0, 6.116117);
((GeneralPath)shape).lineTo(16.0, 6.116117);
((GeneralPath)shape).lineTo(16.0, 10.523344);
((GeneralPath)shape).lineTo(15.0, 10.611732);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(17.0, 10.523344);
((GeneralPath)shape).lineTo(17.0, 6.116117);
((GeneralPath)shape).lineTo(18.0, 6.116117);
((GeneralPath)shape).lineTo(18.0, 10.674178);
((GeneralPath)shape).lineTo(17.0, 10.523344);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(19.0, 10.895149);
((GeneralPath)shape).lineTo(19.0, 6.116117);
((GeneralPath)shape).lineTo(20.0, 6.116117);
((GeneralPath)shape).lineTo(20.0, 11.11612);
((GeneralPath)shape).lineTo(19.0, 10.895149);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.0, 11.274645);
((GeneralPath)shape).lineTo(21.0, 6.116117);
((GeneralPath)shape).lineTo(22.0, 6.116117);
((GeneralPath)shape).lineTo(22.0, 11.451422);
((GeneralPath)shape).lineTo(21.0, 11.274645);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.0, 11.804975);
((GeneralPath)shape).lineTo(23.0, 6.116117);
((GeneralPath)shape).lineTo(24.0, 6.116117);
((GeneralPath)shape).lineTo(24.0, 11.937558);
((GeneralPath)shape).lineTo(23.0, 11.804975);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_12
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(25.0, 12.335305);
((GeneralPath)shape).lineTo(25.0, 6.116117);
((GeneralPath)shape).lineTo(26.0, 6.116117);
((GeneralPath)shape).lineTo(26.0, 12.512082);
((GeneralPath)shape).lineTo(25.0, 12.335305);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_13
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.0, 12.733053);
((GeneralPath)shape).lineTo(27.0, 6.116117);
((GeneralPath)shape).lineTo(28.0, 6.116117);
((GeneralPath)shape).lineTo(28.0, 12.90983);
((GeneralPath)shape).lineTo(27.0, 12.733053);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_13);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_14 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_14
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(29.0, 13.219189);
((GeneralPath)shape).lineTo(29.0, 6.116117);
((GeneralPath)shape).lineTo(30.0, 6.116117);
((GeneralPath)shape).lineTo(30.0, 13.307577);
((GeneralPath)shape).lineTo(29.0, 13.219189);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_14);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_15 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_15
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.0, 13.395965);
((GeneralPath)shape).lineTo(31.0, 6.116117);
((GeneralPath)shape).lineTo(32.0, 6.116117);
((GeneralPath)shape).lineTo(32.0, 13.395966);
((GeneralPath)shape).lineTo(31.0, 13.395965);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_15);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_16 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_16
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(33.0, 13.395965);
((GeneralPath)shape).lineTo(33.0, 6.116117);
((GeneralPath)shape).lineTo(34.0, 6.116117);
((GeneralPath)shape).lineTo(34.0, 13.263383);
((GeneralPath)shape).lineTo(33.0, 13.395965);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_16);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_17 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_17
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(13.0, 22.070139);
((GeneralPath)shape).lineTo(13.0, 14.639459);
((GeneralPath)shape).lineTo(14.0, 14.525128);
((GeneralPath)shape).lineTo(14.0, 22.070139);
((GeneralPath)shape).lineTo(13.0, 22.070139);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_17);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_18 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(15.0, 14.480935);
((GeneralPath)shape).lineTo(15.0, 22.070139);
((GeneralPath)shape).lineTo(16.0, 22.070139);
((GeneralPath)shape).lineTo(16.0, 14.348352);
((GeneralPath)shape).lineTo(15.0, 14.480935);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_19 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_19
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(17.0, 14.348352);
((GeneralPath)shape).lineTo(17.0, 22.070139);
((GeneralPath)shape).lineTo(18.0, 22.070139);
((GeneralPath)shape).lineTo(18.0, 14.462683);
((GeneralPath)shape).lineTo(17.0, 14.348352);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_19);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_20 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_20
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(19.0, 14.772042);
((GeneralPath)shape).lineTo(19.0, 22.070139);
((GeneralPath)shape).lineTo(20.0, 22.070139);
((GeneralPath)shape).lineTo(20.0, 14.993013);
((GeneralPath)shape).lineTo(19.0, 14.772042);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_20);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_21 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_21
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.0, 15.232235);
((GeneralPath)shape).lineTo(21.0, 22.070139);
((GeneralPath)shape).lineTo(22.0, 22.070139);
((GeneralPath)shape).lineTo(22.0, 15.4974);
((GeneralPath)shape).lineTo(21.0, 15.232235);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_21);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_22 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_22
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.0, 15.850954);
((GeneralPath)shape).lineTo(23.0, 22.070139);
((GeneralPath)shape).lineTo(24.0, 22.070139);
((GeneralPath)shape).lineTo(24.0, 16.204508);
((GeneralPath)shape).lineTo(23.0, 15.850954);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_22);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_23 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_23
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(25.0, 16.381285);
((GeneralPath)shape).lineTo(25.0, 22.070139);
((GeneralPath)shape).lineTo(26.0, 22.070139);
((GeneralPath)shape).lineTo(26.0, 16.646448);
((GeneralPath)shape).lineTo(25.0, 16.381285);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_23);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_24 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_24
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.0, 16.823227);
((GeneralPath)shape).lineTo(27.0, 22.070139);
((GeneralPath)shape).lineTo(28.0, 22.070139);
((GeneralPath)shape).lineTo(28.0, 17.000002);
((GeneralPath)shape).lineTo(27.0, 16.823227);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_24);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_25 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_25
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(29.0, 17.176779);
((GeneralPath)shape).lineTo(29.0, 22.070139);
((GeneralPath)shape).lineTo(30.0, 22.070139);
((GeneralPath)shape).lineTo(30.0, 17.220972);
((GeneralPath)shape).lineTo(29.0, 17.176779);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_25);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_26 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_26
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.0, 17.39775);
((GeneralPath)shape).lineTo(31.0, 22.070139);
((GeneralPath)shape).lineTo(32.0, 22.070139);
((GeneralPath)shape).lineTo(32.0, 17.265167);
((GeneralPath)shape).lineTo(31.0, 17.39775);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_26);
g.setComposite(AlphaComposite.getInstance(3, 0.44943824f * origAlpha));
AffineTransform defaultTransform__0_0_27 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_27
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(33.0, 17.353556);
((GeneralPath)shape).lineTo(33.0, 22.070139);
((GeneralPath)shape).lineTo(34.0, 22.070139);
((GeneralPath)shape).lineTo(34.0, 17.176779);
((GeneralPath)shape).lineTo(33.0, 17.353556);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_27);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_28 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_28
paint = new Color(46, 52, 54, 255);
shape = new RoundRectangle2D.Double(8.0, 35.11613464355469, 31.0, 11.0, 1.63435697555542, 1.63435697555542);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_28);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_29 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_29
paint = new LinearGradientPaint(new Point2D.Double(22.797204971313477, 39.67985916137695), new Point2D.Double(22.797204971313477, 46.63593673706055), new float[] {0.0f,0.8918919f,1.0f}, new Color[] {new Color(238, 238, 236, 255),new Color(222, 222, 218, 255),new Color(131, 131, 117, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.934004008769989f, 0.0f, 1.5579819679260254f));
shape = new RoundRectangle2D.Double(9.0, 36.11613464355469, 29.0, 9.0, 0.2593569755554199, 0.2593569755554199);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_29);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_30 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_30
paint = new Color(143, 89, 2, 255);
shape = new RoundRectangle2D.Double(9.0, 36.11613464355469, 29.0, 3.0000016689300537, 0.2593569755554199, 0.2593569755554199);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_30);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_31 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_31
paint = new Color(233, 185, 110, 255);
shape = new RoundRectangle2D.Double(11.0, 37.11613464355469, 10.036426544189453, 1.999998927116394, 0.2593569755554199, 0.2593569755554199);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_31);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_32 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_32
paint = new Color(233, 185, 110, 255);
shape = new RoundRectangle2D.Double(22.963573455810547, 37.11613464355469, 4.036426544189453, 1.999998927116394, 0.2593569755554199, 0.2593569755554199);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_32);
g.setComposite(AlphaComposite.getInstance(3, 0.17977528f * origAlpha));
AffineTransform defaultTransform__0_0_33 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_33
paint = new LinearGradientPaint(new Point2D.Double(16.84587860107422, 8.67848014831543), new Point2D.Double(30.507823944091797, 78.5052719116211), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.99999976f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(6.8125, 2.5);
((GeneralPath)shape).curveTo(6.6714125, 2.5092413, 6.665484, 2.505736, 6.59375, 2.625);
((GeneralPath)shape).curveTo(6.522016, 2.744264, 6.486054, 2.9918242, 6.5, 3.15625);
((GeneralPath)shape).curveTo(6.501465, 3.1874828, 6.501465, 3.2187672, 6.5, 3.25);
((GeneralPath)shape).lineTo(6.5, 43.5625);
((GeneralPath)shape).curveTo(6.5340896, 44.0761, 6.9647985, 44.68926, 7.8125, 44.625);
((GeneralPath)shape).curveTo(7.8333282, 44.624348, 7.8541718, 44.624348, 7.875, 44.625);
((GeneralPath)shape).lineTo(39.6875, 44.625);
((GeneralPath)shape).curveTo(40.042233, 44.607887, 40.50954, 44.418407, 40.5, 43.34375);
((GeneralPath)shape).lineTo(40.5, 6.4375);
((GeneralPath)shape).curveTo(40.5, 5.9303713, 40.46518, 5.8331404, 40.0625, 5.4375);
((GeneralPath)shape).curveTo(40.051853, 5.4273148, 40.041435, 5.4168954, 40.03125, 5.40625);
((GeneralPath)shape).curveTo(40.03125, 5.40625, 37.37257, 2.6558683, 37.3125, 2.59375);
((GeneralPath)shape).curveTo(37.252808, 2.537358, 37.28322, 2.5655737, 37.28125, 2.5625);
((GeneralPath)shape).curveTo(37.27928, 2.5594263, 37.24993, 2.5312266, 37.25, 2.53125);
((GeneralPath)shape).curveTo(37.250137, 2.5312967, 37.104313, 2.5, 36.75, 2.5);
((GeneralPath)shape).lineTo(6.8125, 2.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_33);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 2;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 1;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 46;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 47;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public MediaFlashSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

