package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class MediaOpticalSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.55f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0662909746170044f, 1.0f, -2.885106086730957f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(23.334524154663086, 41.63603973388672), 22.627417f, new Point2D.Double(23.334524154663086, 41.63603973388672), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.25f, 0.0f, 31.22702980041504f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(45.96194, 41.63604);
((GeneralPath)shape).curveTo(45.96194, 44.760235, 35.831303, 47.292892, 23.334524, 47.292892);
((GeneralPath)shape).curveTo(10.837747, 47.292892, 0.70710754, 44.760235, 0.70710754, 41.63604);
((GeneralPath)shape).curveTo(0.70710754, 38.511845, 10.837747, 35.979187, 23.334524, 35.979187);
((GeneralPath)shape).curveTo(35.831303, 35.979187, 45.96194, 38.511845, 45.96194, 41.63604);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new LinearGradientPaint(new Point2D.Double(14.996600151062012, 11.18850040435791), new Point2D.Double(32.51100158691406, 34.307498931884766), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(235, 235, 235, 255),new Color(255, 255, 255, 255),new Color(235, 235, 235, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.1904759407043457f, 0.0f, 0.0f, 1.1904759407043457f, -4.224423885345459f, -2.5f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.166667);
((GeneralPath)shape).curveTo(12.799386, 4.166667, 3.5136719, 13.452381, 3.5136719, 25.0);
((GeneralPath)shape).curveTo(3.5136719, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.166667, 24.347006, 4.166667);
((GeneralPath)shape).lineTo(24.347006, 4.166667);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(12.274399757385254, 32.416500091552734), new Point2D.Double(35.39120101928711, 14.203300476074219), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(251, 251, 251, 255),new Color(182, 182, 182, 255),new Color(228, 228, 228, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.1904759407043457f, 0.0f, 0.0f, 1.1904759407043457f, -4.224423885345459f, -2.5000009536743164f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(128, 128, 128, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.10999995f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new Color(0, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 14.895835);
((GeneralPath)shape).curveTo(18.70442, 14.895835, 14.24284, 19.488638, 14.24284, 25.0);
((GeneralPath)shape).curveTo(14.24284, 30.642588, 18.835644, 35.104164, 24.347006, 35.104164);
((GeneralPath)shape).curveTo(29.989592, 35.104164, 34.45117, 30.511364, 34.45117, 25.0);
((GeneralPath)shape).curveTo(34.45117, 19.357414, 29.858368, 14.895835, 24.347006, 14.895835);
((GeneralPath)shape).lineTo(24.347006, 14.895835);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.511364);
((GeneralPath)shape).curveTo(21.328878, 30.511364, 18.835644, 28.01813, 18.835644, 25.0);
((GeneralPath)shape).curveTo(18.835644, 21.981873, 21.328878, 19.488638, 24.347006, 19.488638);
((GeneralPath)shape).curveTo(27.365133, 19.488638, 29.858368, 21.981873, 29.858368, 25.0);
((GeneralPath)shape).curveTo(29.858368, 28.01813, 27.365133, 30.511364, 24.347006, 30.511364);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new LinearGradientPaint(new Point2D.Double(21.125, 14.625), new Point2D.Double(29.0, 28.0), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 83),new Color(255, 255, 255, 154)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.25f, 0.0f, 0.0f, 1.25f, -5.6529951095581055f, -2.6041650772094727f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(29.922112, 5.669234);
((GeneralPath)shape).lineTo(26.325518, 19.663897);
((GeneralPath)shape).curveTo(27.450222, 19.963413, 28.34966, 20.659367, 28.960646, 21.622438);
((GeneralPath)shape).lineTo(41.352867, 14.073153);
((GeneralPath)shape).curveTo(38.81762, 9.943439, 34.748657, 6.9050856, 29.922112, 5.669234);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new LinearGradientPaint(new Point2D.Double(21.125, 14.625), new Point2D.Double(29.0, 28.0), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 83),new Color(255, 255, 255, 154)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.25f, 0.0f, 0.0f, 1.25f, -5.6529951095581055f, -2.6041650772094727f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(17.307823, 43.766056);
((GeneralPath)shape).lineTo(22.04308, 30.114557);
((GeneralPath)shape).curveTo(20.946815, 29.723566, 20.107655, 28.956005, 19.577936, 27.945951);
((GeneralPath)shape).lineTo(6.6068754, 34.4506);
((GeneralPath)shape).curveTo(8.793933, 38.77481, 12.599255, 42.13748, 17.307823, 43.766056);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 0.5464481f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new LinearGradientPaint(new Point2D.Double(10.501720428466797, 3.610016107559204), new Point2D.Double(48.798885345458984, 54.698482513427734), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347002, 5.2023654);
((GeneralPath)shape).curveTo(13.373458, 5.2023654, 4.5493712, 14.026454, 4.5493712, 24.999996);
((GeneralPath)shape).curveTo(4.5493712, 35.97354, 13.373458, 44.797626, 24.347002, 44.797626);
((GeneralPath)shape).curveTo(35.320545, 44.797626, 44.144634, 35.97354, 44.144634, 24.999996);
((GeneralPath)shape).curveTo(44.144634, 14.026454, 35.320545, 5.2023654, 24.347002, 5.2023654);
((GeneralPath)shape).lineTo(24.347002, 5.2023654);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 0.6721311f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0883883535861969f, 0.08838865160942078f));
// _0_0_7
paint = new LinearGradientPaint(new Point2D.Double(28.702884674072266, 31.494707107543945), new Point2D.Double(17.74272918701172, 18.366575241088867), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.93053865f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(30.40559, 24.930641);
((GeneralPath)shape).curveTo(30.40559, 28.298914, 27.675066, 31.029438, 24.306793, 31.029438);
((GeneralPath)shape).curveTo(20.938522, 31.029438, 18.207998, 28.298914, 18.207998, 24.930641);
((GeneralPath)shape).curveTo(18.207998, 21.562368, 20.938522, 18.831844, 24.306793, 18.831844);
((GeneralPath)shape).curveTo(27.675066, 18.831844, 30.40559, 21.562368, 30.40559, 24.930641);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 0.1142857f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new RadialGradientPaint(new Point2D.Double(37.751468658447266, 27.56916618347168), 21.333334f, new Point2D.Double(37.751468658447266, 27.56916618347168), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(255, 243, 7, 255),new Color(22, 110, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.8486840128898621f, 0.9580199718475342f, -0.7821189761161804f, 0.6928340196609497f, 18.691469192504883f, -20.525779724121094f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 0.09714284f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new RadialGradientPaint(new Point2D.Double(26.137741088867188, 38.80730438232422), 21.333334f, new Point2D.Double(26.137741088867188, 38.80730438232422), new float[] {0.0f,1.0f,1.0f}, new Color[] {new Color(179, 7, 255, 210),new Color(240, 255, 139, 164),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7695009708404541f, -1.2424999475479126f, 0.6703000068664551f, 0.4151409864425659f, -21.7785701751709f, 41.365631103515625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 0.71428573f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new RadialGradientPaint(new Point2D.Double(53.556888580322266, 48.2382698059082), 21.333334f, new Point2D.Double(53.556888580322266, 48.2382698059082), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(184, 192, 76, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.15845000743865967f, -0.15898799896240234f, 0.43290698528289795f, 0.4314410090446472f, -2.723644971847534f, 15.001070022583008f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 0.62285715f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new RadialGradientPaint(new Point2D.Double(16.885271072387695, 33.377593994140625), 21.333334f, new Point2D.Double(16.885271072387695, 33.377593994140625), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 200, 255),new Color(154, 145, 239, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.005184267181903124f, -0.12285999953746796f, 0.544547975063324f, 0.022978240624070168f, 0.9572340250015259f, 26.307559967041016f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 0.3714286f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_12
paint = new RadialGradientPaint(new Point2D.Double(35.511295318603516, 21.61801528930664), 21.333334f, new Point2D.Double(35.511295318603516, 21.61801528930664), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 200, 255),new Color(154, 145, 239, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.10591600090265274f, -0.019142400473356247f, 0.10478899627923965f, 0.5798069834709167f, 17.136930465698242f, 7.1151580810546875f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 0.23428573f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_13
paint = new RadialGradientPaint(new Point2D.Double(133.84107971191406, 23.914304733276367), 21.333334f, new Point2D.Double(133.84107971191406, 23.914304733276367), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 200, 255),new Color(154, 145, 239, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.05048219859600067f, 0.013878470286726952f, -0.1284399926662445f, -0.467195987701416f, 35.41257095336914f, 39.44171905517578f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.347006, 4.1666665);
((GeneralPath)shape).curveTo(12.799386, 4.1666665, 3.513672, 13.452381, 3.513672, 25.0);
((GeneralPath)shape).curveTo(3.513672, 36.54762, 12.799386, 45.833336, 24.347006, 45.833336);
((GeneralPath)shape).curveTo(35.894627, 45.833336, 45.18034, 36.54762, 45.18034, 25.0);
((GeneralPath)shape).curveTo(45.18034, 13.452381, 35.894627, 4.1666665, 24.347006, 4.1666665);
((GeneralPath)shape).lineTo(24.347006, 4.1666665);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(24.347006, 30.000002);
((GeneralPath)shape).curveTo(21.608912, 30.000002, 19.347006, 27.738096, 19.347006, 25.0);
((GeneralPath)shape).curveTo(19.347006, 22.261906, 21.608912, 20.0, 24.347006, 20.0);
((GeneralPath)shape).curveTo(27.0851, 20.0, 29.347006, 22.261906, 29.347006, 25.0);
((GeneralPath)shape).curveTo(29.347006, 27.738096, 27.0851, 30.000002, 24.347006, 30.000002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_13);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 2;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 4;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 46;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 44;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public MediaOpticalSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

