package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class NetworkWiredSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.40641713f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(2.7527360916137695f, 1.438439965248108f, -2.4554219245910645f, 4.679605007171631f, 48.40044021606445f, -223.04119873046875f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(30.203561782836914, 44.56548309326172), 6.5659914f, new Point2D.Double(30.203561782836914, 44.56548309326172), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 7.106945902386972E-17f, -4.3594999085055724E-17f, 0.3384619951248169f, -5.036556837822309E-14f, 29.481779098510742f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.769554, 44.565483);
((GeneralPath)shape).curveTo(36.769554, 45.792847, 33.82986, 46.78782, 30.203562, 46.78782);
((GeneralPath)shape).curveTo(26.577265, 46.78782, 23.63757, 45.792847, 23.63757, 44.565483);
((GeneralPath)shape).curveTo(23.63757, 43.33812, 26.577265, 42.343147, 30.203562, 42.343147);
((GeneralPath)shape).curveTo(33.82986, 42.343147, 36.769554, 43.33812, 36.769554, 44.565483);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new Color(72, 72, 72, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.80097, 5.8182116);
((GeneralPath)shape).lineTo(5.1577077, 12.516803);
((GeneralPath)shape).lineTo(5.4153447, 18.657177);
((GeneralPath)shape).lineTo(23.407072, 34.845436);
((GeneralPath)shape).lineTo(35.000786, 24.110516);
((GeneralPath)shape).lineTo(35.258423, 17.411926);
((GeneralPath)shape).lineTo(12.80097, 5.8182116);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(77, 77, 77, 255);
stroke = new BasicStroke(1.9999999f,1,1,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.80097, 5.8182116);
((GeneralPath)shape).lineTo(5.1577077, 12.516803);
((GeneralPath)shape).lineTo(5.4153447, 18.657177);
((GeneralPath)shape).lineTo(23.407072, 34.845436);
((GeneralPath)shape).lineTo(35.000786, 24.110516);
((GeneralPath)shape).lineTo(35.258423, 17.411926);
((GeneralPath)shape).lineTo(12.80097, 5.8182116);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new Color(166, 166, 166, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.0704026, 12.658182);
((GeneralPath)shape).lineTo(5.317116, 18.579296);
((GeneralPath)shape).lineTo(23.57389, 34.61565);
((GeneralPath)shape).lineTo(23.327177, 28.20111);
((GeneralPath)shape).lineTo(5.0704026, 12.658182);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new Color(127, 127, 127, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.327177, 28.20111);
((GeneralPath)shape).lineTo(23.327177, 34.73901);
((GeneralPath)shape).lineTo(34.922695, 24.006987);
((GeneralPath)shape).lineTo(35.169407, 17.345732);
((GeneralPath)shape).lineTo(23.327177, 28.20111);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new LinearGradientPaint(new Point2D.Double(65.62396240234375, 21.45977783203125), new Point2D.Double(87.52896881103516, 21.45977783203125), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(229, 229, 229, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3740700483322144f, 0.0f, 0.0f, 1.3740700483322144f, -85.10150146484375f, -12.38821029663086f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.0704026, 12.669106);
((GeneralPath)shape).lineTo(23.57389, 28.447823);
((GeneralPath)shape).lineTo(35.169407, 17.592443);
((GeneralPath)shape).lineTo(12.71851, 5.750214);
((GeneralPath)shape).lineTo(5.0704026, 12.669106);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(255, 193, 26, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(6.2664924, 11.644777);
((GeneralPath)shape).lineTo(9.1411705, 13.645034);
((GeneralPath)shape).curveTo(9.1411705, 13.645034, 9.819632, 13.891747, 10.128023, 13.645034);
((GeneralPath)shape).curveTo(10.436414, 13.398322, 10.374736, 12.658182, 10.374736, 12.658182);
((GeneralPath)shape).lineTo(7.500058, 10.400285);
((GeneralPath)shape).lineTo(6.2664924, 11.644777);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(255, 193, 26, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(8.401031, 9.671071);
((GeneralPath)shape).lineTo(11.361588, 11.671328);
((GeneralPath)shape).curveTo(11.361588, 11.671328, 12.040051, 11.918041, 12.348442, 11.671328);
((GeneralPath)shape).curveTo(12.656831, 11.424616, 12.595154, 10.684476, 12.595154, 10.684476);
((GeneralPath)shape).lineTo(9.720477, 8.426579);
((GeneralPath)shape).lineTo(8.401031, 9.671071);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new Color(255, 193, 26, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(10.583973, 7.7348437);
((GeneralPath)shape).lineTo(13.458651, 9.820981);
((GeneralPath)shape).curveTo(13.458651, 9.820981, 14.137112, 10.067694, 14.445505, 9.820981);
((GeneralPath)shape).curveTo(14.753896, 9.574267, 14.692216, 8.834126, 14.692216, 8.834126);
((GeneralPath)shape).lineTo(11.731658, 6.4903526);
((GeneralPath)shape).lineTo(10.583973, 7.7348437);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 0.34224597f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(1.0f,1,1,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.829749, 6.368914);
((GeneralPath)shape).lineTo(5.747854, 13.004915);
((GeneralPath)shape).lineTo(5.9865694, 18.350786);
((GeneralPath)shape).lineTo(23.25803, 33.86536);
((GeneralPath)shape).lineTo(34.34375, 23.57536);
((GeneralPath)shape).lineTo(34.582466, 17.96991);
((GeneralPath)shape).lineTo(12.829749, 6.368914);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new LinearGradientPaint(new Point2D.Double(88.75, 31.65625), new Point2D.Double(92.0625, 36.65625), new float[] {0.0f,1.0f}, new Color[] {new Color(81, 81, 82, 255),new Color(81, 81, 82, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3740700483322144f, 0.0f, 0.0f, 1.3740700483322144f, -84.45864868164062f, -12.066789627075195f));
stroke = new BasicStroke(5.0f,1,2,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.564354, 28.210627);
((GeneralPath)shape).curveTo(31.564354, 28.210627, 37.40415, 30.52937, 40.495808, 35.252735);
((GeneralPath)shape).curveTo(43.587463, 39.976097, 45.30505, 46.846447, 45.30505, 46.846447);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new RadialGradientPaint(new Point2D.Double(88.593017578125, 33.3986701965332), 7.005614f, new Point2D.Double(88.593017578125, 33.3986701965332), new float[] {0.0f,1.0E-9f,1.0f}, new Color[] {new Color(204, 204, 205, 255),new Color(173, 173, 174, 255),new Color(143, 143, 144, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.8894439935684204f, 0.2092220038175583f, -0.17864499986171722f, 0.7594540119171143f, -34.97669982910156f, -11.864450454711914f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(32.200706, 26.732643);
((GeneralPath)shape).curveTo(31.367882, 26.833529, 30.70943, 27.486206, 30.601215, 28.318111);
((GeneralPath)shape).curveTo(30.492998, 29.150019, 30.962563, 29.94943, 31.741863, 30.260021);
((GeneralPath)shape).curveTo(31.741863, 30.260021, 36.6252, 32.925232, 38.26074, 35.423973);
((GeneralPath)shape).curveTo(40.0495, 38.156803, 41.243237, 42.622124, 41.243237, 42.622124);
((GeneralPath)shape).curveTo(41.49665, 43.6041, 42.498135, 44.194717, 43.480114, 43.941303);
((GeneralPath)shape).curveTo(44.46209, 43.68789, 45.052708, 42.686405, 44.799294, 41.70443);
((GeneralPath)shape).curveTo(44.799294, 41.70443, 43.698803, 36.992825, 41.35795, 33.416523);
((GeneralPath)shape).curveTo(38.863876, 29.60613, 33.1184, 26.876032, 33.1184, 26.876032);
((GeneralPath)shape).curveTo(32.829857, 26.750353, 32.51384, 26.700975, 32.200706, 26.732643);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new Color(160, 160, 161, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(15.925782, 15.865453);
((GeneralPath)shape).lineTo(30.975286, 27.214258);
((GeneralPath)shape).curveTo(32.70228, 28.324467, 34.36759, 27.029222, 35.416122, 25.733978);
((GeneralPath)shape).curveTo(36.464653, 24.438734, 36.279617, 22.896778, 35.169407, 22.03328);
((GeneralPath)shape).lineTo(19.133053, 13.39832);
((GeneralPath)shape).lineTo(15.925782, 15.865453);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_12
paint = new LinearGradientPaint(new Point2D.Double(84.99896240234375, 25.20977783203125), new Point2D.Double(62.591468811035156, 12.02227783203125), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(229, 229, 229, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3740700483322144f, 0.0f, 0.0f, 1.3740700483322144f, -85.10150146484375f, -12.38821029663086f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(15.309, 15.865453);
((GeneralPath)shape).lineTo(30.72857, 25.240553);
((GeneralPath)shape).curveTo(31.592068, 25.857334, 33.442413, 25.117197, 34.182556, 24.253702);
((GeneralPath)shape).curveTo(34.922695, 23.390203, 34.305912, 22.15664, 33.689133, 21.78657);
((GeneralPath)shape).lineTo(19.009695, 13.02825);
((GeneralPath)shape).lineTo(15.309, 15.865453);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 0;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 5;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 48;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 44;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public NetworkWiredSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

