package org.freedesktop.tango.emblems;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class EmblemImportantSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.4090909f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(2.1829121112823486f, 0.0f, 0.0f, 2.1829121112823486f, -13.5037202835083f, -14.350119590759277f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(17.3125, 25.53125), 9.6875f, new Point2D.Double(17.3125, 25.53125), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.35161298513412476f, 1.2928029881090707E-15f, 16.55413055419922f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.0, 25.53125);
((GeneralPath)shape).curveTo(27.0, 27.41247, 22.662758, 28.9375, 17.3125, 28.9375);
((GeneralPath)shape).curveTo(11.962241, 28.9375, 7.625, 27.41247, 7.625, 25.53125);
((GeneralPath)shape).curveTo(7.625, 23.65003, 11.962241, 22.125, 17.3125, 22.125);
((GeneralPath)shape).curveTo(22.662758, 22.125, 27.0, 23.65003, 27.0, 25.53125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(0.9446300268173218f, 0.0f, 0.0f, 0.9800530076026917f, 1.504173994064331f, -1.5569119453430176f));
// _0_0_1
paint = new Color(245, 121, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.138718, 23.42804);
((GeneralPath)shape).curveTo(46.138718, 35.14377, 36.285088, 44.641243, 24.130018, 44.641243);
((GeneralPath)shape).curveTo(11.974949, 44.641243, 2.1213188, 35.14377, 2.1213188, 23.42804);
((GeneralPath)shape).curveTo(2.1213188, 11.712311, 11.974949, 2.2148361, 24.130018, 2.2148361);
((GeneralPath)shape).curveTo(36.285088, 2.2148361, 46.138718, 11.712311, 46.138718, 23.42804);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(145, 73, 0, 255);
stroke = new BasicStroke(0.9821494f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.138718, 23.42804);
((GeneralPath)shape).curveTo(46.138718, 35.14377, 36.285088, 44.641243, 24.130018, 44.641243);
((GeneralPath)shape).curveTo(11.974949, 44.641243, 2.1213188, 35.14377, 2.1213188, 23.42804);
((GeneralPath)shape).curveTo(2.1213188, 11.712311, 11.974949, 2.2148361, 24.130018, 2.2148361);
((GeneralPath)shape).curveTo(36.285088, 2.2148361, 46.138718, 11.712311, 46.138718, 23.42804);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(0.9140859842300415f, 0.0f, 0.0f, 0.9483640193939209f, 2.3805758953094482f, -0.9058150053024292f));
// _0_0_2
paint = new Color(252, 175, 62, 255);
stroke = new BasicStroke(0.9821494f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.138718, 23.42804);
((GeneralPath)shape).curveTo(46.138718, 35.14377, 36.285088, 44.641243, 24.130018, 44.641243);
((GeneralPath)shape).curveTo(11.974949, 44.641243, 2.1213188, 35.14377, 2.1213188, 23.42804);
((GeneralPath)shape).curveTo(2.1213188, 11.712311, 11.974949, 2.2148361, 24.130018, 2.2148361);
((GeneralPath)shape).curveTo(36.285088, 2.2148361, 46.138718, 11.712311, 46.138718, 23.42804);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.464926, 10.373268);
((GeneralPath)shape).curveTo(21.336952, 10.373268, 21.230316, 10.547762, 21.230316, 10.757175);
((GeneralPath)shape).lineTo(22.295086, 25.197998);
((GeneralPath)shape).curveTo(22.295086, 25.407412, 22.40172, 25.581905, 22.529696, 25.581907);
((GeneralPath)shape).curveTo(22.529696, 25.581907, 23.370516, 25.59381, 24.063684, 25.581907);
((GeneralPath)shape).curveTo(24.292023, 25.577986, 24.361898, 25.602219, 24.568998, 25.581907);
((GeneralPath)shape).curveTo(25.262165, 25.59381, 26.102987, 25.581907, 26.102987, 25.581907);
((GeneralPath)shape).curveTo(26.23096, 25.581907, 26.337597, 25.407412, 26.337597, 25.197998);
((GeneralPath)shape).lineTo(27.402367, 10.757175);
((GeneralPath)shape).curveTo(27.402367, 10.547762, 27.29573, 10.402799, 27.167755, 10.402799);
((GeneralPath)shape).lineTo(24.587044, 10.402799);
((GeneralPath)shape).curveTo(24.577532, 10.400862, 24.578842, 10.373268, 24.568998, 10.373268);
((GeneralPath)shape).lineTo(21.464926, 10.373268);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(0.504863977432251f, 0.0f, 0.0f, 0.6041820049285889f, 32.65935134887695f, 9.608844757080078f));
// _0_0_4
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-11.875, 34.0625);
((GeneralPath)shape).curveTo(-11.875, 36.168087, -13.917701, 37.875, -16.4375, 37.875);
((GeneralPath)shape).curveTo(-18.957298, 37.875, -21.0, 36.168087, -21.0, 34.0625);
((GeneralPath)shape).curveTo(-21.0, 31.956915, -18.957298, 30.25, -16.4375, 30.25);
((GeneralPath)shape).curveTo(-13.917701, 30.25, -11.875, 31.956915, -11.875, 34.0625);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(255, 254, 255, 55);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.676426, 20.47678);
((GeneralPath)shape).curveTo(43.676426, 31.307396, 37.624256, 16.170582, 25.001688, 20.863169);
((GeneralPath)shape).curveTo(12.279172, 25.592913, 4.4350533, 31.307396, 4.4350533, 20.47678);
((GeneralPath)shape).curveTo(4.4350533, 9.646163, 13.22512, 0.8560977, 24.05574, 0.8560977);
((GeneralPath)shape).curveTo(34.88636, 0.8560977, 43.676426, 9.646163, 43.676426, 20.47678);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 4;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 1;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 43;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 48;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public EmblemImportantSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

