package org.freedesktop.tango.emotes;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class FaceDevilishSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new LinearGradientPaint(new Point2D.Double(39.125, 33.375), new Point2D.Double(46.625, 16.5), new float[] {0.0f,1.0f}, new Color[] {new Color(115, 0, 0, 255),new Color(255, 2, 2, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7807459831237793f, 0.0f, 0.0f, 0.7807459831237793f, 9.900195121765137f, 9.256071090698242f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.435547, 37.51434);
((GeneralPath)shape).curveTo(27.435547, 37.51434, 44.22729, 38.18714, 46.59527, 31.409748);
((GeneralPath)shape).curveTo(48.18382, 26.863153, 41.593613, 24.041454, 41.03245, 20.967266);
((GeneralPath)shape).curveTo(40.47129, 17.893078, 44.350624, 18.673824, 44.350624, 18.673824);
((GeneralPath)shape).lineTo(44.984978, 19.942537);
((GeneralPath)shape).lineTo(47.278423, 17.209925);
((GeneralPath)shape).lineTo(43.179504, 16.673162);
((GeneralPath)shape).lineTo(43.96025, 17.990671);
((GeneralPath)shape).curveTo(43.96025, 17.990671, 40.17851, 17.380713, 40.05652, 20.674486);
((GeneralPath)shape).curveTo(39.93453, 23.96826, 46.709244, 28.16477, 44.367004, 31.409748);
((GeneralPath)shape).curveTo(42.024765, 34.654724, 30.687563, 33.654392, 30.687563, 33.654392);
((GeneralPath)shape).lineTo(27.435547, 37.51434);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 0.5316456f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.1636470556259155f, 0.0f, 0.0f, 1.0f, -4.772740840911865f, -0.7954949736595154f));
// _0_0_1
paint = new RadialGradientPaint(new Point2D.Double(24.714284896850586, 38.57143020629883), 19.714285f, new Point2D.Double(24.714284896850586, 38.57143020629883), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.33333298563957214f, -1.2392420243597475E-15f, 25.714290618896484f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.42857, 38.57143);
((GeneralPath)shape).curveTo(44.42857, 42.20073, 35.602184, 45.14286, 24.714285, 45.14286);
((GeneralPath)shape).curveTo(13.826386, 45.14286, 5.0, 42.20073, 5.0, 38.57143);
((GeneralPath)shape).curveTo(5.0, 34.94213, 13.826386, 32.0, 24.714285, 32.0);
((GeneralPath)shape).curveTo(35.602184, 32.0, 44.42857, 34.94213, 44.42857, 38.57143);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(2.083142042160034f, 0.0f, 0.0f, 2.083142042160034f, -44.50164031982422f, -16.49224090576172f));
// _0_0_2
paint = new RadialGradientPaint(new Point2D.Double(30.56110382080078, 15.699057579040527), 8.90208f, new Point2D.Double(30.56110382080078, 15.699057579040527), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 161, 7, 255),new Color(204, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7712159752845764f, 8.401155997509889E-17f, -8.401155997509889E-17f, 0.7712159752845764f, 6.991896152496338f, 3.5916950702667236f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.774754, 19.008621);
((GeneralPath)shape).curveTo(39.776207, 22.104244, 38.125546, 24.96534, 35.4449, 26.51357);
((GeneralPath)shape).curveTo(32.76425, 28.061802, 29.461142, 28.061802, 26.780495, 26.51357);
((GeneralPath)shape).curveTo(24.099848, 24.96534, 22.449186, 22.104244, 22.45064, 19.008621);
((GeneralPath)shape).curveTo(22.449186, 15.912998, 24.099848, 13.051903, 26.780495, 11.503672);
((GeneralPath)shape).curveTo(29.461142, 9.9554405, 32.76425, 9.9554405, 35.4449, 11.503672);
((GeneralPath)shape).curveTo(38.125546, 13.051903, 39.776207, 15.912998, 39.774754, 19.008621);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(164, 0, 0, 255);
stroke = new BasicStroke(0.48004404f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.774754, 19.008621);
((GeneralPath)shape).curveTo(39.776207, 22.104244, 38.125546, 24.96534, 35.4449, 26.51357);
((GeneralPath)shape).curveTo(32.76425, 28.061802, 29.461142, 28.061802, 26.780495, 26.51357);
((GeneralPath)shape).curveTo(24.099848, 24.96534, 22.449186, 22.104244, 22.45064, 19.008621);
((GeneralPath)shape).curveTo(22.449186, 15.912998, 24.099848, 13.051903, 26.780495, 11.503672);
((GeneralPath)shape).curveTo(29.461142, 9.9554405, 32.76425, 9.9554405, 35.4449, 11.503672);
((GeneralPath)shape).curveTo(38.125546, 13.051903, 39.776207, 15.912998, 39.774754, 19.008621);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.4318182f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.979781985282898f, 0.0f, 0.0f, 1.979781985282898f, -41.285770416259766f, -14.527460098266602f));
// _0_0_3
paint = new LinearGradientPaint(new Point2D.Double(28.764467239379883, 12.221258163452148), new Point2D.Double(38.07002258300781, 38.297359466552734), new float[] {0.0f,1.0f}, new Color[] {new Color(242, 213, 101, 255),new Color(242, 213, 101, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.5051063f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.774754, 19.008621);
((GeneralPath)shape).curveTo(39.776207, 22.104244, 38.125546, 24.96534, 35.4449, 26.51357);
((GeneralPath)shape).curveTo(32.76425, 28.061802, 29.461142, 28.061802, 26.780495, 26.51357);
((GeneralPath)shape).curveTo(24.099848, 24.96534, 22.449186, 22.104244, 22.45064, 19.008621);
((GeneralPath)shape).curveTo(22.449186, 15.912998, 24.099848, 13.051903, 26.780495, 11.503672);
((GeneralPath)shape).curveTo(29.461142, 9.9554405, 32.76425, 9.9554405, 35.4449, 11.503672);
((GeneralPath)shape).curveTo(38.125546, 13.051903, 39.776207, 15.912998, 39.774754, 19.008621);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(-0.9659259915351868f, -0.25881901383399963f, 0.25881901383399963f, -0.9659259915351868f, 20.57992935180664f, 17.201309204101562f));
// _0_0_4
paint = new Color(0, 0, 0, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-0.875, 1.875);
((GeneralPath)shape).curveTo(-0.875, 3.1762414, -1.7679925, 4.315251, -3.052219, 4.6520367);
((GeneralPath)shape).curveTo(-4.336446, 4.988823, -5.691685, 4.439408, -6.3564496, 3.3125);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(-0.9659259915351868f, -0.25881901383399963f, 0.25881901383399963f, -0.9659259915351868f, 11.829930305480957f, 17.201309204101562f));
// _0_0_5
paint = new Color(0, 0, 0, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-0.875, 1.875);
((GeneralPath)shape).curveTo(-0.875, 3.1762414, -1.7679925, 4.315251, -3.052219, 4.6520367);
((GeneralPath)shape).curveTo(-4.336446, 4.988823, -5.691685, 4.439408, -6.3564496, 3.3125);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new LinearGradientPaint(new Point2D.Double(9.789263725280762, 29.629091262817383), new Point2D.Double(38.39073181152344, 29.629091262817383), new float[] {0.0f,0.34579438f,0.7248668f,1.0f}, new Color[] {new Color(204, 204, 204, 255),new Color(255, 255, 255, 255),new Color(255, 255, 255, 255),new Color(206, 206, 206, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0488970279693604f, 0.0f, 0.0f, 1.0f, -5.222438812255859f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.2330303, 21.04477);
((GeneralPath)shape).curveTo(3.694049, 28.612146, 9.925067, 38.212296, 20.084179, 38.212296);
((GeneralPath)shape).curveTo(30.331676, 38.212296, 36.589706, 29.781872, 34.80422, 21.10727);
((GeneralPath)shape).lineTo(5.2330303, 21.04477);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 0.18181817f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new LinearGradientPaint(new Point2D.Double(14.0, 21.0625), new Point2D.Double(14.0, 34.30552673339844), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.4045230150222778f, 6.545492172241211f, -7.9663310050964355f));
stroke = new BasicStroke(0.9999999f,2,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(20.545492, 21.528658);
((GeneralPath)shape).lineTo(20.545492, 38.382935);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 0.18181817f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new LinearGradientPaint(new Point2D.Double(14.0, 21.0625), new Point2D.Double(13.5, 33.42667007446289), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.1718950271606445f, -1.4545079469680786f, -3.1411659717559814f));
stroke = new BasicStroke(1.0000002f,2,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.545492, 21.468636);
((GeneralPath)shape).lineTo(12.545492, 35.53138);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 0.18181817f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new LinearGradientPaint(new Point2D.Double(14.0, 21.0625), new Point2D.Double(14.5, 33.431156158447266), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.1598149538040161f, 14.545510292053223f, -2.815047025680542f));
stroke = new BasicStroke(1.0000005f,2,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(28.545492, 21.541107);
((GeneralPath)shape).lineTo(28.545492, 35.458908);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new Color(164, 0, 0, 255);
stroke = new BasicStroke(0.99999994f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.4864345, 20.615864);
((GeneralPath)shape).curveTo(3.7057798, 29.43779, 10.645446, 38.703674, 20.295492, 38.703674);
((GeneralPath)shape).curveTo(30.299038, 38.703674, 36.94771, 29.12529, 34.667053, 20.553364);
((GeneralPath)shape).lineTo(5.4864345, 20.615864);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new LinearGradientPaint(new Point2D.Double(30.525611877441406, 7.360970497131348), new Point2D.Double(32.31150817871094, 9.423470497131348), new float[] {0.0f,0.27586207f,1.0f}, new Color[] {new Color(204, 0, 0, 255),new Color(200, 74, 0, 255),new Color(190, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.535408, 4.733087);
((GeneralPath)shape).curveTo(34.40974, 4.7565975, 34.28913, 4.8018265, 34.17899, 4.866744);
((GeneralPath)shape).lineTo(28.20897, 8.141345);
((GeneralPath)shape).curveTo(27.900648, 8.318115, 27.588425, 8.638695, 27.661316, 8.986539);
((GeneralPath)shape).curveTo(28.098501, 11.072856, 29.745255, 12.500002, 31.965366, 12.74992);
((GeneralPath)shape).curveTo(32.299534, 12.787537, 32.577312, 12.472421, 32.731037, 12.173337);
((GeneralPath)shape).lineTo(35.69377, 6.314697);
((GeneralPath)shape).curveTo(35.87989, 5.9453697, 35.843224, 5.502876, 35.598858, 5.169219);
((GeneralPath)shape).curveTo(35.35449, 4.8355618, 34.943684, 4.667085, 34.535408, 4.733087);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(164, 0, 0, 255);
stroke = new BasicStroke(0.99999946f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.535408, 4.733087);
((GeneralPath)shape).curveTo(34.40974, 4.7565975, 34.28913, 4.8018265, 34.17899, 4.866744);
((GeneralPath)shape).lineTo(28.20897, 8.141345);
((GeneralPath)shape).curveTo(27.900648, 8.318115, 27.588425, 8.638695, 27.661316, 8.986539);
((GeneralPath)shape).curveTo(28.098501, 11.072856, 29.745255, 12.500002, 31.965366, 12.74992);
((GeneralPath)shape).curveTo(32.299534, 12.787537, 32.577312, 12.472421, 32.731037, 12.173337);
((GeneralPath)shape).lineTo(35.69377, 6.314697);
((GeneralPath)shape).curveTo(35.87989, 5.9453697, 35.843224, 5.502876, 35.598858, 5.169219);
((GeneralPath)shape).curveTo(35.35449, 4.8355618, 34.943684, 4.667085, 34.535408, 4.733087);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_12
paint = new LinearGradientPaint(new Point2D.Double(10.400611877441406, 7.610970497131348), new Point2D.Double(8.811508178710938, 9.673470497131348), new float[] {0.0f,0.27586207f,1.0f}, new Color[] {new Color(204, 0, 0, 255),new Color(200, 74, 0, 255),new Color(190, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(6.926716, 4.858087);
((GeneralPath)shape).curveTo(7.052384, 4.8815975, 7.1729937, 4.9268265, 7.283135, 4.991744);
((GeneralPath)shape).lineTo(13.253153, 8.266345);
((GeneralPath)shape).curveTo(13.561473, 8.443115, 13.873698, 8.763695, 13.800807, 9.111539);
((GeneralPath)shape).curveTo(13.363621, 11.197856, 11.716867, 12.625002, 9.496759, 12.87492);
((GeneralPath)shape).curveTo(9.162593, 12.912537, 8.884812, 12.597421, 8.731088, 12.298337);
((GeneralPath)shape).lineTo(5.7683535, 6.439697);
((GeneralPath)shape).curveTo(5.582235, 6.0703697, 5.618901, 5.627876, 5.863269, 5.294219);
((GeneralPath)shape).curveTo(6.107637, 4.9605618, 6.5184426, 4.792085, 6.926716, 4.858087);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(164, 0, 0, 255);
stroke = new BasicStroke(0.99999946f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(6.926716, 4.858087);
((GeneralPath)shape).curveTo(7.052384, 4.8815975, 7.1729937, 4.9268265, 7.283135, 4.991744);
((GeneralPath)shape).lineTo(13.253153, 8.266345);
((GeneralPath)shape).curveTo(13.561473, 8.443115, 13.873698, 8.763695, 13.800807, 9.111539);
((GeneralPath)shape).curveTo(13.363621, 11.197856, 11.716867, 12.625002, 9.496759, 12.87492);
((GeneralPath)shape).curveTo(9.162593, 12.912537, 8.884812, 12.597421, 8.731088, 12.298337);
((GeneralPath)shape).lineTo(5.7683535, 6.439697);
((GeneralPath)shape).curveTo(5.582235, 6.0703697, 5.618901, 5.627876, 5.863269, 5.294219);
((GeneralPath)shape).curveTo(6.107637, 4.9605618, 6.5184426, 4.792085, 6.926716, 4.858087);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 0.64772725f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_13
paint = new LinearGradientPaint(new Point2D.Double(32.09855270385742, 6.145458698272705), new Point2D.Double(31.775375366210938, 8.044363021850586), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 217, 60, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.99999946f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.550144, 5.796203);
((GeneralPath)shape).lineTo(28.942862, 8.833169);
((GeneralPath)shape).curveTo(28.751833, 8.955361, 28.700764, 8.958827, 28.763168, 9.196438);
((GeneralPath)shape).curveTo(29.043278, 10.262955, 30.424664, 11.448342, 31.495275, 11.709487);
((GeneralPath)shape).curveTo(31.721107, 11.764572, 31.918285, 11.628151, 32.024548, 11.421409);
((GeneralPath)shape).lineTo(34.779644, 5.9132166);
((GeneralPath)shape).curveTo(34.9083, 5.6579194, 34.626278, 5.7513285, 34.550144, 5.796203);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_13);
g.setComposite(AlphaComposite.getInstance(3, 0.64772725f * origAlpha));
AffineTransform defaultTransform__0_0_14 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_14
paint = new LinearGradientPaint(new Point2D.Double(7.223550796508789, 6.020458698272705), new Point2D.Double(8.087875366210938, 8.044363021850586), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 217, 60, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.99999946f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(6.903521, 5.9729795);
((GeneralPath)shape).lineTo(12.510802, 9.009946);
((GeneralPath)shape).curveTo(12.701831, 9.132138, 12.7529, 9.135604, 12.690495, 9.373215);
((GeneralPath)shape).curveTo(12.410387, 10.439732, 11.029, 11.625119, 9.958388, 11.886264);
((GeneralPath)shape).curveTo(9.732557, 11.941349, 9.535379, 11.804928, 9.429118, 11.598186);
((GeneralPath)shape).lineTo(6.6740212, 6.0899935);
((GeneralPath)shape).curveTo(6.5453663, 5.8346963, 6.8273864, 5.9281054, 6.903521, 5.9729795);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_14);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 2;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 4;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 47;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 41;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public FaceDevilishSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

