package org.freedesktop.tango.mimetypes;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class ApplicationXExecutableSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.1863800287246704f, 0.0f, 0.0f, 1.1863800287246704f, -4.539687156677246f, -7.794678211212158f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(14.287617683410645, 68.87297058105469), 11.68987f, new Point2D.Double(14.287617683410645, 72.56800079345703), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 83),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.399258017539978f, -2.2344450201217114E-7f, 8.196177958552653E-8f, 0.513264000415802f, 4.365074157714844f, 4.839284896850586f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.285713, 38.714287);
((GeneralPath)shape).curveTo(44.287918, 42.22952, 40.490032, 45.478195, 34.323208, 47.236126);
((GeneralPath)shape).curveTo(28.156382, 48.994057, 20.557903, 48.994057, 14.391077, 47.236126);
((GeneralPath)shape).curveTo(8.224251, 45.478195, 4.4263687, 42.22952, 4.4285717, 38.714287);
((GeneralPath)shape).curveTo(4.4263687, 35.199055, 8.224251, 31.950378, 14.391077, 30.192446);
((GeneralPath)shape).curveTo(20.557903, 28.434515, 28.156382, 28.434515, 34.323208, 30.192446);
((GeneralPath)shape).curveTo(40.490032, 31.950378, 44.287918, 35.199055, 44.285713, 38.714287);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setTransform(defaultTransform__0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_1_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_0
paint = new LinearGradientPaint(new Point2D.Double(99.77729797363281, 15.423800468444824), new Point2D.Double(153.00050354003906, 248.631103515625), new float[] {0.0f,1.0f}, new Color[] {new Color(24, 67, 117, 255),new Color(200, 189, 220, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.20068499445915222f, 0.0f, 0.0f, 0.20068499445915222f, -0.5857579708099365f, -1.0507869720458984f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.2858, 43.196358);
((GeneralPath)shape).lineTo(4.3751874, 23.285744);
((GeneralPath)shape).lineTo(24.2858, 3.375129);
((GeneralPath)shape).lineTo(44.196415, 23.285744);
((GeneralPath)shape).lineTo(24.2858, 43.196358);
((GeneralPath)shape).lineTo(24.2858, 43.196358);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(63, 69, 97, 255);
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.2858, 43.196358);
((GeneralPath)shape).lineTo(4.3751874, 23.285744);
((GeneralPath)shape).lineTo(24.2858, 3.375129);
((GeneralPath)shape).lineTo(44.196415, 23.285744);
((GeneralPath)shape).lineTo(24.2858, 43.196358);
((GeneralPath)shape).lineTo(24.2858, 43.196358);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_1_0);
g.setComposite(AlphaComposite.getInstance(3, 0.72f * origAlpha));
AffineTransform defaultTransform__0_1_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_1
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.505062, 23.285744);
((GeneralPath)shape).lineTo(24.2858, 4.066482);
((GeneralPath)shape).lineTo(5.0665402, 23.285744);
((GeneralPath)shape).lineTo(5.8476076, 23.910675);
((GeneralPath)shape).lineTo(24.45724, 5.482543);
((GeneralPath)shape).lineTo(43.505257, 23.285744);
((GeneralPath)shape).lineTo(43.505062, 23.285744);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_1);
g.setComposite(AlphaComposite.getInstance(3, 0.49999997f * origAlpha));
AffineTransform defaultTransform__0_1_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_2
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(8.925773, 27.145172);
((GeneralPath)shape).lineTo(9.664223, 26.120989);
((GeneralPath)shape).curveTo(10.300972, 26.38948, 10.964841, 26.606056, 11.650406, 26.765873);
((GeneralPath)shape).lineTo(11.644594, 28.342731);
((GeneralPath)shape).curveTo(12.072322, 28.431067, 12.507604, 28.498867, 12.948699, 28.547102);
((GeneralPath)shape).lineTo(13.430473, 27.045214);
((GeneralPath)shape).curveTo(13.774514, 27.07369, 14.122237, 27.08938, 14.473834, 27.08938);
((GeneralPath)shape).curveTo(14.825043, 27.08938, 15.172958, 27.073883, 15.517, 27.045214);
((GeneralPath)shape).lineTo(15.998775, 28.547102);
((GeneralPath)shape).curveTo(16.440063, 28.498867, 16.87515, 28.431067, 17.30288, 28.342731);
((GeneralPath)shape).lineTo(17.296873, 26.76568);
((GeneralPath)shape).curveTo(17.982632, 26.606056, 18.646307, 26.38948, 19.283056, 26.120989);
((GeneralPath)shape).lineTo(20.205536, 27.40049);
((GeneralPath)shape).curveTo(20.607887, 27.218395, 20.999777, 27.017899, 21.38043, 26.799969);
((GeneralPath)shape).lineTo(20.887613, 25.301952);
((GeneralPath)shape).curveTo(21.484844, 24.939701, 22.049337, 24.528633, 22.575085, 24.07398);
((GeneralPath)shape).lineTo(23.847225, 25.005758);
((GeneralPath)shape).curveTo(24.172865, 24.709179, 24.484554, 24.397488, 24.780943, 24.07185);
((GeneralPath)shape).lineTo(23.849358, 22.799902);
((GeneralPath)shape).curveTo(24.304205, 22.274155, 24.715273, 21.709854, 25.077522, 21.112238);
((GeneralPath)shape).lineTo(26.575539, 21.605247);
((GeneralPath)shape).curveTo(26.79347, 21.2244, 26.994162, 20.832315, 27.175867, 20.43016);
((GeneralPath)shape).lineTo(25.896559, 19.507874);
((GeneralPath)shape).curveTo(26.16505, 18.871124, 26.381626, 18.207254, 26.541637, 17.521498);
((GeneralPath)shape).lineTo(28.118301, 17.527308);
((GeneralPath)shape).curveTo(28.206636, 17.09958, 28.274439, 16.664297, 28.32248, 16.22301);
((GeneralPath)shape).lineTo(26.820784, 15.741236);
((GeneralPath)shape).curveTo(26.849648, 15.397388, 26.86495, 15.049472, 26.86495, 14.698069);
((GeneralPath)shape).curveTo(26.86495, 14.346666, 26.84926, 13.998944, 26.820784, 13.654708);
((GeneralPath)shape).lineTo(28.32248, 13.172934);
((GeneralPath)shape).curveTo(28.274632, 12.73184, 28.206442, 12.296751, 28.118496, 11.86883);
((GeneralPath)shape).lineTo(26.541445, 11.874835);
((GeneralPath)shape).curveTo(26.381626, 11.189076, 26.16505, 10.525208, 25.896753, 9.888654);
((GeneralPath)shape).lineTo(27.176062, 8.966365);
((GeneralPath)shape).curveTo(26.994354, 8.564014, 26.79347, 8.172124, 26.575926, 7.7912755);
((GeneralPath)shape).lineTo(25.077717, 8.2842865);
((GeneralPath)shape).curveTo(24.715466, 7.6868625, 24.304398, 7.1225634, 23.849745, 6.5970097);
((GeneralPath)shape).lineTo(24.78133, 5.3248687);
((GeneralPath)shape).curveTo(24.502958, 5.018989, 24.210253, 4.726864, 23.905922, 4.4467487);
((GeneralPath)shape).lineTo(5.0669274, 23.285938);
((GeneralPath)shape).lineTo(6.073869, 24.29288);
((GeneralPath)shape).lineTo(6.372581, 24.074175);
((GeneralPath)shape).curveTo(6.8983297, 24.528828, 7.462628, 24.939896, 8.060051, 25.302147);
((GeneralPath)shape).lineTo(7.8180985, 26.037304);
((GeneralPath)shape).lineTo(8.926161, 27.145365);
((GeneralPath)shape).lineTo(8.925773, 27.145172);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_2);
g.setComposite(AlphaComposite.getInstance(3, 0.49999997f * origAlpha));
AffineTransform defaultTransform__0_1_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_3
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(28.448977, 32.191116);
((GeneralPath)shape).curveTo(28.448977, 25.706434, 32.682858, 20.211647, 38.536217, 18.317093);
((GeneralPath)shape).lineTo(36.309242, 16.089926);
((GeneralPath)shape).curveTo(36.29239, 16.0969, 36.275345, 16.102905, 36.258682, 16.110073);
((GeneralPath)shape).lineTo(36.07717, 15.858241);
((GeneralPath)shape).lineTo(34.66517, 14.446237);
((GeneralPath)shape).curveTo(34.20199, 14.665137, 33.748497, 14.900697, 33.305855, 15.153885);
((GeneralPath)shape).lineTo(33.999943, 17.263079);
((GeneralPath)shape).curveTo(33.158627, 17.772747, 32.364193, 18.351768, 31.624195, 18.99181);
((GeneralPath)shape).lineTo(29.833084, 17.680151);
((GeneralPath)shape).curveTo(29.374365, 18.09761, 28.935787, 18.536186, 28.51852, 18.994717);
((GeneralPath)shape).lineTo(29.829987, 20.78563);
((GeneralPath)shape).curveTo(29.189945, 21.525826, 28.611118, 22.320257, 28.101255, 23.161379);
((GeneralPath)shape).lineTo(25.991867, 22.467289);
((GeneralPath)shape).curveTo(25.685213, 23.003693, 25.402775, 23.555593, 25.146873, 24.12202);
((GeneralPath)shape).lineTo(26.948055, 25.420315);
((GeneralPath)shape).curveTo(26.570114, 26.316643, 26.265203, 27.251328, 26.040298, 28.216816);
((GeneralPath)shape).lineTo(23.8203, 28.20829);
((GeneralPath)shape).curveTo(23.696127, 28.810556, 23.60043, 29.42348, 23.532824, 30.044342);
((GeneralPath)shape).lineTo(25.647245, 30.72274);
((GeneralPath)shape).curveTo(25.606953, 31.207033, 25.585255, 31.69675, 25.585255, 32.19131);
((GeneralPath)shape).curveTo(25.585255, 32.68606, 25.606953, 33.17578, 25.647245, 33.660072);
((GeneralPath)shape).lineTo(23.532824, 34.33789);
((GeneralPath)shape).curveTo(23.60043, 34.95914, 23.696127, 35.57187, 23.820494, 36.174133);
((GeneralPath)shape).lineTo(26.040298, 36.165806);
((GeneralPath)shape).curveTo(26.265203, 37.13129, 26.570114, 38.065975, 26.948055, 38.962307);
((GeneralPath)shape).lineTo(25.146873, 40.26079);
((GeneralPath)shape).curveTo(25.289255, 40.57558, 25.440742, 40.885723, 25.59901, 41.191216);
((GeneralPath)shape).lineTo(29.403032, 37.38758);
((GeneralPath)shape).curveTo(28.787012, 35.773335, 28.448784, 34.021744, 28.448784, 32.19131);
((GeneralPath)shape).lineTo(28.448977, 32.191116);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_3);
g.setComposite(AlphaComposite.getInstance(3, 0.35f * origAlpha));
AffineTransform defaultTransform__0_1_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_4
paint = new Color(0, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(5.2050476, 23.424252);
((GeneralPath)shape).lineTo(24.2858, 42.505005);
((GeneralPath)shape).lineTo(43.505062, 23.285744);
((GeneralPath)shape).lineTo(42.789963, 22.603525);
((GeneralPath)shape).lineTo(24.310314, 41.041676);
((GeneralPath)shape).lineTo(5.2050476, 23.424059);
((GeneralPath)shape).lineTo(5.2050476, 23.424252);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_4);
g.setTransform(defaultTransform__0_1);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 1;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 3;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 48;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 46;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public ApplicationXExecutableSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

