package org.freedesktop.tango.mimetypes;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class AudioXGenericSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.3f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 2.834645986557007f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(23.25, 35.375), 18.5f, new Point2D.Double(23.25, 35.375), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.3986490070819855f, 0.0f, 21.27280044555664f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.75, 35.375);
((GeneralPath)shape).curveTo(41.75, 39.4481, 33.467266, 42.75, 23.25, 42.75);
((GeneralPath)shape).curveTo(13.032732, 42.75, 4.75, 39.4481, 4.75, 35.375);
((GeneralPath)shape).curveTo(4.75, 31.3019, 13.032732, 28.0, 23.25, 28.0);
((GeneralPath)shape).curveTo(33.467266, 28.0, 41.75, 31.3019, 41.75, 35.375);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new Color(157, 176, 41, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.625, 7.795152);
((GeneralPath)shape).curveTo(41.625, 7.795152, 18.5625, 10.629798, 18.5625, 10.629798);
((GeneralPath)shape).lineTo(18.5625, 32.41105);
((GeneralPath)shape).curveTo(16.916546, 31.853397, 14.630715, 31.707619, 12.125, 32.22355);
((GeneralPath)shape).curveTo(7.7686863, 33.120518, 4.64714, 35.523033, 5.125, 37.5673);
((GeneralPath)shape).curveTo(5.60286, 39.61156, 9.518685, 40.558018, 13.875, 39.66105);
((GeneralPath)shape).curveTo(17.99164, 38.813427, 21.559122, 36.623245, 21.477633, 34.66105);
((GeneralPath)shape).lineTo(21.633883, 15.629798);
((GeneralPath)shape).curveTo(21.633883, 15.629798, 38.56434, 12.734492, 38.56434, 12.734492);
((GeneralPath)shape).lineTo(38.56434, 30.019106);
((GeneralPath)shape).curveTo(28.31434, 28.519106, 25.272139, 32.912342, 25.75, 34.956608);
((GeneralPath)shape).curveTo(26.22786, 37.00087, 30.143686, 37.947327, 34.5, 37.050358);
((GeneralPath)shape).curveTo(38.365376, 36.25447, 41.13241, 34.287144, 41.40625, 32.425358);
((GeneralPath)shape).lineTo(41.625, 7.795152);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(89, 102, 22, 255);
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.625, 7.795152);
((GeneralPath)shape).curveTo(41.625, 7.795152, 18.5625, 10.629798, 18.5625, 10.629798);
((GeneralPath)shape).lineTo(18.5625, 32.41105);
((GeneralPath)shape).curveTo(16.916546, 31.853397, 14.630715, 31.707619, 12.125, 32.22355);
((GeneralPath)shape).curveTo(7.7686863, 33.120518, 4.64714, 35.523033, 5.125, 37.5673);
((GeneralPath)shape).curveTo(5.60286, 39.61156, 9.518685, 40.558018, 13.875, 39.66105);
((GeneralPath)shape).curveTo(17.99164, 38.813427, 21.559122, 36.623245, 21.477633, 34.66105);
((GeneralPath)shape).lineTo(21.633883, 15.629798);
((GeneralPath)shape).curveTo(21.633883, 15.629798, 38.56434, 12.734492, 38.56434, 12.734492);
((GeneralPath)shape).lineTo(38.56434, 30.019106);
((GeneralPath)shape).curveTo(28.31434, 28.519106, 25.272139, 32.912342, 25.75, 34.956608);
((GeneralPath)shape).curveTo(26.22786, 37.00087, 30.143686, 37.947327, 34.5, 37.050358);
((GeneralPath)shape).curveTo(38.365376, 36.25447, 41.13241, 34.287144, 41.40625, 32.425358);
((GeneralPath)shape).lineTo(41.625, 7.795152);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 0.5117647f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.729034, 8.895638);
((GeneralPath)shape).curveTo(40.729034, 8.895638, 19.547268, 11.730284, 19.547268, 11.730284);
((GeneralPath)shape).lineTo(19.547268, 33.568623);
((GeneralPath)shape).curveTo(11.982012, 31.663311, 5.814163, 35.40303, 6.2685943, 37.347065);
((GeneralPath)shape).curveTo(6.973026, 40.6661, 20.646969, 38.4493, 20.569473, 34.208305);
((GeneralPath)shape).lineTo(20.718063, 14.735139);
((GeneralPath)shape).curveTo(20.718063, 14.735139, 39.568436, 11.842807, 39.568436, 11.842807);
((GeneralPath)shape).lineTo(39.568436, 31.279972);
((GeneralPath)shape).curveTo(32.00215, 29.353327, 26.302938, 32.656357, 26.757372, 34.60039);
((GeneralPath)shape).curveTo(27.336802, 37.79443, 39.135597, 36.713757, 40.52101, 31.943247);
((GeneralPath)shape).lineTo(40.729034, 8.895638);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.5117647f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(0.7345160245895386f, -0.11164499819278717f, 0.11164499819278717f, 0.7345160245895386f, 3.9033620357513428f, 12.225509643554688f));
// _0_0_3
paint = new RadialGradientPaint(new Point2D.Double(4.392033576965332, 32.30785369873047), 6.375f, new Point2D.Double(4.392033576965332, 32.30785369873047), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, -2.8433208590877254E-17f, 5.340759867349159E-18f, 0.5098040103912354f, 5.770894232554264E-16f, 16.05392074584961f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.25, 32.75);
((GeneralPath)shape).curveTo(12.25, 34.544926, 9.395815, 36.0, 5.875, 36.0);
((GeneralPath)shape).curveTo(2.3541846, 36.0, -0.5, 34.544926, -0.5, 32.75);
((GeneralPath)shape).curveTo(-0.5, 30.955074, 2.3541846, 29.5, 5.875, 29.5);
((GeneralPath)shape).curveTo(9.395815, 29.5, 12.25, 30.955074, 12.25, 32.75);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 0.5117647f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(0.7345160245895386f, -0.11164499819278717f, 0.11164499819278717f, 0.7345160245895386f, 23.74587059020996f, 9.390864372253418f));
// _0_0_4
paint = new RadialGradientPaint(new Point2D.Double(4.392033576965332, 32.30785369873047), 6.375f, new Point2D.Double(4.392033576965332, 32.30785369873047), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, -1.0832540249801717E-16f, 1.4543719486117622E-17f, 0.5098040103912354f, 1.1852029740391703E-14f, 16.05392074584961f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(12.25, 32.75);
((GeneralPath)shape).curveTo(12.25, 34.544926, 9.395815, 36.0, 5.875, 36.0);
((GeneralPath)shape).curveTo(2.3541846, 36.0, -0.5, 34.544926, -0.5, 32.75);
((GeneralPath)shape).curveTo(-0.5, 30.955074, 2.3541846, 29.5, 5.875, 29.5);
((GeneralPath)shape).curveTo(9.395815, 29.5, 12.25, 30.955074, 12.25, 32.75);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 5;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 8;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 38;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 39;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public AudioXGenericSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

