package org.freedesktop.tango.mimetypes;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class VideoXGenericSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.7032967f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 1.2374370098114014f, 0.7625629901885986f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(23.157747268676758, 26.963573455810547), 21.566757f, new Point2D.Double(23.157747268676758, 26.963573455810547), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.6639339923858643f, 0.0f, 9.061528205871582f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.724503, 26.963573);
((GeneralPath)shape).curveTo(44.726795, 32.080242, 40.616695, 36.80889, 33.942978, 39.367664);
((GeneralPath)shape).curveTo(27.269257, 41.926437, 19.046236, 41.926437, 12.372517, 39.367664);
((GeneralPath)shape).curveTo(5.698797, 36.80889, 1.5886983, 32.080242, 1.5909901, 26.963573);
((GeneralPath)shape).curveTo(1.5886983, 21.846905, 5.698797, 17.118256, 12.372517, 14.559483);
((GeneralPath)shape).curveTo(19.046236, 12.000709, 27.269257, 12.000709, 33.942978, 14.559483);
((GeneralPath)shape).curveTo(40.616695, 17.118256, 44.726795, 21.846905, 44.724503, 26.963573);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.2542370557785034f, 0.0f, 0.0f, 1.5419260263442993f, -9.796609878540039f, -6.2795281410217285f));
// _0_0_1
paint = new Color(161, 163, 159, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.5, 21.0);
((GeneralPath)shape).curveTo(40.5, 25.556349, 33.8962, 29.25, 25.75, 29.25);
((GeneralPath)shape).curveTo(17.6038, 29.25, 11.0, 25.556349, 11.0, 21.0);
((GeneralPath)shape).curveTo(11.0, 16.443651, 17.6038, 12.75, 25.75, 12.75);
((GeneralPath)shape).curveTo(33.8962, 12.75, 40.5, 16.443651, 40.5, 21.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(109, 111, 106, 255);
stroke = new BasicStroke(0.7190817f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.5, 21.0);
((GeneralPath)shape).curveTo(40.5, 25.556349, 33.8962, 29.25, 25.75, 29.25);
((GeneralPath)shape).curveTo(17.6038, 29.25, 11.0, 25.556349, 11.0, 21.0);
((GeneralPath)shape).curveTo(11.0, 16.443651, 17.6038, 12.75, 25.75, 12.75);
((GeneralPath)shape).curveTo(33.8962, 12.75, 40.5, 16.443651, 40.5, 21.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(0.764011025428772f, 0.0f, 0.0f, 1.0018140077590942f, 2.3104751110076904f, 2.5430829524993896f));
// _0_0_2
paint = new Color(85, 87, 83, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.5, 21.0);
((GeneralPath)shape).curveTo(40.5, 25.556349, 33.8962, 29.25, 25.75, 29.25);
((GeneralPath)shape).curveTo(17.6038, 29.25, 11.0, 25.556349, 11.0, 21.0);
((GeneralPath)shape).curveTo(11.0, 16.443651, 17.6038, 12.75, 25.75, 12.75);
((GeneralPath)shape).curveTo(33.8962, 12.75, 40.5, 16.443651, 40.5, 21.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new RadialGradientPaint(new Point2D.Double(20.655508041381836, 24.73512077331543), 14.1515f, new Point2D.Double(20.655508041381836, 24.73512077331543), new float[] {0.0f,1.0f}, new Color[] {new Color(118, 118, 118, 255),new Color(72, 72, 72, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 1.9716780185699463f, 9.220141410827637f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.025803, 41.226234);
((GeneralPath)shape).curveTo(46.025803, 41.226234, 37.70191, 37.489227, 32.369804, 37.959515);
((GeneralPath)shape).curveTo(26.686792, 38.460754, 17.193027, 38.79695, 13.471708, 32.920174);
((GeneralPath)shape).curveTo(29.269806, 37.684643, 36.558697, 29.774427, 47.251087, 34.22969);
((GeneralPath)shape).curveTo(47.251087, 34.22969, 46.025803, 41.226234, 46.025803, 41.226234);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(59, 61, 57, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.025803, 41.226234);
((GeneralPath)shape).curveTo(46.025803, 41.226234, 37.70191, 37.489227, 32.369804, 37.959515);
((GeneralPath)shape).curveTo(26.686792, 38.460754, 17.193027, 38.79695, 13.471708, 32.920174);
((GeneralPath)shape).curveTo(29.269806, 37.684643, 36.558697, 29.774427, 47.251087, 34.22969);
((GeneralPath)shape).curveTo(47.251087, 34.22969, 46.025803, 41.226234, 46.025803, 41.226234);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(0.7609689831733704f, 0.0f, 0.0f, 0.9866629838943481f, 2.90504789352417f, 0.5842670202255249f));
// _0_0_4
paint = new LinearGradientPaint(new Point2D.Double(23.816253662109375, 12.75), new Point2D.Double(29.04941177368164, 25.772396087646484), new float[] {0.0f,1.0f}, new Color[] {new Color(136, 138, 133, 255),new Color(184, 185, 182, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.5, 21.0);
((GeneralPath)shape).curveTo(40.5, 25.556349, 33.8962, 29.25, 25.75, 29.25);
((GeneralPath)shape).curveTo(17.6038, 29.25, 11.0, 25.556349, 11.0, 21.0);
((GeneralPath)shape).curveTo(11.0, 16.443651, 17.6038, 12.75, 25.75, 12.75);
((GeneralPath)shape).curveTo(33.8962, 12.75, 40.5, 16.443651, 40.5, 21.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(117, 121, 114, 255);
stroke = new BasicStroke(1.2340884f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.5, 21.0);
((GeneralPath)shape).curveTo(40.5, 25.556349, 33.8962, 29.25, 25.75, 29.25);
((GeneralPath)shape).curveTo(17.6038, 29.25, 11.0, 25.556349, 11.0, 21.0);
((GeneralPath)shape).curveTo(11.0, 16.443651, 17.6038, 12.75, 25.75, 12.75);
((GeneralPath)shape).curveTo(33.8962, 12.75, 40.5, 16.443651, 40.5, 21.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(211, 215, 207, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.09375, 7.71875);
((GeneralPath)shape).curveTo(11.536229, 8.244424, 4.0, 14.13337, 4.0, 21.25);
((GeneralPath)shape).curveTo(4.0, 28.711046, 12.288003, 34.78125, 22.5, 34.78125);
((GeneralPath)shape).curveTo(32.711998, 34.78125, 41.0, 28.711044, 41.0, 21.25);
((GeneralPath)shape).curveTo(41.0, 13.788954, 32.711998, 7.71875, 22.5, 7.71875);
((GeneralPath)shape).curveTo(22.46011, 7.71875, 22.414831, 7.7185655, 22.375, 7.71875);
((GeneralPath)shape).curveTo(22.136944, 7.719853, 21.892094, 7.711109, 21.65625, 7.71875);
((GeneralPath)shape).curveTo(21.541092, 7.722481, 21.4271, 7.713478, 21.3125, 7.71875);
((GeneralPath)shape).curveTo(21.236996, 7.7222238, 21.169006, 7.714611, 21.09375, 7.71875);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(19.71875, 9.90625);
((GeneralPath)shape).curveTo(19.782003, 9.901143, 19.84234, 9.90972, 19.90625, 9.90625);
((GeneralPath)shape).curveTo(20.040354, 9.898969, 20.175795, 9.90625, 20.3125, 9.90625);
((GeneralPath)shape).curveTo(23.228891, 9.90625, 25.59375, 11.608453, 25.59375, 13.6875);
((GeneralPath)shape).curveTo(25.59375, 15.766547, 23.228891, 17.4375, 20.3125, 17.4375);
((GeneralPath)shape).curveTo(17.396109, 17.4375, 15.03125, 15.766547, 15.03125, 13.6875);
((GeneralPath)shape).curveTo(15.03125, 11.752352, 17.083204, 10.119037, 19.71875, 9.90625);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(31.21875, 14.5);
((GeneralPath)shape).curveTo(31.285397, 14.494037, 31.338936, 14.504252, 31.40625, 14.5);
((GeneralPath)shape).curveTo(31.523003, 14.492625, 31.631386, 14.502149, 31.75, 14.5);
((GeneralPath)shape).curveTo(31.798199, 14.499127, 31.82651, 14.5, 31.875, 14.5);
((GeneralPath)shape).curveTo(34.978455, 14.5, 37.5, 16.314203, 37.5, 18.53125);
((GeneralPath)shape).curveTo(37.5, 20.748297, 34.978455, 22.53125, 31.875, 22.53125);
((GeneralPath)shape).curveTo(28.771545, 22.531252, 26.25, 20.748297, 26.25, 18.53125);
((GeneralPath)shape).curveTo(26.249998, 16.483248, 28.441784, 14.748443, 31.21875, 14.5);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(12.0, 17.65625);
((GeneralPath)shape).curveTo(12.217826, 17.638428, 12.463035, 17.65625, 12.6875, 17.65625);
((GeneralPath)shape).curveTo(15.879889, 17.65625, 18.46875, 19.498598, 18.46875, 21.78125);
((GeneralPath)shape).curveTo(18.46875, 24.063902, 15.879889, 25.90625, 12.6875, 25.90625);
((GeneralPath)shape).curveTo(9.495111, 25.90625, 6.90625, 24.063902, 6.90625, 21.78125);
((GeneralPath)shape).curveTo(6.90625, 19.659098, 9.119854, 17.891914, 12.0, 17.65625);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(23.53125, 22.78125);
((GeneralPath)shape).curveTo(23.555225, 22.778463, 23.56969, 22.78384, 23.59375, 22.78125);
((GeneralPath)shape).curveTo(23.596498, 22.781134, 23.622454, 22.781218, 23.625, 22.78125);
((GeneralPath)shape).curveTo(23.627554, 22.781296, 23.653494, 22.78135, 23.65625, 22.78125);
((GeneralPath)shape).curveTo(23.662493, 22.781357, 23.684305, 22.781364, 23.6875, 22.78125);
((GeneralPath)shape).curveTo(23.713654, 22.78143, 23.75501, 22.780867, 23.78125, 22.78125);
((GeneralPath)shape).curveTo(23.78446, 22.781174, 23.806269, 22.781166, 23.8125, 22.78125);
((GeneralPath)shape).curveTo(24.053476, 22.761473, 24.28293, 22.78125, 24.53125, 22.78125);
((GeneralPath)shape).curveTo(28.062916, 22.78125, 30.9375, 24.81081, 30.9375, 27.34375);
((GeneralPath)shape).curveTo(30.9375, 29.87669, 28.062916, 31.9375, 24.53125, 31.9375);
((GeneralPath)shape).curveTo(20.999584, 31.9375, 18.125, 29.87669, 18.125, 27.34375);
((GeneralPath)shape).curveTo(18.125, 25.06178, 20.486444, 23.135038, 23.53125, 22.78125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(136, 138, 133, 255);
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.09375, 7.71875);
((GeneralPath)shape).curveTo(11.536229, 8.244424, 4.0, 14.13337, 4.0, 21.25);
((GeneralPath)shape).curveTo(4.0, 28.711046, 12.288003, 34.78125, 22.5, 34.78125);
((GeneralPath)shape).curveTo(32.711998, 34.78125, 41.0, 28.711044, 41.0, 21.25);
((GeneralPath)shape).curveTo(41.0, 13.788954, 32.711998, 7.71875, 22.5, 7.71875);
((GeneralPath)shape).curveTo(22.46011, 7.71875, 22.414831, 7.7185655, 22.375, 7.71875);
((GeneralPath)shape).curveTo(22.136944, 7.719853, 21.892094, 7.711109, 21.65625, 7.71875);
((GeneralPath)shape).curveTo(21.541092, 7.722481, 21.4271, 7.713478, 21.3125, 7.71875);
((GeneralPath)shape).curveTo(21.236996, 7.7222238, 21.169006, 7.714611, 21.09375, 7.71875);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(19.71875, 9.90625);
((GeneralPath)shape).curveTo(19.782003, 9.901143, 19.84234, 9.90972, 19.90625, 9.90625);
((GeneralPath)shape).curveTo(20.040354, 9.898969, 20.175795, 9.90625, 20.3125, 9.90625);
((GeneralPath)shape).curveTo(23.228891, 9.90625, 25.59375, 11.608453, 25.59375, 13.6875);
((GeneralPath)shape).curveTo(25.59375, 15.766547, 23.228891, 17.4375, 20.3125, 17.4375);
((GeneralPath)shape).curveTo(17.396109, 17.4375, 15.03125, 15.766547, 15.03125, 13.6875);
((GeneralPath)shape).curveTo(15.03125, 11.752352, 17.083204, 10.119037, 19.71875, 9.90625);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(31.21875, 14.5);
((GeneralPath)shape).curveTo(31.285397, 14.494037, 31.338936, 14.504252, 31.40625, 14.5);
((GeneralPath)shape).curveTo(31.523003, 14.492625, 31.631386, 14.502149, 31.75, 14.5);
((GeneralPath)shape).curveTo(31.798199, 14.499127, 31.82651, 14.5, 31.875, 14.5);
((GeneralPath)shape).curveTo(34.978455, 14.5, 37.5, 16.314203, 37.5, 18.53125);
((GeneralPath)shape).curveTo(37.5, 20.748297, 34.978455, 22.53125, 31.875, 22.53125);
((GeneralPath)shape).curveTo(28.771545, 22.531252, 26.25, 20.748297, 26.25, 18.53125);
((GeneralPath)shape).curveTo(26.249998, 16.483248, 28.441784, 14.748443, 31.21875, 14.5);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(12.0, 17.65625);
((GeneralPath)shape).curveTo(12.217826, 17.638428, 12.463035, 17.65625, 12.6875, 17.65625);
((GeneralPath)shape).curveTo(15.879889, 17.65625, 18.46875, 19.498598, 18.46875, 21.78125);
((GeneralPath)shape).curveTo(18.46875, 24.063902, 15.879889, 25.90625, 12.6875, 25.90625);
((GeneralPath)shape).curveTo(9.495111, 25.90625, 6.90625, 24.063902, 6.90625, 21.78125);
((GeneralPath)shape).curveTo(6.90625, 19.659098, 9.119854, 17.891914, 12.0, 17.65625);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(23.53125, 22.78125);
((GeneralPath)shape).curveTo(23.555225, 22.778463, 23.56969, 22.78384, 23.59375, 22.78125);
((GeneralPath)shape).curveTo(23.596498, 22.781134, 23.622454, 22.781218, 23.625, 22.78125);
((GeneralPath)shape).curveTo(23.627554, 22.781296, 23.653494, 22.78135, 23.65625, 22.78125);
((GeneralPath)shape).curveTo(23.662493, 22.781357, 23.684305, 22.781364, 23.6875, 22.78125);
((GeneralPath)shape).curveTo(23.713654, 22.78143, 23.75501, 22.780867, 23.78125, 22.78125);
((GeneralPath)shape).curveTo(23.78446, 22.781174, 23.806269, 22.781166, 23.8125, 22.78125);
((GeneralPath)shape).curveTo(24.053476, 22.761473, 24.28293, 22.78125, 24.53125, 22.78125);
((GeneralPath)shape).curveTo(28.062916, 22.78125, 30.9375, 24.81081, 30.9375, 27.34375);
((GeneralPath)shape).curveTo(30.9375, 29.87669, 28.062916, 31.9375, 24.53125, 31.9375);
((GeneralPath)shape).curveTo(20.999584, 31.9375, 18.125, 29.87669, 18.125, 27.34375);
((GeneralPath)shape).curveTo(18.125, 25.06178, 20.486444, 23.135038, 23.53125, 22.78125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(0.9505329728126526f, 0.0f, 0.0f, 0.9375f, 1.4509949684143066f, 3.3206210136413574f));
// _0_0_6
paint = new LinearGradientPaint(new Point2D.Double(21.03166961669922, 31.86785888671875), new Point2D.Double(21.107563018798828, -4.598634243011475), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.0593288f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.65864, 19.008621);
((GeneralPath)shape).curveTo(40.65864, 26.428583, 32.387924, 32.44365, 22.185474, 32.44365);
((GeneralPath)shape).curveTo(11.983027, 32.44365, 3.712309, 26.428583, 3.712309, 19.008621);
((GeneralPath)shape).curveTo(3.712309, 11.588659, 11.983027, 5.5735917, 22.185474, 5.5735917);
((GeneralPath)shape).curveTo(32.387924, 5.5735917, 40.65864, 11.588659, 40.65864, 19.008621);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new LinearGradientPaint(new Point2D.Double(46.544639587402344, 35.245059967041016), new Point2D.Double(40.820396423339844, 34.14020538330078), new float[] {0.0f,1.0f}, new Color[] {new Color(136, 138, 133, 255),new Color(136, 138, 133, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.8848779797554016f, 0.0f, 0.0f, 0.8848779797554016f, 5.318112850189209f, 5.943159103393555f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.875, 34.493904);
((GeneralPath)shape).lineTo(45.793438, 40.543896);
((GeneralPath)shape).curveTo(43.18442, 39.66846, 41.61139, 38.97574, 38.72227, 38.287037);
((GeneralPath)shape).lineTo(39.0541, 33.37439);
((GeneralPath)shape).curveTo(40.952633, 33.173084, 43.91738, 33.516125, 46.875, 34.493904);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 0.7032967f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new LinearGradientPaint(new Point2D.Double(43.6875, 32.1330451965332), new Point2D.Double(26.625, 32.1330451965332), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 2.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.875, 34.3125);
((GeneralPath)shape).lineTo(46.6875, 35.1875);
((GeneralPath)shape).curveTo(38.5826, 32.158615, 31.121435, 34.96078, 23.3125, 35.1875);
((GeneralPath)shape).curveTo(33.923553, 34.30492, 37.402744, 31.471844, 46.875, 34.3125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 3;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 8;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 45;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 36;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public VideoXGenericSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

