package org.freedesktop.tango.mimetypes;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class XOfficePresentationSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.482037, 37.621563);
((GeneralPath)shape).lineTo(24.499994, 37.621563);
((GeneralPath)shape).lineTo(24.499994, 6.0);
((GeneralPath)shape).lineTo(26.482037, 6.0);
((GeneralPath)shape).lineTo(26.482037, 37.620113);
((GeneralPath)shape).lineTo(26.482037, 37.621563);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(85, 87, 83, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.482037, 37.621563);
((GeneralPath)shape).lineTo(24.499994, 37.621563);
((GeneralPath)shape).lineTo(24.499994, 6.0);
((GeneralPath)shape).lineTo(26.482037, 6.0);
((GeneralPath)shape).lineTo(26.482037, 37.620113);
((GeneralPath)shape).lineTo(26.482037, 37.621563);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.0, 37.621563);
((GeneralPath)shape).lineTo(24.982042, 37.621563);
((GeneralPath)shape).lineTo(24.982042, 6.0);
((GeneralPath)shape).lineTo(26.0, 6.0);
((GeneralPath)shape).lineTo(26.0, 37.620113);
((GeneralPath)shape).lineTo(26.0, 37.621563);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(27.29490089416504, 25.472700119018555), new Point2D.Double(20.94529914855957, 11.003899574279785), new float[] {0.0f,1.0f}, new Color[] {new Color(245, 245, 245, 255),new Color(225, 225, 225, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.868867039680481f, 0.0f, 0.0f, 1.5088000297546387f, -20.39097023010254f, -10.016519546508789f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.499996, 32.49998);
((GeneralPath)shape).lineTo(7.5, 32.49998);
((GeneralPath)shape).lineTo(7.5, 5.4999943);
((GeneralPath)shape).lineTo(43.499996, 5.4999943);
((GeneralPath)shape).lineTo(43.499996, 32.49998);
((GeneralPath)shape).lineTo(43.499996, 32.49998);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(136, 138, 133, 255);
stroke = new BasicStroke(1.0f,0,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.499996, 32.49998);
((GeneralPath)shape).lineTo(7.5, 32.49998);
((GeneralPath)shape).lineTo(7.5, 5.4999943);
((GeneralPath)shape).lineTo(43.499996, 5.4999943);
((GeneralPath)shape).lineTo(43.499996, 32.49998);
((GeneralPath)shape).lineTo(43.499996, 32.49998);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.3901099f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.7492539882659912f, 0.0f, 0.0f, 1.4525480270385742f, -20.383010864257812f, -20.437490463256836f));
// _0_0_3
paint = new RadialGradientPaint(new Point2D.Double(26.16295051574707, 44.022525787353516), 12.197592f, new Point2D.Double(26.16295051574707, 44.022525787353516), new float[] {0.0f,1.0f}, new Color[] {new Color(91, 91, 91, 255),new Color(91, 91, 91, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.18115900456905365f, -2.87140103361061E-15f, 36.047428131103516f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.360542, 44.022526);
((GeneralPath)shape).curveTo(38.360542, 45.242912, 32.899494, 46.232235, 26.16295, 46.232235);
((GeneralPath)shape).curveTo(19.426407, 46.232235, 13.965359, 45.242912, 13.965359, 44.022526);
((GeneralPath)shape).curveTo(13.965359, 42.80214, 19.426407, 41.812817, 26.16295, 41.812817);
((GeneralPath)shape).curveTo(32.899494, 41.812817, 38.360542, 42.80214, 38.360542, 44.022526);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.5390160083770752f, 0.0f, 0.0f, 1.5390160083770752f, -12.898619651794434f, -11.057310104370117f));
// _0_0_4
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4_0
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.492, 35.959);
((GeneralPath)shape).lineTo(25.217, 31.321);
((GeneralPath)shape).lineTo(25.151306, 31.665949);
((GeneralPath)shape).lineTo(30.016, 35.955);
((GeneralPath)shape).lineTo(31.492, 35.959);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(85, 87, 83, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.492, 35.959);
((GeneralPath)shape).lineTo(25.217, 31.321);
((GeneralPath)shape).lineTo(25.151306, 31.665949);
((GeneralPath)shape).lineTo(30.016, 35.955);
((GeneralPath)shape).lineTo(31.492, 35.959);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4_1
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(18.408, 35.959);
((GeneralPath)shape).lineTo(24.683, 31.321);
((GeneralPath)shape).lineTo(24.63283, 31.72338);
((GeneralPath)shape).lineTo(19.883, 35.955);
((GeneralPath)shape).lineTo(18.408, 35.959);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(85, 87, 83, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(18.408, 35.959);
((GeneralPath)shape).lineTo(24.683, 31.321);
((GeneralPath)shape).lineTo(24.63283, 31.72338);
((GeneralPath)shape).lineTo(19.883, 35.955);
((GeneralPath)shape).lineTo(18.408, 35.959);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4_1);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new LinearGradientPaint(new Point2D.Double(23.37957191467285, 28.36916732788086), new Point2D.Double(24.245180130004883, 6.000002384185791), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(42.48351, 31.500002);
((GeneralPath)shape).lineTo(8.5, 31.500002);
((GeneralPath)shape).lineTo(8.5, 6.5000024);
((GeneralPath)shape).lineTo(42.48351, 6.5000024);
((GeneralPath)shape).lineTo(42.48351, 31.500002);
((GeneralPath)shape).lineTo(42.48351, 31.500002);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 0.15999995f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(0, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(37.64607, 5.8376813);
((GeneralPath)shape).lineTo(8.0, 5.8376813);
((GeneralPath)shape).lineTo(8.0, 8.0);
((GeneralPath)shape).curveTo(9.671372, 5.651461, 37.64607, 5.8376813, 37.64607, 5.8376813);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(31.0, 9.0, 9.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new LinearGradientPaint(new Point2D.Double(24.919374465942383, 6.1478681564331055), new Point2D.Double(24.919374465942383, 7.460026264190674), new float[] {0.0f,1.0f}, new Color[] {new Color(240, 240, 240, 255),new Color(104, 104, 104, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.905258059501648f, 0.0f, 0.0f, 2.5217769145965576f, -22.820650100708008f, -13.246040344238281f));
shape = new RoundRectangle2D.Double(5.1403117179870605, 1.5, 40.77909851074219, 4.0, 3.8829519748687744, 3.8829522132873535);
g.setPaint(paint);
g.fill(shape);
paint = new Color(85, 87, 83, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new RoundRectangle2D.Double(5.1403117179870605, 1.5, 40.77909851074219, 4.0, 3.8829519748687744, 3.8829522132873535);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(31.0, 11.0, 9.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(31.0, 13.0, 9.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(31.0, 15.0, 9.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_12
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(31.0, 17.0, 6.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_13
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(11.0, 22.0, 23.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_13);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_14 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_14
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(11.0, 24.0, 23.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_14);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_15 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_15
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(11.0, 26.0, 23.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_15);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_16 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_16
paint = new Color(0, 0, 0, 58);
shape = new Rectangle2D.Double(11.0, 28.0, 16.0, 1.0);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_16);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_17 = g.getTransform();
g.transform(new AffineTransform(0.5121380090713501f, 0.0f, 0.0f, 0.5121380090713501f, 2.9974780082702637f, -5.7788519859313965f));
// _0_0_17
paint = new RadialGradientPaint(new Point2D.Double(28.283662796020508, 47.4006233215332), 13.804391f, new Point2D.Double(28.283662796020508, 47.4006233215332), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.1642260551452637f, 0.0f, 0.0f, 0.8589400053024292f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(48.999996, 40.714287);
((GeneralPath)shape).curveTo(49.001976, 44.95141, 45.93921, 48.867294, 40.96588, 50.98628);
((GeneralPath)shape).curveTo(35.99255, 53.10526, 29.864586, 53.10526, 24.891256, 50.98628);
((GeneralPath)shape).curveTo(19.917927, 48.867294, 16.855164, 44.95141, 16.857141, 40.714287);
((GeneralPath)shape).curveTo(16.855164, 36.477165, 19.917927, 32.56128, 24.891256, 30.442297);
((GeneralPath)shape).curveTo(29.864586, 28.323315, 35.99255, 28.323315, 40.96588, 30.442297);
((GeneralPath)shape).curveTo(45.93921, 32.56128, 49.001976, 36.477165, 48.999996, 40.714287);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_17);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18 = g.getTransform();
g.transform(new AffineTransform(0.5873680114746094f, 0.0f, 0.0f, 0.5873680114746094f, 30.845970153808594f, -1.301179051399231f));
// _0_0_18
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_0
paint = new Color(103, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-27.528542, 18.092794);
((GeneralPath)shape).curveTo(-30.097576, 19.791124, -31.511475, 22.097834, -31.511475, 24.590696);
((GeneralPath)shape).lineTo(-31.511475, 26.659988);
((GeneralPath)shape).curveTo(-31.511475, 29.150827, -30.097576, 31.458212, -27.528542, 33.15654);
((GeneralPath)shape).curveTo(-25.102053, 34.760445, -21.895416, 35.64401, -18.49936, 35.64401);
((GeneralPath)shape).curveTo(-15.104587, 35.64401, -11.89795, 34.760445, -9.470178, 33.15654);
((GeneralPath)shape).curveTo(-6.9024277, 31.458212, -5.488528, 29.151503, -5.488528, 26.659988);
((GeneralPath)shape).lineTo(-5.488528, 24.590696);
((GeneralPath)shape).curveTo(-5.488528, 22.097834, -6.9030695, 19.79045, -9.470178, 18.092794);
((GeneralPath)shape).curveTo(-11.897308, 16.490238, -15.103945, 15.606001, -18.49936, 15.606001);
((GeneralPath)shape).curveTo(-21.895416, 15.606001, -25.102053, 16.490238, -27.528542, 18.092794);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_1
paint = new Color(164, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-7.024426, 24.453547);
((GeneralPath)shape).curveTo(-8.40301, 21.067003, -13.077484, 18.573465, -18.636768, 18.573465);
((GeneralPath)shape).curveTo(-24.196053, 18.573465, -28.870525, 21.067003, -30.249111, 24.453547);
((GeneralPath)shape).lineTo(-30.663906, 24.453547);
((GeneralPath)shape).lineTo(-30.663906, 26.523514);
((GeneralPath)shape).curveTo(-30.663906, 30.913677, -25.27863, 34.472214, -18.636768, 34.472214);
((GeneralPath)shape).curveTo(-11.994265, 34.472214, -6.610273, 30.913677, -6.610273, 26.523514);
((GeneralPath)shape).lineTo(-6.610273, 24.453547);
((GeneralPath)shape).lineTo(-7.024426, 24.453547);
((GeneralPath)shape).lineTo(-7.024426, 24.453547);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_2
paint = new LinearGradientPaint(new Point2D.Double(-22.97640609741211, 18.51604652404785), new Point2D.Double(-14.360273361206055, 33.01604461669922), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 113, 113, 255),new Color(204, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-6.610273, 24.453547);
((GeneralPath)shape).curveTo(-6.610273, 28.844385, -11.994265, 32.40292, -18.636768, 32.40292);
((GeneralPath)shape).curveTo(-25.279272, 32.40292, -30.663906, 28.844385, -30.663906, 24.453547);
((GeneralPath)shape).curveTo(-30.663906, 20.062708, -25.27863, 16.504173, -18.636768, 16.504173);
((GeneralPath)shape).curveTo(-11.994265, 16.504173, -6.610273, 20.062708, -6.610273, 24.453547);
((GeneralPath)shape).lineTo(-6.610273, 24.453547);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_3
paint = new Color(32, 74, 135, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-6.610273, 26.833097);
((GeneralPath)shape).lineTo(-6.6256833, 24.666681);
((GeneralPath)shape).curveTo(-7.9297843, 29.16746, -10.862246, 31.074203, -14.549173, 32.00768);
((GeneralPath)shape).lineTo(-14.549173, 34.0021);
((GeneralPath)shape).curveTo(-10.558534, 32.99848, -6.9871845, 30.713358, -6.610273, 26.833097);
((GeneralPath)shape).lineTo(-6.610273, 26.833097);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_4
paint = new LinearGradientPaint(new Point2D.Double(-16.38741111755371, 24.45354652404785), new Point2D.Double(-9.735273361206055, 28.195539474487305), new float[] {0.0f,1.0f}, new Color[] {new Color(91, 140, 203, 255),new Color(52, 101, 164, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-6.610273, 24.453547);
((GeneralPath)shape).curveTo(-6.885733, 29.533026, -13.16802, 31.849176, -14.571646, 31.937532);
((GeneralPath)shape).lineTo(-18.637411, 24.453547);
((GeneralPath)shape).lineTo(-6.610915, 24.453547);
((GeneralPath)shape).lineTo(-6.610273, 24.453547);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_5
paint = new Color(78, 154, 6, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-21.154434, 34.2982);
((GeneralPath)shape).lineTo(-21.154434, 32.228905);
((GeneralPath)shape).curveTo(-18.891039, 32.52365, -16.814493, 32.57559, -14.571646, 32.0151);
((GeneralPath)shape).lineTo(-14.549173, 34.002777);
((GeneralPath)shape).curveTo(-16.428593, 34.619247, -19.36876, 34.64825, -21.154434, 34.298874);
((GeneralPath)shape).lineTo(-21.154434, 34.2982);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_18_6
paint = new LinearGradientPaint(new Point2D.Double(-17.863040924072266, 30.8275089263916), new Point2D.Double(-20.821645736694336, 25.0150089263916), new float[] {0.0f,1.0f}, new Color[] {new Color(115, 210, 22, 255),new Color(213, 247, 179, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-18.637411, 24.454222);
((GeneralPath)shape).lineTo(-14.571646, 31.937532);
((GeneralPath)shape).curveTo(-17.06106, 32.88652, -21.154434, 32.228905, -21.154434, 32.228905);
((GeneralPath)shape).lineTo(-18.637411, 24.454222);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18_6);
g.setComposite(AlphaComposite.getInstance(3, 0.31111115f * origAlpha));
AffineTransform defaultTransform__0_0_18_7 = g.getTransform();
g.transform(new AffineTransform(0.9469820261001587f, 0.0f, 0.0f, 0.8897010087966919f, -0.9874609708786011f, 2.688544988632202f));
// _0_0_18_7
paint = new LinearGradientPaint(new Point2D.Double(-20.75, 29.0), new Point2D.Double(-19.5, 18.75), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.8547988f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-6.875, 24.375);
((GeneralPath)shape).curveTo(-6.875, 28.655207, -12.135654, 32.125, -18.625, 32.125);
((GeneralPath)shape).curveTo(-25.114346, 32.125, -30.375, 28.655207, -30.375, 24.375);
((GeneralPath)shape).curveTo(-30.375, 20.094793, -25.114346, 16.625, -18.625, 16.625);
((GeneralPath)shape).curveTo(-12.135654, 16.625, -6.875, 20.094793, -6.875, 24.375);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_18_7);
g.setTransform(defaultTransform__0_0_18);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_19 = g.getTransform();
g.transform(new AffineTransform(1.5390160083770752f, 0.0f, 0.0f, 1.5390160083770752f, -12.898619651794434f, -11.057310104370117f));
// _0_0_19
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_19_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_19_0
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(30.015, 35.956);
((GeneralPath)shape).lineTo(31.492, 35.959);
((GeneralPath)shape).lineTo(25.217, 31.321);
((GeneralPath)shape).lineTo(24.778, 31.307);
((GeneralPath)shape).lineTo(30.016, 35.955);
((GeneralPath)shape).lineTo(30.015, 35.956);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_19_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_19_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_19_1
paint = new Color(164, 164, 164, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(19.884, 35.956);
((GeneralPath)shape).lineTo(18.408, 35.959);
((GeneralPath)shape).lineTo(24.683, 31.321);
((GeneralPath)shape).lineTo(25.121, 31.307);
((GeneralPath)shape).lineTo(19.883, 35.955);
((GeneralPath)shape).lineTo(19.884, 35.956);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_19_1);
g.setTransform(defaultTransform__0_0_19);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_20 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_20
paint = new RadialGradientPaint(new Point2D.Double(24.77440071105957, 30.991199493408203), 0.5902f, new Point2D.Double(24.77440071105957, 30.991199493408203), new float[] {0.0f,1.0f}, new Color[] {new Color(240, 240, 240, 255),new Color(132, 132, 132, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(3.5025269985198975f, 0.0f, 0.0f, 3.5025269985198975f, -61.930091857910156f, -72.87696075439453f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.83969, 36.499985);
((GeneralPath)shape).curveTo(27.83969, 37.79242, 26.79243, 38.839676, 25.499998, 38.839676);
((GeneralPath)shape).curveTo(24.207565, 38.839676, 23.160309, 37.79242, 23.160309, 36.499985);
((GeneralPath)shape).curveTo(23.160309, 35.211056, 24.207565, 34.1603, 25.499998, 34.1603);
((GeneralPath)shape).curveTo(26.79243, 34.1603, 27.83969, 35.211056, 27.83969, 36.499985);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(85, 87, 83, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(27.83969, 36.499985);
((GeneralPath)shape).curveTo(27.83969, 37.79242, 26.79243, 38.839676, 25.499998, 38.839676);
((GeneralPath)shape).curveTo(24.207565, 38.839676, 23.160309, 37.79242, 23.160309, 36.499985);
((GeneralPath)shape).curveTo(23.160309, 35.211056, 24.207565, 34.1603, 25.499998, 34.1603);
((GeneralPath)shape).curveTo(26.79243, 34.1603, 27.83969, 35.211056, 27.83969, 36.499985);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_20);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 5;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 1;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 43;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 46;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public XOfficePresentationSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

