package org.freedesktop.tango.status;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class SoftwareUpdateUrgentSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.5060241f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new Color(0, 0, 0, 255);
shape = new RoundRectangle2D.Double(2.375, 37.75, 42.75, 4.75, 5.0, 4.75);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new LinearGradientPaint(new Point2D.Double(29.455839157104492, 43.94804000854492), new Point2D.Double(28.44365119934082, 15.22182846069336), new float[] {0.0f,1.0f}, new Color[] {new Color(245, 110, 110, 255),new Color(255, 41, 41, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.5, 38.5);
((GeneralPath)shape).lineTo(6.499995, 38.5);
((GeneralPath)shape).lineTo(23.999998, 7.5000005);
((GeneralPath)shape).lineTo(41.5, 38.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(164, 0, 0, 255);
stroke = new BasicStroke(5.0000005f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.5, 38.5);
((GeneralPath)shape).lineTo(6.499995, 38.5);
((GeneralPath)shape).lineTo(23.999998, 7.5000005);
((GeneralPath)shape).lineTo(41.5, 38.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 0.59638554f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(24.0, 10.619070053100586), new Point2D.Double(26.878314971923828, 70.74407196044922), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.84375, 6.5);
((GeneralPath)shape).curveTo(23.540504, 6.548465, 23.2759, 6.732538, 23.125, 7.0);
((GeneralPath)shape).lineTo(5.625, 38.0);
((GeneralPath)shape).curveTo(5.4507627, 38.31141, 5.454178, 38.69174, 5.6339793, 38.99997);
((GeneralPath)shape).curveTo(5.813781, 39.3082, 6.143163, 39.498383, 6.5, 39.5);
((GeneralPath)shape).lineTo(41.5, 39.5);
((GeneralPath)shape).curveTo(41.85684, 39.498383, 42.18622, 39.3082, 42.36602, 38.99997);
((GeneralPath)shape).curveTo(42.545822, 38.69174, 42.549236, 38.31141, 42.375, 38.0);
((GeneralPath)shape).lineTo(24.875, 7.0);
((GeneralPath)shape).curveTo(24.668678, 6.635093, 24.258032, 6.435992, 23.84375, 6.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3_0 = g.getTransform();
g.transform(new AffineTransform(0.6519563794136047f, 0.0f, 0.0f, 0.6519563794136047f, 9.149547576904297f, 10.638023376464844f));
// _0_0_3_0
paint = new RadialGradientPaint(new Point2D.Double(17.124725341796875, 23.838573455810547), 2.0f, new Point2D.Double(17.124725341796875, 23.838573455810547), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-4.800511419489339E-7f, -15.821788787841797f, 7.340685844421387f, -5.874819066775672E-7f, -150.99147033691406f, 303.00628662109375f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(25.721008, 31.294601);
((GeneralPath)shape).curveTo(25.721613, 32.36866, 25.148956, 33.36139, 24.218895, 33.898594);
((GeneralPath)shape).curveTo(23.288834, 34.4358, 22.142776, 34.4358, 21.212715, 33.898594);
((GeneralPath)shape).curveTo(20.282654, 33.36139, 19.709997, 32.36866, 19.710602, 31.294601);
((GeneralPath)shape).curveTo(19.709997, 30.220543, 20.282654, 29.227812, 21.212715, 28.690607);
((GeneralPath)shape).curveTo(22.142776, 28.153404, 23.288834, 28.153404, 24.218895, 28.690607);
((GeneralPath)shape).curveTo(25.148956, 29.227812, 25.721613, 30.220543, 25.721008, 31.294601);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3_1
paint = new RadialGradientPaint(new Point2D.Double(17.124725341796875, 23.838573455810547), 2.0f, new Point2D.Double(17.124725341796875, 23.838573455810547), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-4.800511419489339E-7f, -15.821788787841797f, 7.340685844421387f, -5.874819066775672E-7f, -150.99147033691406f, 303.00628662109375f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.0, 28.0);
((GeneralPath)shape).lineTo(25.0, 28.0);
((GeneralPath)shape).lineTo(26.0, 19.0);
((GeneralPath)shape).lineTo(22.0, 19.0);
((GeneralPath)shape).lineTo(23.0, 28.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3_1);
g.setTransform(defaultTransform__0_0_3);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 0;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 5;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 48;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 42;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public SoftwareUpdateUrgentSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

