/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.parameters;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.codeblessing.sourceamazing.api.filesystem.FileSystemAccess;
import org.codeblessing.sourceamazing.engine.parameters.ParameterSource;
import org.codeblessing.sourceamazing.engine.parameters.PropertiesToMapConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/codeblessing/sourceamazing/engine/parameters/DefaultPropertyFileParameterSource;", "Lorg/codeblessing/sourceamazing/engine/parameters/ParameterSource;", "fileSystemAccess", "Lorg/codeblessing/sourceamazing/api/filesystem/FileSystemAccess;", "(Lorg/codeblessing/sourceamazing/api/filesystem/FileSystemAccess;)V", "propertyMap", "", "", "resourceName", "getParameterMap", "getPropertiesFromFile", "Ljava/util/Properties;", "toString", "sourceamazing-engine"})
public final class DefaultPropertyFileParameterSource
implements ParameterSource {
    @NotNull
    private final FileSystemAccess fileSystemAccess;
    @NotNull
    private final String resourceName;
    @NotNull
    private final Map<String, String> propertyMap;

    public DefaultPropertyFileParameterSource(@NotNull FileSystemAccess fileSystemAccess) {
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        this.fileSystemAccess = fileSystemAccess;
        this.resourceName = "/sourceamazing.properties";
        this.propertyMap = PropertiesToMapConverter.INSTANCE.convertToMap(this.getPropertiesFromFile());
    }

    @Override
    @NotNull
    public Map<String, String> getParameterMap() {
        return this.propertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties getPropertiesFromFile() {
        Properties props = new Properties();
        Closeable closeable = this.fileSystemAccess.classpathResourceAsInputStream(this.resourceName);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            props.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return props;
    }

    @NotNull
    public String toString() {
        return super.toString() + ':' + this.resourceName + '=' + this.propertyMap;
    }
}

