/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process;

import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codeblessing.sourceamazing.api.logger.LoggerFacade;
import org.codeblessing.sourceamazing.api.process.DomainUnit;
import org.codeblessing.sourceamazing.api.process.datacollection.DomainUnitDataCollectionHelper;
import org.codeblessing.sourceamazing.api.process.schema.DomainUnitSchemaHelper;
import org.codeblessing.sourceamazing.api.process.schema.SchemaAccess;
import org.codeblessing.sourceamazing.api.process.templating.DomainUnitProcessTargetFilesHelper;
import org.codeblessing.sourceamazing.api.process.templating.TargetFileWithContent;
import org.codeblessing.sourceamazing.engine.process.ProcessSession;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptGraph;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptResolver;
import org.codeblessing.sourceamazing.engine.process.datacollection.DomainUnitDataCollectionHelperImpl;
import org.codeblessing.sourceamazing.engine.process.schema.DomainUnitSchemaHelperImpl;
import org.codeblessing.sourceamazing.engine.process.templating.DomainUnitProcessTargetFilesDataHelperImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0000\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/EngineProcess;", "", "processSession", "Lorg/codeblessing/sourceamazing/engine/process/ProcessSession;", "(Lorg/codeblessing/sourceamazing/engine/process/ProcessSession;)V", "processDomainUnit", "", "domainUnit", "Lorg/codeblessing/sourceamazing/api/process/DomainUnit;", "processDomainUnit$sourceamazing_engine", "runProcess", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nEngineProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineProcess.kt\norg/codeblessing/sourceamazing/engine/process/EngineProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1855#2,2:52\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 EngineProcess.kt\norg/codeblessing/sourceamazing/engine/process/EngineProcess\n*L\n17#1:52,2\n43#1:54,2\n*E\n"})
public final class EngineProcess {
    @NotNull
    private final ProcessSession processSession;

    public EngineProcess(@NotNull ProcessSession processSession) {
        Intrinsics.checkNotNullParameter((Object)processSession, (String)"processSession");
        this.processSession = processSession;
    }

    public final void runProcess() {
        this.processSession.getLoggerFacade().logUserInfo("SourceAmazing started...");
        Iterable $this$forEach$iv = this.processSession.getDomainUnits();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DomainUnit domainUnit = (DomainUnit)element$iv;
            boolean bl = false;
            this.processDomainUnit$sourceamazing_engine(domainUnit);
        }
        this.processSession.getLoggerFacade().logUserInfo("SourceAmazing finished.");
        this.processSession.getLoggerFacade().closeLoggerFacade();
    }

    public final void processDomainUnit$sourceamazing_engine(@NotNull DomainUnit<?, ?> domainUnit) {
        Intrinsics.checkNotNullParameter(domainUnit, (String)"domainUnit");
        String domainUnitDescription = domainUnit.getClass().getSimpleName();
        LoggerFacade loggerFacade = this.processSession.getLoggerFacade();
        SchemaAccess schema = domainUnit.createSchema((DomainUnitSchemaHelper)new DomainUnitSchemaHelperImpl());
        loggerFacade.logDebug(domainUnitDescription + ": Schema created (" + schema.allRootConcepts().size() + " concept(s))");
        List conceptData = domainUnit.processDomainUnitInputData(this.processSession.getParameterAccess(), (DomainUnitDataCollectionHelper)new DomainUnitDataCollectionHelperImpl(this.processSession, schema));
        loggerFacade.logDebug(domainUnitDescription + ": Data collected (" + conceptData.size() + " instance(s))");
        ConceptGraph conceptGraph = ConceptResolver.INSTANCE.validateAndResolveConcepts(schema, conceptData);
        loggerFacade.logDebug(domainUnitDescription + ": Concepts graph created");
        List targetFilesWithContent = domainUnit.processDomainUnitTargetFiles(this.processSession.getParameterAccess(), (DomainUnitProcessTargetFilesHelper)new DomainUnitProcessTargetFilesDataHelperImpl(conceptGraph));
        loggerFacade.logUserInfo(domainUnitDescription + ": Writing " + targetFilesWithContent.size() + " file(s)");
        Iterable $this$forEach$iv = targetFilesWithContent;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TargetFileWithContent targetFileWithContent = (TargetFileWithContent)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(domainUnitDescription).append(": Write file ").append(PathsKt.getName((Path)targetFileWithContent.getTargetFile())).append(": ");
            Path path = targetFileWithContent.getTargetFile().normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
            loggerFacade.logUserInfo(stringBuilder.append(((Object)path.toAbsolutePath()).toString()).toString());
            this.processSession.getFileSystemAccess().writeFile(targetFileWithContent.getTargetFile(), ArrayIteratorsKt.iterator((byte[])targetFileWithContent.getFileContent()));
        }
    }
}

