/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.conceptgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codeblessing.sourceamazing.api.process.schema.ConceptIdentifier;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptNode;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.SortedChildrenConceptNodesProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0004J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptGraph;", "Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/SortedChildrenConceptNodesProvider;", "concepts", "", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptIdentifier;", "Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptNode;", "(Ljava/util/Map;)V", "rootConceptsByConceptName", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "", "childConcepts", "conceptName", "parentConceptIdentifier", "children", "conceptNames", "", "conceptByConceptIdentifier", "conceptIdentifier", "rootConcepts", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nConceptGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptGraph.kt\norg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,49:1\n766#2:50\n857#2,2:51\n1477#2:53\n1502#2,3:54\n1505#2,3:64\n766#2:67\n857#2,2:68\n766#2:70\n857#2,2:71\n1045#2:73\n766#2:74\n857#2,2:75\n1360#2:77\n1446#2,5:78\n1045#2:83\n1045#2:84\n372#3,7:57\n*S KotlinDebug\n*F\n+ 1 ConceptGraph.kt\norg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptGraph\n*L\n11#1:50\n11#1:51,2\n12#1:53\n12#1:54,3\n12#1:64,3\n21#1:67\n21#1:68,2\n22#1:70\n22#1:71,2\n23#1:73\n28#1:74\n28#1:75,2\n38#1:77\n38#1:78,5\n39#1:83\n44#1:84\n12#1:57,7\n*E\n"})
public final class ConceptGraph
implements SortedChildrenConceptNodesProvider {
    @NotNull
    private final Map<ConceptIdentifier, ConceptNode> concepts;
    @NotNull
    private final Map<ConceptName, List<ConceptNode>> rootConceptsByConceptName;

    /*
     * WARNING - void declaration
     */
    public ConceptGraph(@NotNull Map<ConceptIdentifier, ? extends ConceptNode> concepts) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        ConceptNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(concepts, (String)"concepts");
        this.concepts = concepts;
        Iterable iterable = this.concepts.values();
        ConceptGraph conceptGraph = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConceptNode)element$iv$iv;
            boolean bl = false;
            if (!(it.getParentConceptNode() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (ConceptNode)element$iv$iv;
            boolean bl = false;
            ConceptName key$iv$iv = it.getConceptName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        conceptGraph.rootConceptsByConceptName = destination$iv$iv;
    }

    @NotNull
    public final ConceptNode conceptByConceptIdentifier(@NotNull ConceptIdentifier conceptIdentifier) throws NoSuchElementException {
        Intrinsics.checkNotNullParameter((Object)conceptIdentifier, (String)"conceptIdentifier");
        ConceptNode conceptNode = this.concepts.get(conceptIdentifier);
        if (conceptNode == null) {
            throw new NoSuchElementException("No ConceptNode with id '" + conceptIdentifier.getName() + "'.");
        }
        return conceptNode;
    }

    @NotNull
    public final List<ConceptNode> childConcepts(@NotNull ConceptName conceptName, @NotNull ConceptIdentifier parentConceptIdentifier) {
        ConceptNode conceptNode;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        Intrinsics.checkNotNullParameter((Object)parentConceptIdentifier, (String)"parentConceptIdentifier");
        Iterable $this$filter$iv = this.concepts.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            conceptNode = (ConceptNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)conceptNode.getConceptName(), (Object)conceptName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            conceptNode = (ConceptNode)element$iv$iv;
            boolean bl = false;
            ConceptNode conceptNode2 = conceptNode.getParentConceptNode();
            if (!Intrinsics.areEqual((Object)(conceptNode2 != null ? conceptNode2.getConceptIdentifier() : null), (Object)parentConceptIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConceptNode conceptNode = (ConceptNode)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(conceptNode.getSequenceNumber());
                conceptNode = (ConceptNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(conceptNode.getSequenceNumber()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ConceptNode> rootConcepts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.concepts.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConceptNode conceptNode = (ConceptNode)element$iv$iv;
            boolean bl = false;
            if (!(conceptNode.getParentConceptNode() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public List<ConceptNode> children(@NotNull ConceptName conceptName) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        return this.children(SetsKt.setOf((Object)conceptName));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ConceptNode> children(@NotNull Set<ConceptName> conceptNames) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conceptNames, (String)"conceptNames");
        Iterable $this$flatMap$iv = conceptNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConceptName conceptName = (ConceptName)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.rootConceptsByConceptName(conceptName);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConceptNode conceptNode = (ConceptNode)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(conceptNode.getSequenceNumber());
                conceptNode = (ConceptNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(conceptNode.getSequenceNumber()));
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<ConceptNode> rootConceptsByConceptName(ConceptName conceptName) {
        List list;
        List<ConceptNode> list2 = this.rootConceptsByConceptName.get(conceptName);
        if (list2 != null) {
            void $this$sortedBy$iv;
            Iterable iterable = list2;
            boolean $i$f$sortedBy = false;
            List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ConceptNode conceptNode = (ConceptNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(conceptNode.getSequenceNumber());
                    conceptNode = (ConceptNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(conceptNode.getSequenceNumber()));
                }
            });
            if (list3 != null) {
                list = list3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }
}

