/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.conceptgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.codeblessing.sourceamazing.api.process.conceptgraph.exceptions.ConceptGraphException;
import org.codeblessing.sourceamazing.api.process.conceptgraph.exceptions.DuplicateConceptIdentifierFoundConceptGraphException;
import org.codeblessing.sourceamazing.api.process.conceptgraph.exceptions.OccurrenceRangeConceptGraphException;
import org.codeblessing.sourceamazing.api.process.conceptgraph.exceptions.ParentConceptNotFoundConceptGraphException;
import org.codeblessing.sourceamazing.api.process.conceptgraph.exceptions.ReferencedConceptConceptGraphNodeNotFoundException;
import org.codeblessing.sourceamazing.api.process.datacollection.ConceptData;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.SchemaValidationException;
import org.codeblessing.sourceamazing.api.process.schema.ConceptIdentifier;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.api.process.schema.ConceptSchema;
import org.codeblessing.sourceamazing.api.process.schema.FacetName;
import org.codeblessing.sourceamazing.api.process.schema.SchemaAccess;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptGraph;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptNode;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.ConceptNodeDescriber;
import org.codeblessing.sourceamazing.engine.process.conceptgraph.MutableConceptNode;
import org.codeblessing.sourceamazing.engine.process.datacollection.ConceptDataValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptResolver;", "", "()V", "createChildrenConceptNodeMap", "", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptIdentifier;", "", "Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/MutableConceptNode;", "conceptDataEntries", "Lorg/codeblessing/sourceamazing/api/process/datacollection/ConceptData;", "conceptNodeMap", "createConceptNodeMap", "validateAndResolveConcepts", "Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptGraph;", "schema", "Lorg/codeblessing/sourceamazing/api/process/schema/SchemaAccess;", "validateChildNodes", "", "conceptGraph", "conceptNode", "Lorg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptNode;", "validateConceptGraph", "validateMinMaxOccurrence", "conceptSchema", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptSchema;", "conceptNodes", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nConceptResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptResolver.kt\norg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,119:1\n1855#2,2:120\n1194#2,2:122\n1222#2,4:124\n1855#2:128\n1477#2:129\n1502#2,3:130\n1505#2,3:140\n1855#2,2:143\n1856#2:145\n1477#2:146\n1502#2,3:147\n1505#2,3:157\n1855#2:160\n1855#2,2:161\n1856#2:163\n1855#2:164\n1855#2,2:165\n1856#2:167\n1549#2:168\n1620#2,3:169\n1855#2,2:172\n766#2:174\n857#2,2:175\n1490#2:177\n1520#2,3:178\n1523#2,3:188\n372#3,7:133\n372#3,7:150\n372#3,7:181\n*S KotlinDebug\n*F\n+ 1 ConceptResolver.kt\norg/codeblessing/sourceamazing/engine/process/conceptgraph/ConceptResolver\n*L\n15#1:120,2\n16#1:122,2\n16#1:124,4\n20#1:128\n35#1:129\n35#1:130,3\n35#1:140,3\n39#1:143,2\n20#1:145\n63#1:146\n63#1:147,3\n63#1:157,3\n65#1:160\n68#1:161,2\n65#1:163\n74#1:164\n77#1:165,2\n74#1:167\n88#1:168\n88#1:169,3\n96#1:172,2\n111#1:174\n111#1:175,2\n112#1:177\n112#1:178,3\n112#1:188,3\n35#1:133,7\n63#1:150,7\n112#1:181,7\n*E\n"})
public final class ConceptResolver {
    @NotNull
    public static final ConceptResolver INSTANCE = new ConceptResolver();

    private ConceptResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConceptGraph validateAndResolveConcepts(@NotNull SchemaAccess schema, @NotNull List<? extends ConceptData> conceptDataEntries) throws SchemaValidationException, ConceptGraphException {
        void $this$associateByTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(conceptDataEntries, (String)"conceptDataEntries");
        Iterable $this$forEach$iv = conceptDataEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ConceptData)element$iv;
            boolean bl = false;
            ConceptDataValidator.INSTANCE.validateSingleEntry(schema, (ConceptData)it);
        }
        Iterable $this$associateBy$iv = conceptDataEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        it = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            ConceptData conceptData = (ConceptData)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it2.getConceptIdentifier(), element$iv$iv);
        }
        Map conceptDataMap = destination$iv$iv;
        Map<ConceptIdentifier, MutableConceptNode> conceptNodeMap = this.createConceptNodeMap(conceptDataEntries);
        Map<ConceptIdentifier, List<MutableConceptNode>> childrenConceptsMap = this.createChildrenConceptNodeMap(conceptDataEntries, conceptNodeMap);
        Iterable $this$forEach$iv2 = conceptNodeMap.values();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map map;
            MutableConceptNode conceptNode = (MutableConceptNode)element$iv;
            boolean bl = false;
            ConceptSchema conceptSchema = schema.conceptByConceptName(conceptNode.getConceptName());
            Object v = conceptDataMap.get(conceptNode.getConceptIdentifier());
            if (v == null) {
                String bl2 = "Required value was null.";
                throw new IllegalArgumentException(bl2.toString());
            }
            ConceptData conceptData = (ConceptData)v;
            ConceptIdentifier parentConceptIdentifier = conceptData.getParentConceptIdentifier();
            if (parentConceptIdentifier != null) {
                MutableConceptNode mutableConceptNode = conceptNodeMap.get(parentConceptIdentifier);
                if (mutableConceptNode == null) {
                    throw new ParentConceptNotFoundConceptGraphException(conceptNode.getConceptName(), conceptNode.getConceptIdentifier(), parentConceptIdentifier);
                }
                conceptNode.setParentConceptNode(mutableConceptNode);
            }
            MutableConceptNode mutableConceptNode = conceptNode;
            List<MutableConceptNode> bl2 = childrenConceptsMap.get(conceptNode.getConceptIdentifier());
            if (bl2 != null) {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Iterable iterable = bl2;
                MutableConceptNode mutableConceptNode2 = mutableConceptNode;
                boolean $i$f$groupBy = false;
                void var19_32 = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    MutableConceptNode it3 = (MutableConceptNode)element$iv$iv;
                    boolean bl3 = false;
                    ConceptName key$iv$iv = it3.getConceptName();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                map = destination$iv$iv2;
                mutableConceptNode = mutableConceptNode2;
            } else {
                map = MapsKt.emptyMap();
            }
            mutableConceptNode.setChildrenConceptNodes(map);
            Iterable $this$forEach$iv3 = conceptSchema.getFacetNames();
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                FacetName facetName = (FacetName)element$iv2;
                boolean bl5 = false;
                Object facetValue = conceptData.getFacet(facetName);
                if (facetValue instanceof ConceptIdentifier) {
                    MutableConceptNode referencedConceptNode;
                    if (conceptNodeMap.get(facetValue) == null) {
                        ConceptName conceptName = conceptNode.getConceptName();
                        ConceptIdentifier conceptIdentifier = conceptNode.getConceptIdentifier();
                        throw new ReferencedConceptConceptGraphNodeNotFoundException(conceptIdentifier, conceptName, facetName, (ConceptIdentifier)facetValue);
                    }
                    conceptNode.getFacetValues().put(facetName, referencedConceptNode);
                    continue;
                }
                conceptNode.getFacetValues().put(facetName, facetValue);
            }
        }
        ConceptGraph conceptGraph = new ConceptGraph(conceptNodeMap);
        this.validateConceptGraph(schema, conceptGraph);
        return conceptGraph;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateConceptGraph(SchemaAccess schema, ConceptGraph conceptGraph) throws ConceptGraphException {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = conceptGraph.rootConcepts();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ConceptNode it = (ConceptNode)element$iv$iv;
            boolean bl = false;
            ConceptName key$iv$iv = it.getConceptName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map rootConceptsByConceptName = destination$iv$iv;
        Iterable $this$forEach$iv = schema.allRootConcepts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConceptSchema rootConceptSchema = (ConceptSchema)element$iv;
            boolean bl = false;
            List list = (List)rootConceptsByConceptName.get(rootConceptSchema.getConceptName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List conceptNodesForSchema = list;
            INSTANCE.validateMinMaxOccurrence(rootConceptSchema, conceptNodesForSchema);
            Iterable $this$forEach$iv2 = conceptNodesForSchema;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConceptNode rootConceptNode = (ConceptNode)element$iv2;
                boolean bl3 = false;
                INSTANCE.validateChildNodes(schema, conceptGraph, rootConceptNode);
            }
        }
    }

    private final void validateChildNodes(SchemaAccess schema, ConceptGraph conceptGraph, ConceptNode conceptNode) {
        ConceptSchema conceptSchema = schema.conceptByConceptName(conceptNode.getConceptName());
        Iterable $this$forEach$iv = schema.allChildrenConcepts(conceptSchema);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConceptSchema childConceptSchema = (ConceptSchema)element$iv;
            boolean bl = false;
            List<ConceptNode> childrenConceptNodes = conceptGraph.childConcepts(childConceptSchema.getConceptName(), conceptNode.getConceptIdentifier());
            INSTANCE.validateMinMaxOccurrence(childConceptSchema, childrenConceptNodes);
            Iterable $this$forEach$iv2 = childrenConceptNodes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConceptNode childConceptNode = (ConceptNode)element$iv2;
                boolean bl2 = false;
                INSTANCE.validateChildNodes(schema, conceptGraph, childConceptNode);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateMinMaxOccurrence(ConceptSchema conceptSchema, List<? extends ConceptNode> conceptNodes) throws ConceptGraphException {
        IntRange range = new IntRange(conceptSchema.getMinOccurrence(), conceptSchema.getMaxOccurrence());
        if (!range.contains(conceptNodes.size())) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = conceptNodes;
            int n = conceptSchema.getMaxOccurrence();
            int n2 = conceptSchema.getMinOccurrence();
            ConceptName conceptName = conceptSchema.getConceptName();
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConceptNode conceptNode = (ConceptNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ConceptNodeDescriber.INSTANCE.createConceptNodeDescription((ConceptNode)it));
            }
            Collection<String> collection2 = collection = (List)destination$iv$iv;
            int n3 = n;
            int n4 = n2;
            ConceptName conceptName2 = conceptName;
            throw new OccurrenceRangeConceptGraphException(conceptName2, n4, n3, collection2);
        }
    }

    private final Map<ConceptIdentifier, MutableConceptNode> createConceptNodeMap(List<? extends ConceptData> conceptDataEntries) {
        Map conceptNodeMap = new LinkedHashMap();
        Iterable $this$forEach$iv = conceptDataEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConceptData conceptData = (ConceptData)element$iv;
            boolean bl = false;
            ConceptIdentifier conceptIdentifier = conceptData.getConceptIdentifier();
            if (conceptNodeMap.containsKey(conceptIdentifier)) {
                throw new DuplicateConceptIdentifierFoundConceptGraphException(conceptData.getConceptName(), conceptIdentifier);
            }
            conceptNodeMap.put(conceptIdentifier, new MutableConceptNode(conceptData.getSequenceNumber(), conceptData.getConceptName(), conceptData.getConceptIdentifier(), null, null, null, 56, null));
        }
        return conceptNodeMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ConceptIdentifier, List<MutableConceptNode>> createChildrenConceptNodeMap(List<? extends ConceptData> conceptDataEntries, Map<ConceptIdentifier, MutableConceptNode> conceptNodeMap) {
        void $this$groupByTo$iv$iv;
        ConceptData it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = conceptDataEntries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConceptData)element$iv$iv;
            boolean bl = false;
            if (!(it.getParentConceptIdentifier() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ConceptIdentifier key$iv$iv;
            it = (ConceptData)element$iv$iv;
            boolean bl = false;
            if (it.getParentConceptIdentifier() == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            it = (ConceptData)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            MutableConceptNode mutableConceptNode = conceptNodeMap.get(it.getConceptIdentifier());
            if (mutableConceptNode == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            list.add(mutableConceptNode);
        }
        return destination$iv$iv;
    }
}

