/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.api.process.datacollection.ConceptData;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.InvalidConceptParentException;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.MissingFacetValueException;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.SchemaValidationException;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.UnknownConceptException;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.UnknownFacetNameException;
import org.codeblessing.sourceamazing.api.process.datacollection.exceptions.WrongTypeForFacetValueException;
import org.codeblessing.sourceamazing.api.process.schema.ConceptSchema;
import org.codeblessing.sourceamazing.api.process.schema.FacetName;
import org.codeblessing.sourceamazing.api.process.schema.FacetSchema;
import org.codeblessing.sourceamazing.api.process.schema.SchemaAccess;
import org.codeblessing.sourceamazing.engine.process.datacollection.ConceptDataValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/datacollection/ConceptDataValidator;", "", "()V", "isValidParentConcept", "", "schemaConcept", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptSchema;", "conceptData", "Lorg/codeblessing/sourceamazing/api/process/datacollection/ConceptData;", "validateConceptBase", "", "schema", "Lorg/codeblessing/sourceamazing/api/process/schema/SchemaAccess;", "validateForFacetType", "validateForMissingMandatoryFacets", "validateForObsoletFacets", "validateParentConceptBase", "validateSingleEntry", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nConceptDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptDataValidator.kt\norg/codeblessing/sourceamazing/engine/process/datacollection/ConceptDataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1855#2,2:107\n766#2:109\n857#2,2:110\n1855#2,2:112\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 ConceptDataValidator.kt\norg/codeblessing/sourceamazing/engine/process/datacollection/ConceptDataValidator\n*L\n40#1:107,2\n56#1:109\n56#1:110,2\n57#1:112,2\n79#1:114,2\n*E\n"})
public final class ConceptDataValidator {
    @NotNull
    public static final ConceptDataValidator INSTANCE = new ConceptDataValidator();

    private ConceptDataValidator() {
    }

    public final void validateSingleEntry(@NotNull SchemaAccess schema, @NotNull ConceptData conceptData) throws SchemaValidationException {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)conceptData, (String)"conceptData");
        this.validateConceptBase(schema, conceptData);
        ConceptSchema schemaConcept = schema.conceptByConceptName(conceptData.getConceptName());
        this.validateParentConceptBase(schemaConcept, conceptData);
        this.validateForObsoletFacets(schemaConcept, conceptData);
        this.validateForMissingMandatoryFacets(schemaConcept, conceptData);
        this.validateForFacetType(schemaConcept, conceptData);
    }

    private final void validateConceptBase(SchemaAccess schema, ConceptData conceptData) {
        if (!schema.hasConceptName(conceptData.getConceptName())) {
            throw new UnknownConceptException(conceptData.getConceptName(), conceptData.getConceptIdentifier());
        }
    }

    private final void validateParentConceptBase(ConceptSchema schemaConcept, ConceptData conceptData) {
        if (!this.isValidParentConcept(schemaConcept, conceptData)) {
            throw new InvalidConceptParentException(conceptData.getConceptName(), conceptData.getConceptIdentifier(), conceptData.getParentConceptIdentifier());
        }
    }

    private final void validateForObsoletFacets(ConceptSchema schemaConcept, ConceptData conceptData) {
        Iterable $this$forEach$iv = conceptData.getFacetNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetName facetName = (FacetName)element$iv;
            boolean bl = false;
            if (schemaConcept.hasFacet(facetName)) continue;
            throw new UnknownFacetNameException(conceptData.getConceptName(), conceptData.getConceptIdentifier(), facetName, "Facet with facet name '" + facetName.getName() + "' is not known by the schema. Known facets are: [" + CollectionsKt.joinToString$default((Iterable)schemaConcept.getFacetNames(), null, null, null, (int)0, null, (Function1)validateForObsoletFacets.1.1.INSTANCE, (int)31, null) + ']');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForMissingMandatoryFacets(ConceptSchema schemaConcept, ConceptData conceptData) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = schemaConcept.getFacets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FacetSchema facetSchema = (FacetSchema)element$iv$iv;
            boolean bl = false;
            if (!facetSchema.getMandatory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetSchema facetSchema = (FacetSchema)element$iv;
            boolean bl = false;
            if (!conceptData.hasFacet(facetSchema.getFacetName())) {
                throw new MissingFacetValueException(conceptData.getConceptName(), conceptData.getConceptIdentifier(), facetSchema.getFacetName());
            }
            Object facetValue = conceptData.getFacet(facetSchema.getFacetName());
            if (facetValue != null || !facetSchema.getMandatory()) continue;
            throw new MissingFacetValueException(conceptData.getConceptName(), conceptData.getConceptIdentifier(), facetSchema.getFacetName());
        }
    }

    private final void validateForFacetType(ConceptSchema schemaConcept, ConceptData conceptData) {
        Iterable $this$forEach$iv = schemaConcept.getFacets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object facetValue;
            FacetSchema facetSchema = (FacetSchema)element$iv;
            boolean bl = false;
            if (!conceptData.hasFacet(facetSchema.getFacetName()) || conceptData.getFacet(facetSchema.getFacetName()) == null || facetSchema.getFacetType().isCompatibleInputType(facetValue)) continue;
            KClass actualClass = Reflection.getOrCreateKotlinClass(facetValue.getClass());
            throw new WrongTypeForFacetValueException(conceptData.getConceptName(), conceptData.getConceptIdentifier(), facetSchema.getFacetName(), "A facet of type '" + facetSchema.getFacetType() + "' can not have a value of type '" + actualClass + '\'');
        }
    }

    private final boolean isValidParentConcept(ConceptSchema schemaConcept, ConceptData conceptData) {
        if (conceptData.getParentConceptIdentifier() == null) {
            return schemaConcept.isRootConcept();
        }
        return !((Collection)schemaConcept.getParentConceptNames()).isEmpty();
    }
}

