/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.datacollection.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.AddConceptAndFacets;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.AutoRandomConceptIdentifier;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.ConceptBuilder;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.ConceptIdentifierValue;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.ConceptNameValue;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.FacetValue;
import org.codeblessing.sourceamazing.api.process.datacollection.annotations.ParameterDefinedConceptName;
import org.codeblessing.sourceamazing.api.process.schema.ConceptIdentifier;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.api.process.schema.FacetName;
import org.codeblessing.sourceamazing.engine.proxy.InvocationHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006J9\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017JI\u0010\u0018\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\b0\f2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u001cJA\u0010\u0018\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\b0\f2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u001dJG\u0010\u001e\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\b0\f2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/datacollection/proxy/DataCollectorInvocationHandlerHelper;", "", "()V", "getConceptBuilderClazz", "Lkotlin/reflect/KClass;", "method", "Ljava/lang/reflect/Method;", "getConceptBuilderParameter", "T", "args", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "getConceptIdentifierParameter", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptIdentifier;", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Lorg/codeblessing/sourceamazing/api/process/schema/ConceptIdentifier;", "getConceptNameParameter", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "getFacetName", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetName;", "parameter", "Ljava/lang/reflect/Parameter;", "getNullableParameter", "annotation", "", "type", "(Ljava/lang/reflect/Method;Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/reflect/Method;Ljava/lang/reflect/Parameter;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "getParameter", "sourceamazing-engine"})
public final class DataCollectorInvocationHandlerHelper {
    @NotNull
    public static final DataCollectorInvocationHandlerHelper INSTANCE = new DataCollectorInvocationHandlerHelper();

    private DataCollectorInvocationHandlerHelper() {
    }

    @NotNull
    public final ConceptName getConceptNameParameter(@NotNull Method method, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ConceptNameValue conceptNameValueAnnotation = method.getAnnotation(ConceptNameValue.class);
        if (conceptNameValueAnnotation != null) {
            return ConceptName.Companion.of(conceptNameValueAnnotation.conceptName());
        }
        return this.getParameter(method, ParameterDefinedConceptName.class, ConceptName.class, args);
    }

    @NotNull
    public final ConceptIdentifier getConceptIdentifierParameter(@NotNull Method method, @NotNull Object[] args) {
        AutoRandomConceptIdentifier autoRandomConceptIdentifier;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int numberOfParams = InvocationHandlerHelper.INSTANCE.numberOfParamsAnnotatedWith(method, ConceptIdentifierValue.class);
        if (numberOfParams > 0) {
            if (numberOfParams > 1) {
                throw new IllegalStateException("Method '" + method + "' has to many parameters annotated with " + ConceptIdentifierValue.class + ". Zero or one is allowed, was " + numberOfParams + '.');
            }
            Object conceptIdentifierValue = this.getNullableParameter(method, ConceptIdentifierValue.class, Object.class, args);
            if (conceptIdentifierValue != null) {
                ConceptIdentifier conceptIdentifier;
                Object object = conceptIdentifierValue;
                if (object instanceof String) {
                    conceptIdentifier = ConceptIdentifier.Companion.of((String)conceptIdentifierValue);
                } else if (object instanceof ConceptIdentifier) {
                    conceptIdentifier = (ConceptIdentifier)conceptIdentifierValue;
                } else {
                    throw new IllegalStateException("Method '" + method + "' has a parameter annotated with '" + ConceptIdentifier.class + "' where it's value is neither of type '" + String.class + "' nor '" + ConceptIdentifier.class + "' but '" + conceptIdentifierValue + "'.");
                }
                return conceptIdentifier;
            }
        }
        if ((autoRandomConceptIdentifier = method.getAnnotation(AutoRandomConceptIdentifier.class)) != null) {
            return ConceptIdentifier.Companion.random();
        }
        throw new IllegalStateException("No concept identifier found in method '" + method + "'. Use the annotations '" + ConceptIdentifierValue.class + "' to manually declare one or '" + AutoRandomConceptIdentifier.class + "' to add a random one. Method arguments were: '" + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, null, (int)63, null) + '\'');
    }

    @NotNull
    public final KClass<?> getConceptBuilderClazz(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Reflection.getOrCreateKotlinClass((Class)method.getAnnotation(AddConceptAndFacets.class).conceptBuilderClazz());
    }

    @NotNull
    public final FacetName getFacetName(@NotNull Parameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return FacetName.Companion.of(parameter.getAnnotation(FacetValue.class).facetName());
    }

    @Nullable
    public final <T> T getConceptBuilderParameter(@NotNull Method method, @NotNull Object[] args, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray2.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Parameter parameter = parameterArray2[i];
            if (parameter.getAnnotation(ConceptBuilder.class) == null) continue;
            return (T)args[index];
        }
        return null;
    }

    @Nullable
    public final <T> T getNullableParameter(@NotNull Method method, @NotNull Class<? extends Annotation> annotation, @NotNull Class<T> type, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray2.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Parameter parameter = parameterArray2[i];
            if (parameter.getAnnotation(annotation) == null) continue;
            return (T)args[index];
        }
        throw new IllegalStateException("Method " + method + ": No arguments found for annotation '" + annotation + "' in " + args);
    }

    public final <T> T getParameter(@NotNull Method method, @NotNull Class<? extends Annotation> annotation, @NotNull Class<T> type, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        T t = this.getNullableParameter(method, annotation, type, args);
        if (t == null) {
            throw new IllegalStateException("Method " + method + ": Arguments for annotation '" + annotation + "' in " + args + " was null.");
        }
        return t;
    }

    @Nullable
    public final <T> T getNullableParameter(@NotNull Method method, @NotNull Parameter parameter, @NotNull Class<T> type, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray2.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Parameter parameterOfIndex = parameterArray2[i];
            if (!Intrinsics.areEqual((Object)parameterOfIndex, (Object)parameter)) continue;
            return (T)args[index];
        }
        throw new IllegalStateException("Method " + method + ": No arguments found for parameter '" + parameter + "' in " + args);
    }
}

