/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.schema;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.api.process.schema.FacetName;
import org.codeblessing.sourceamazing.api.process.schema.FacetSchema;
import org.codeblessing.sourceamazing.api.process.schema.FacetTypeEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u00c6\u0001J\u0012\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001eH\u0016J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u001a\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/schema/FacetSchemaImpl;", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetSchema;", "facetName", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetName;", "facetType", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetTypeEnum;", "mandatory", "", "referencingConcept", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "enumerationType", "Lkotlin/reflect/KClass;", "(Lorg/codeblessing/sourceamazing/api/process/schema/FacetName;Lorg/codeblessing/sourceamazing/api/process/schema/FacetTypeEnum;ZLorg/codeblessing/sourceamazing/api/process/schema/ConceptName;Lkotlin/reflect/KClass;)V", "getEnumerationType", "()Lkotlin/reflect/KClass;", "getFacetName", "()Lorg/codeblessing/sourceamazing/api/process/schema/FacetName;", "getFacetType", "()Lorg/codeblessing/sourceamazing/api/process/schema/FacetTypeEnum;", "getMandatory", "()Z", "getReferencingConcept", "()Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "component1", "component2", "component3", "component4", "component5", "copy", "enumerationValues", "", "", "equals", "other", "", "hashCode", "", "toString", "", "sourceamazing-engine"})
public final class FacetSchemaImpl
implements FacetSchema {
    @NotNull
    private final FacetName facetName;
    @NotNull
    private final FacetTypeEnum facetType;
    private final boolean mandatory;
    @Nullable
    private final ConceptName referencingConcept;
    @Nullable
    private final KClass<?> enumerationType;

    public FacetSchemaImpl(@NotNull FacetName facetName, @NotNull FacetTypeEnum facetType, boolean mandatory, @Nullable ConceptName referencingConcept, @Nullable KClass<?> enumerationType) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter((Object)facetType, (String)"facetType");
        this.facetName = facetName;
        this.facetType = facetType;
        this.mandatory = mandatory;
        this.referencingConcept = referencingConcept;
        this.enumerationType = enumerationType;
    }

    @NotNull
    public FacetName getFacetName() {
        return this.facetName;
    }

    @NotNull
    public FacetTypeEnum getFacetType() {
        return this.facetType;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    @Nullable
    public ConceptName getReferencingConcept() {
        return this.referencingConcept;
    }

    @Nullable
    public KClass<?> getEnumerationType() {
        return this.enumerationType;
    }

    @NotNull
    public List<Enum<?>> enumerationValues() {
        KClass<?> kClass = this.getEnumerationType();
        if (kClass == null) {
            return CollectionsKt.emptyList();
        }
        KClass<?> enumerationType = kClass;
        Object[] objectArray = JvmClassMappingKt.getJavaClass(enumerationType).getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
        return ArraysKt.filterIsInstance((Object[])objectArray, Enum.class);
    }

    @NotNull
    public final FacetName component1() {
        return this.facetName;
    }

    @NotNull
    public final FacetTypeEnum component2() {
        return this.facetType;
    }

    public final boolean component3() {
        return this.mandatory;
    }

    @Nullable
    public final ConceptName component4() {
        return this.referencingConcept;
    }

    @Nullable
    public final KClass<?> component5() {
        return this.enumerationType;
    }

    @NotNull
    public final FacetSchemaImpl copy(@NotNull FacetName facetName, @NotNull FacetTypeEnum facetType, boolean mandatory, @Nullable ConceptName referencingConcept, @Nullable KClass<?> enumerationType) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter((Object)facetType, (String)"facetType");
        return new FacetSchemaImpl(facetName, facetType, mandatory, referencingConcept, enumerationType);
    }

    public static /* synthetic */ FacetSchemaImpl copy$default(FacetSchemaImpl facetSchemaImpl, FacetName facetName, FacetTypeEnum facetTypeEnum, boolean bl, ConceptName conceptName, KClass kClass, int n, Object object) {
        if ((n & 1) != 0) {
            facetName = facetSchemaImpl.facetName;
        }
        if ((n & 2) != 0) {
            facetTypeEnum = facetSchemaImpl.facetType;
        }
        if ((n & 4) != 0) {
            bl = facetSchemaImpl.mandatory;
        }
        if ((n & 8) != 0) {
            conceptName = facetSchemaImpl.referencingConcept;
        }
        if ((n & 0x10) != 0) {
            kClass = facetSchemaImpl.enumerationType;
        }
        return facetSchemaImpl.copy(facetName, facetTypeEnum, bl, conceptName, kClass);
    }

    @NotNull
    public String toString() {
        return "FacetSchemaImpl(facetName=" + this.facetName + ", facetType=" + this.facetType + ", mandatory=" + this.mandatory + ", referencingConcept=" + this.referencingConcept + ", enumerationType=" + this.enumerationType + ')';
    }

    public int hashCode() {
        int result = this.facetName.hashCode();
        result = result * 31 + this.facetType.hashCode();
        int n = this.mandatory ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.referencingConcept == null ? 0 : this.referencingConcept.hashCode());
        result = result * 31 + (this.enumerationType == null ? 0 : this.enumerationType.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FacetSchemaImpl)) {
            return false;
        }
        FacetSchemaImpl facetSchemaImpl = (FacetSchemaImpl)other;
        if (!Intrinsics.areEqual((Object)this.facetName, (Object)facetSchemaImpl.facetName)) {
            return false;
        }
        if (this.facetType != facetSchemaImpl.facetType) {
            return false;
        }
        if (this.mandatory != facetSchemaImpl.mandatory) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.referencingConcept, (Object)facetSchemaImpl.referencingConcept)) {
            return false;
        }
        return Intrinsics.areEqual(this.enumerationType, facetSchemaImpl.enumerationType);
    }
}

