/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.schema;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.api.process.schema.ConceptIdentifier;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.api.process.schema.ConceptSchema;
import org.codeblessing.sourceamazing.api.process.schema.FacetName;
import org.codeblessing.sourceamazing.api.process.schema.FacetSchema;
import org.codeblessing.sourceamazing.api.process.schema.FacetTypeEnum;
import org.codeblessing.sourceamazing.api.process.schema.annotations.ChildConcept;
import org.codeblessing.sourceamazing.api.process.schema.annotations.ChildConceptWithCommonBaseInterface;
import org.codeblessing.sourceamazing.api.process.schema.annotations.ChildConcepts;
import org.codeblessing.sourceamazing.api.process.schema.annotations.ChildConceptsWithCommonBaseInterface;
import org.codeblessing.sourceamazing.api.process.schema.annotations.Concept;
import org.codeblessing.sourceamazing.api.process.schema.annotations.ConceptId;
import org.codeblessing.sourceamazing.api.process.schema.annotations.Facet;
import org.codeblessing.sourceamazing.api.process.schema.annotations.Schema;
import org.codeblessing.sourceamazing.api.process.schema.exceptions.MalformedSchemaException;
import org.codeblessing.sourceamazing.engine.process.schema.ConceptSchemaImpl;
import org.codeblessing.sourceamazing.engine.process.schema.FacetSchemaImpl;
import org.codeblessing.sourceamazing.engine.process.schema.SchemaAnnotationConst;
import org.codeblessing.sourceamazing.engine.process.schema.SchemaImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u00072\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J0\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\u000e2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J&\u0010\u0013\u001a\u00020\u00042\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J$\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u000b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J \u0010 \u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\"2\u0014\u0010%\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u000b0\u000fH\u0002J \u0010&\u001a\u00020\u001c2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J:\u0010)\u001a\u00020\u001c2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002JT\u0010,\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0014\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b0\u000f2\u000e\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000bH\u0002J2\u0010/\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J:\u00100\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J:\u00101\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J:\u00102\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J:\u00103\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J(\u00104\u001a\u00020\u00042\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010$\u001a\u00020\"H\u0002J.\u00106\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J$\u00107\u001a\u00020\u00042\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u000b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J&\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u0001092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010$\u001a\u00020\"H\u0002\u00a8\u0006>"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/schema/SchemaCreator;", "", "()V", "addConceptSchema", "", "concepts", "", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptSchema;", "conceptName", "conceptClass", "Ljava/lang/Class;", "parentConceptSchema", "allHierarchyPathsToRoot", "", "", "", "allInterfaces", "clazz", "collectInterfacesRecursive", "interfaceCollector", "", "createSchemaFromSchemaDefinitionClass", "Lorg/codeblessing/sourceamazing/engine/process/schema/SchemaImpl;", "schemaDefinitionClass", "gatherFacets", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetSchema;", "hasClassAnnotation", "", "annotation", "", "classToInspect", "hasMethodAnnotation", "methodToInspect", "Ljava/lang/reflect/Method;", "hasSupportedConceptAnnotation", "method", "supportedConceptAnnotations", "isInheriting", "subInterface", "baseInterface", "supportForChildConceptMethod", "definitionClass", "parentConceptName", "validateAndAddChildConceptWithCommonBaseClass", "conceptClasses", "baseInterfaceClass", "validateAndAddConcept", "validateAndAddConceptForChildConceptAnnotation", "validateAndAddConceptForChildConceptWithCommonBaseInterfaceAnnotation", "validateAndAddConceptForChildConceptsAnnotation", "validateAndAddConceptForChildConceptsWithCommonBaseInterfaceAnnotation", "validateChildConceptReturnTypeMethod", "expectedReturnType", "validateConceptItselfNotPresentInUpperHierarchy", "validateTypeAnnotation", "validatedEnumerationType", "Lkotlin/reflect/KClass;", "facetName", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetName;", "facetType", "Lorg/codeblessing/sourceamazing/api/process/schema/FacetTypeEnum;", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nSchemaCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaCreator.kt\norg/codeblessing/sourceamazing/engine/process/schema/SchemaCreator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n13309#2,2:330\n13309#2,2:333\n11065#2:344\n11400#2,3:345\n11065#2:348\n11400#2,3:349\n13309#2,2:354\n13309#2:356\n13310#2:359\n4117#2:360\n4217#2,2:361\n1#3:332\n1855#4,2:335\n1855#4:337\n1855#4,2:338\n1856#4:340\n1747#4,3:341\n1855#4,2:352\n288#4,2:357\n*S KotlinDebug\n*F\n+ 1 SchemaCreator.kt\norg/codeblessing/sourceamazing/engine/process/schema/SchemaCreator\n*L\n23#1:330,2\n53#1:333,2\n158#1:344\n158#1:345,3\n170#1:348\n170#1:349,3\n201#1:354,2\n260#1:356\n260#1:359\n301#1:360\n301#1:361,2\n76#1:335,2\n88#1:337\n89#1:338,2\n88#1:340\n103#1:341,3\n181#1:352,2\n270#1:357,2\n*E\n"})
public final class SchemaCreator {
    @NotNull
    public static final SchemaCreator INSTANCE = new SchemaCreator();

    private SchemaCreator() {
    }

    @NotNull
    public final SchemaImpl createSchemaFromSchemaDefinitionClass(@NotNull Class<?> schemaDefinitionClass) throws MalformedSchemaException {
        Intrinsics.checkNotNullParameter(schemaDefinitionClass, (String)"schemaDefinitionClass");
        this.validateTypeAnnotation(Schema.class, schemaDefinitionClass);
        if (this.hasClassAnnotation(Concept.class, schemaDefinitionClass)) {
            throw new MalformedSchemaException("Definition class '" + schemaDefinitionClass.getName() + "' can not be a concept having an annotation of type '" + Concept.class.getName() + '\'');
        }
        Map concepts = new LinkedHashMap();
        Method[] methodArray = schemaDefinitionClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)method);
            if (INSTANCE.supportForChildConceptMethod(concepts, schemaDefinitionClass, method, null)) continue;
            throw new MalformedSchemaException("Schema definition class '" + schemaDefinitionClass.getName() + "' can only have methods annotated with the following annotations: " + SchemaAnnotationConst.INSTANCE.getSupportedSchemaAnnotations() + ". Not valid for method '" + method + "'.");
        }
        return new SchemaImpl(concepts);
    }

    private final void validateChildConceptReturnTypeMethod(Class<?> expectedReturnType, Class<?> definitionClass, Method method) {
        if (!Intrinsics.areEqual(method.getReturnType(), expectedReturnType)) {
            throw new MalformedSchemaException("The method '" + method + "' on the definition class '" + definitionClass.getName() + "' must return '" + expectedReturnType + "' but is returning '" + method.getReturnType() + "'.");
        }
    }

    private final void validateAndAddConcept(Map<ConceptName, ConceptSchema> concepts, Class<?> conceptClass, ConceptName parentConceptName) {
        ConceptSchema conceptSchema;
        this.validateTypeAnnotation(Concept.class, conceptClass);
        ConceptName conceptName = ConceptName.Companion.of(conceptClass.getAnnotation(Concept.class).conceptName());
        this.validateConceptItselfNotPresentInUpperHierarchy(concepts, conceptName, parentConceptName);
        ConceptName conceptName2 = parentConceptName;
        if (conceptName2 != null) {
            ConceptName it = conceptName2;
            boolean bl = false;
            conceptSchema = concepts.get(parentConceptName);
        } else {
            conceptSchema = null;
        }
        ConceptSchema parentConceptSchema = conceptSchema;
        this.addConceptSchema(concepts, conceptName, conceptClass, parentConceptSchema);
        List<Class<? extends Annotation>> supportedConceptAnnotations = SchemaAnnotationConst.INSTANCE.getSupportedConceptAnnotations();
        Method[] methodArray = conceptClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)method);
            if (INSTANCE.supportForChildConceptMethod(concepts, conceptClass, method, conceptName) || INSTANCE.hasSupportedConceptAnnotation(method, supportedConceptAnnotations)) continue;
            throw new MalformedSchemaException("Concept definition class '" + conceptClass.getName() + "' can only have methods annotated with the following annotations: " + supportedConceptAnnotations + ". Not valid for method '" + method + "'.");
        }
    }

    private final void validateConceptItselfNotPresentInUpperHierarchy(Map<ConceptName, ConceptSchema> concepts, ConceptName conceptName, ConceptName parentConceptName) {
        if (parentConceptName == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)conceptName, (Object)parentConceptName)) {
            throw new MalformedSchemaException("Concept '" + conceptName.getName() + "' can not be its own parent.");
        }
        Set<List<ConceptName>> allHierarchicalBranches = this.allHierarchyPathsToRoot(concepts, parentConceptName);
        Iterable $this$forEach$iv = allHierarchicalBranches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List parentConceptHierarchy = (List)element$iv;
            boolean bl = false;
            if (!parentConceptHierarchy.contains(conceptName)) continue;
            throw new MalformedSchemaException("There is a cyclic dependency with concept '" + conceptName.getName() + "'. Parent concepts in a hierarchy must be all different concepts, but was " + parentConceptHierarchy + '.');
        }
    }

    private final Set<List<ConceptName>> allHierarchyPathsToRoot(Map<ConceptName, ? extends ConceptSchema> concepts, ConceptName conceptName) {
        ConceptSchema conceptSchema = concepts.get(conceptName);
        if (conceptSchema == null) {
            throw new IllegalStateException("Concept '" + conceptName.getName() + "' not found.");
        }
        ConceptSchema conceptSchema2 = conceptSchema;
        Set resultSet = new LinkedHashSet();
        Iterable $this$forEach$iv = conceptSchema2.getParentConceptNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConceptName parentConceptName = (ConceptName)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = INSTANCE.allHierarchyPathsToRoot(concepts, parentConceptName);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List allBranchesOfParent = (List)element$iv2;
                boolean bl2 = false;
                resultSet.add(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)conceptName), (Iterable)allBranchesOfParent));
            }
        }
        if (resultSet.isEmpty()) {
            return SetsKt.setOf((Object)CollectionsKt.listOf((Object)conceptName));
        }
        return resultSet;
    }

    private final boolean hasSupportedConceptAnnotation(Method method, List<? extends Class<? extends Annotation>> supportedConceptAnnotations) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = supportedConceptAnnotations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class supportedAnnotation = (Class)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.hasMethodAnnotation(supportedAnnotation, method)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean supportForChildConceptMethod(Map<ConceptName, ConceptSchema> concepts, Class<?> definitionClass, Method method, ConceptName parentConceptName) {
        if (this.hasMethodAnnotation(ChildConcepts.class, method)) {
            this.validateAndAddConceptForChildConceptsAnnotation(concepts, definitionClass, method, parentConceptName);
            return true;
        }
        if (this.hasMethodAnnotation(ChildConcept.class, method)) {
            this.validateAndAddConceptForChildConceptAnnotation(concepts, definitionClass, method, parentConceptName);
            return true;
        }
        if (this.hasMethodAnnotation(ChildConceptsWithCommonBaseInterface.class, method)) {
            this.validateAndAddConceptForChildConceptsWithCommonBaseInterfaceAnnotation(concepts, definitionClass, method, parentConceptName);
            return true;
        }
        if (this.hasMethodAnnotation(ChildConceptWithCommonBaseInterface.class, method)) {
            this.validateAndAddConceptForChildConceptWithCommonBaseInterfaceAnnotation(concepts, definitionClass, method, parentConceptName);
            return true;
        }
        return false;
    }

    private final void validateAndAddConceptForChildConceptAnnotation(Map<ConceptName, ConceptSchema> concepts, Class<?> definitionClass, Method method, ConceptName parentConceptName) {
        Class conceptClass = method.getAnnotation(ChildConcept.class).conceptClass();
        this.validateChildConceptReturnTypeMethod(conceptClass, definitionClass, method);
        this.validateAndAddConcept(concepts, conceptClass, parentConceptName);
    }

    private final void validateAndAddConceptForChildConceptsAnnotation(Map<ConceptName, ConceptSchema> concepts, Class<?> definitionClass, Method method, ConceptName parentConceptName) {
        this.validateChildConceptReturnTypeMethod(List.class, definitionClass, method);
        Class conceptClass = method.getAnnotation(ChildConcepts.class).conceptClass();
        this.validateAndAddConcept(concepts, conceptClass, parentConceptName);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAndAddConceptForChildConceptWithCommonBaseInterfaceAnnotation(Map<ConceptName, ConceptSchema> concepts, Class<?> definitionClass, Method method, ConceptName parentConceptName) {
        void $this$mapTo$iv$iv;
        Class baseInterfaceClass = method.getAnnotation(ChildConceptWithCommonBaseInterface.class).baseInterfaceClass();
        this.validateChildConceptReturnTypeMethod(baseInterfaceClass, definitionClass, method);
        KClass[] $this$map$iv = Reflection.getOrCreateKotlinClasses((Class[])method.getAnnotation(ChildConceptWithCommonBaseInterface.class).conceptClasses());
        boolean $i$f$map = false;
        KClass[] kClassArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmClassMappingKt.getJavaClass((KClass)it));
        }
        List conceptClasses = (List)destination$iv$iv;
        this.validateAndAddChildConceptWithCommonBaseClass(concepts, method, parentConceptName, conceptClasses, baseInterfaceClass);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAndAddConceptForChildConceptsWithCommonBaseInterfaceAnnotation(Map<ConceptName, ConceptSchema> concepts, Class<?> definitionClass, Method method, ConceptName parentConceptName) {
        void $this$mapTo$iv$iv;
        this.validateChildConceptReturnTypeMethod(List.class, definitionClass, method);
        Class baseInterfaceClass = method.getAnnotation(ChildConceptsWithCommonBaseInterface.class).baseInterfaceClass();
        KClass[] $this$map$iv = Reflection.getOrCreateKotlinClasses((Class[])method.getAnnotation(ChildConceptsWithCommonBaseInterface.class).conceptClasses());
        boolean $i$f$map = false;
        KClass[] kClassArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmClassMappingKt.getJavaClass((KClass)it));
        }
        List conceptClasses = (List)destination$iv$iv;
        this.validateAndAddChildConceptWithCommonBaseClass(concepts, method, parentConceptName, conceptClasses, baseInterfaceClass);
    }

    private final void validateAndAddChildConceptWithCommonBaseClass(Map<ConceptName, ConceptSchema> concepts, Method method, ConceptName parentConceptName, List<? extends Class<? extends Object>> conceptClasses, Class<? extends Object> baseInterfaceClass) {
        Iterable $this$forEach$iv = conceptClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class conceptClass = (Class)element$iv;
            boolean bl = false;
            if (!INSTANCE.isInheriting(conceptClass, baseInterfaceClass)) {
                throw new MalformedSchemaException("Class " + conceptClass.getName() + " must inherit base class " + baseInterfaceClass.getName() + " in method " + method + '.');
            }
            INSTANCE.validateAndAddConcept(concepts, conceptClass, parentConceptName);
        }
    }

    private final boolean isInheriting(Class<?> subInterface, Class<?> baseInterface) {
        return this.allInterfaces(subInterface).contains(baseInterface);
    }

    private final Set<Class<?>> allInterfaces(Class<?> clazz) {
        Set interfaceCollector = new LinkedHashSet();
        this.collectInterfacesRecursive(interfaceCollector, clazz);
        return interfaceCollector;
    }

    private final void collectInterfacesRecursive(Set<Class<?>> interfaceCollector, Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        Object[] $this$forEach$iv = classArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class iface = (Class)element$iv;
            boolean bl = false;
            if (interfaceCollector.contains(iface)) continue;
            Intrinsics.checkNotNull((Object)iface);
            interfaceCollector.add(iface);
            INSTANCE.collectInterfacesRecursive(interfaceCollector, iface);
        }
    }

    private final void addConceptSchema(Map<ConceptName, ConceptSchema> concepts, ConceptName conceptName, Class<?> conceptClass, ConceptSchema parentConceptSchema) {
        boolean isRootConcept = parentConceptSchema == null;
        ConceptSchema alreadyExistingConcept = concepts.get(conceptName);
        if (alreadyExistingConcept != null) {
            Set newParentConceptNames = parentConceptSchema != null ? SetsKt.plus((Set)alreadyExistingConcept.getParentConceptNames(), (Object)parentConceptSchema.getConceptName()) : alreadyExistingConcept.getParentConceptNames();
            concepts.put(conceptName, new ConceptSchemaImpl(conceptName, conceptClass, isRootConcept || alreadyExistingConcept.isRootConcept(), newParentConceptNames, alreadyExistingConcept.getFacets(), alreadyExistingConcept.getMinOccurrence(), alreadyExistingConcept.getMaxOccurrence()));
        } else {
            List<FacetSchema> facets = this.gatherFacets(conceptClass);
            int minOccurrence = conceptClass.getAnnotation(Concept.class).minOccurrence();
            int maxOccurrence = conceptClass.getAnnotation(Concept.class).maxOccurrence();
            Set newParentConceptNames = parentConceptSchema != null ? SetsKt.setOf((Object)parentConceptSchema.getConceptName()) : SetsKt.emptySet();
            concepts.put(conceptName, new ConceptSchemaImpl(conceptName, conceptClass, isRootConcept, newParentConceptNames, facets, minOccurrence, maxOccurrence));
        }
    }

    private final List<FacetSchema> gatherFacets(Class<?> conceptClass) {
        List facets = new ArrayList();
        Method[] methodArray = conceptClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Class<?> clazz = method.getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
            KClass returnType = JvmClassMappingKt.getKotlinClass(clazz);
            Intrinsics.checkNotNull((Object)method);
            if (INSTANCE.hasMethodAnnotation(Facet.class, method)) {
                Object v2;
                FacetSchemaImpl facet;
                FacetName facetName;
                block5: {
                    FacetTypeEnum facetType;
                    facetName = FacetName.Companion.of(method.getAnnotation(Facet.class).facetName());
                    boolean isMandatory = method.getAnnotation(Facet.class).mandatory();
                    if (FacetTypeEnum.Companion.matchingEnumByTypeClass(returnType) == null) {
                        throw new MalformedSchemaException("Return type '" + returnType + "' of method '" + method + "' does not match any compatible facet types (" + FacetTypeEnum.Companion.supportedTypes() + ").");
                    }
                    ConceptName referencingConcept = FacetTypeEnum.Companion.referencedTypeConceptName(returnType);
                    KClass<?> enumerationType = INSTANCE.validatedEnumerationType(facetName, facetType, method);
                    facet = new FacetSchemaImpl(facetName, facetType, isMandatory, referencingConcept, enumerationType);
                    Iterable $this$firstOrNull$iv = facets;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        FacetSchema it = (FacetSchema)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFacetName(), (Object)facetName)) continue;
                        v2 = element$iv2;
                        break block5;
                    }
                    v2 = null;
                }
                FacetSchema alreadyExistingFacet = v2;
                if (alreadyExistingFacet == null) {
                    facets.add(facet);
                    continue;
                }
                if (Intrinsics.areEqual((Object)alreadyExistingFacet, (Object)facet)) continue;
                throw new MalformedSchemaException("You try to define the facet '" + facetName.getName() + "' multiple times but with different parameters. Facet " + facet + " in method '" + method + "' does not match already existing facet " + alreadyExistingFacet + '.');
            }
            if (!INSTANCE.hasMethodAnnotation(ConceptId.class, method) || Intrinsics.areEqual((Object)returnType, (Object)Reflection.getOrCreateKotlinClass(String.class)) || Intrinsics.areEqual((Object)returnType, (Object)Reflection.getOrCreateKotlinClass(ConceptIdentifier.class))) continue;
            throw new MalformedSchemaException("The return type of a method with " + Reflection.getOrCreateKotlinClass(ConceptId.class).getQualifiedName() + " must be " + Reflection.getOrCreateKotlinClass(String.class).getQualifiedName() + " or " + Reflection.getOrCreateKotlinClass(ConceptIdentifier.class).getQualifiedName() + " in method '" + method + "'.");
        }
        return facets;
    }

    /*
     * WARNING - void declaration
     */
    private final KClass<?> validatedEnumerationType(FacetName facetName, FacetTypeEnum facetType, Method method) {
        void $this$filterNotTo$iv$iv;
        T[] enumConstants;
        if (facetType != FacetTypeEnum.TEXT_ENUMERATION) {
            return null;
        }
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
        KClass enumerationType = JvmClassMappingKt.getKotlinClass(clazz);
        T[] TArray = JvmClassMappingKt.getJavaClass((KClass)enumerationType).getEnumConstants();
        if (TArray == null) {
            throw new MalformedSchemaException("You try to define the facet '" + facetName.getName() + "' as enumeration but the return type of method '" + method + "' is not an enum but '" + enumerationType.getQualifiedName() + "'.");
        }
        T[] $this$filterNot$iv = enumConstants = TArray;
        boolean $i$f$filterNot = false;
        T[] TArray2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
            boolean bl = false;
            if (it instanceof Enum) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumValuesButNotEnum = (List)destination$iv$iv;
        if (!((Collection)enumValuesButNotEnum).isEmpty()) {
            throw new MalformedSchemaException("You try to define the facet '" + facetName.getName() + "' as enumeration but the following enum values [" + CollectionsKt.joinToString$default((Iterable)enumValuesButNotEnum, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "] are not of type " + Reflection.getOrCreateKotlinClass(Enum.class).getQualifiedName() + " for method '" + method + "'.");
        }
        return enumerationType;
    }

    private final void validateTypeAnnotation(Class<? extends Annotation> annotation, Class<?> classToInspect) {
        if (!classToInspect.isInterface()) {
            throw new MalformedSchemaException("Definition class '" + classToInspect.getName() + "' must be an interface.");
        }
        if (!this.hasClassAnnotation(annotation, classToInspect)) {
            throw new MalformedSchemaException("Definition class '" + classToInspect.getName() + "' must have an annotation of type '" + annotation.getName() + '\'');
        }
    }

    private final boolean hasClassAnnotation(Class<? extends Annotation> annotation, Class<?> classToInspect) {
        return classToInspect.getAnnotation(annotation) != null;
    }

    private final boolean hasMethodAnnotation(Class<? extends Annotation> annotation, Method methodToInspect) {
        return methodToInspect.getAnnotation(annotation) != null;
    }
}

