/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.engine.process.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codeblessing.sourceamazing.api.process.schema.ConceptName;
import org.codeblessing.sourceamazing.api.process.schema.ConceptSchema;
import org.codeblessing.sourceamazing.api.process.schema.SchemaAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u001f\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/codeblessing/sourceamazing/engine/process/schema/SchemaImpl;", "Lorg/codeblessing/sourceamazing/api/process/schema/SchemaAccess;", "concepts", "", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptName;", "Lorg/codeblessing/sourceamazing/api/process/schema/ConceptSchema;", "(Ljava/util/Map;)V", "allChildrenConcepts", "", "concept", "allConcepts", "allRootConcepts", "component1", "conceptByConceptName", "conceptName", "copy", "equals", "", "other", "", "hasConceptName", "hashCode", "", "numberOfConcepts", "toString", "", "sourceamazing-engine"})
@SourceDebugExtension(value={"SMAP\nSchemaImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaImpl.kt\norg/codeblessing/sourceamazing/engine/process/schema/SchemaImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n766#2:36\n857#2,2:37\n766#2:39\n857#2,2:40\n*S KotlinDebug\n*F\n+ 1 SchemaImpl.kt\norg/codeblessing/sourceamazing/engine/process/schema/SchemaImpl\n*L\n24#1:36\n24#1:37,2\n28#1:39\n28#1:40,2\n*E\n"})
public final class SchemaImpl
implements SchemaAccess {
    @NotNull
    private final Map<ConceptName, ConceptSchema> concepts;

    public SchemaImpl(@NotNull Map<ConceptName, ? extends ConceptSchema> concepts) {
        Intrinsics.checkNotNullParameter(concepts, (String)"concepts");
        this.concepts = concepts;
    }

    @NotNull
    public ConceptSchema conceptByConceptName(@NotNull ConceptName conceptName) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        ConceptSchema conceptSchema = this.concepts.get(conceptName);
        if (conceptSchema == null) {
            throw new IllegalStateException("Concept with name '" + conceptName + "' not found in schema: " + this.concepts);
        }
        return conceptSchema;
    }

    public boolean hasConceptName(@NotNull ConceptName conceptName) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        return this.concepts.containsKey(conceptName);
    }

    @NotNull
    public Set<ConceptSchema> allConcepts() {
        return CollectionsKt.toSet((Iterable)this.concepts.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ConceptSchema> allRootConcepts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.allConcepts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConceptSchema it = (ConceptSchema)element$iv$iv;
            boolean bl = false;
            if (!it.isRootConcept()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ConceptSchema> allChildrenConcepts(@NotNull ConceptSchema concept) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)concept, (String)"concept");
        Iterable $this$filter$iv = this.allConcepts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConceptSchema it = (ConceptSchema)element$iv$iv;
            boolean bl = false;
            if (!it.getParentConceptNames().contains(concept.getConceptName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final int numberOfConcepts() {
        return this.concepts.size();
    }

    private final Map<ConceptName, ConceptSchema> component1() {
        return this.concepts;
    }

    @NotNull
    public final SchemaImpl copy(@NotNull Map<ConceptName, ? extends ConceptSchema> concepts) {
        Intrinsics.checkNotNullParameter(concepts, (String)"concepts");
        return new SchemaImpl(concepts);
    }

    public static /* synthetic */ SchemaImpl copy$default(SchemaImpl schemaImpl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = schemaImpl.concepts;
        }
        return schemaImpl.copy(map);
    }

    @NotNull
    public String toString() {
        return "SchemaImpl(concepts=" + this.concepts + ')';
    }

    public int hashCode() {
        return ((Object)this.concepts).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaImpl)) {
            return false;
        }
        SchemaImpl schemaImpl = (SchemaImpl)other;
        return Intrinsics.areEqual(this.concepts, schemaImpl.concepts);
    }
}

