/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.schema.ConceptData;
import org.codeblessing.sourceamazing.schema.RevealedSchemaContext;
import org.codeblessing.sourceamazing.schema.SchemaAccess;
import org.codeblessing.sourceamazing.schema.api.SchemaContext;
import org.codeblessing.sourceamazing.schema.api.SchemaProcessorApi;
import org.codeblessing.sourceamazing.schema.conceptgraph.ConceptGraph;
import org.codeblessing.sourceamazing.schema.conceptgraph.ConceptResolver;
import org.codeblessing.sourceamazing.schema.datacollection.ConceptDataCollector;
import org.codeblessing.sourceamazing.schema.filesystem.FileSystemAccess;
import org.codeblessing.sourceamazing.schema.filesystem.PhysicalFilesFileSystemAccess;
import org.codeblessing.sourceamazing.schema.logger.JavaUtilLoggerFacade;
import org.codeblessing.sourceamazing.schema.logger.LoggerFacade;
import org.codeblessing.sourceamazing.schema.proxy.ProxyCreator;
import org.codeblessing.sourceamazing.schema.schemacreator.SchemaCreator;
import org.codeblessing.sourceamazing.schema.schemacreator.query.proxy.SchemaInstanceInvocationHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000fH\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/codeblessing/sourceamazing/schema/SchemaProcessor;", "Lorg/codeblessing/sourceamazing/schema/api/SchemaProcessorApi;", "fileSystemAccess", "Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;", "(Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;)V", "()V", "loggerFacade", "Lorg/codeblessing/sourceamazing/schema/logger/LoggerFacade;", "(Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;Lorg/codeblessing/sourceamazing/schema/logger/LoggerFacade;)V", "withSchema", "S", "", "schemaDefinitionClass", "Lkotlin/reflect/KClass;", "schemaUsage", "Lkotlin/Function1;", "Lorg/codeblessing/sourceamazing/schema/api/SchemaContext;", "Lkotlin/ParameterName;", "name", "schemaContext", "", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sourceamazing-schema"})
public final class SchemaProcessor
implements SchemaProcessorApi {
    @NotNull
    private final FileSystemAccess fileSystemAccess;
    @NotNull
    private final LoggerFacade loggerFacade;

    public SchemaProcessor(@NotNull FileSystemAccess fileSystemAccess, @NotNull LoggerFacade loggerFacade) {
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        Intrinsics.checkNotNullParameter((Object)loggerFacade, (String)"loggerFacade");
        this.fileSystemAccess = fileSystemAccess;
        this.loggerFacade = loggerFacade;
    }

    public SchemaProcessor(@NotNull FileSystemAccess fileSystemAccess) {
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        this(fileSystemAccess, new JavaUtilLoggerFacade(fileSystemAccess));
    }

    public SchemaProcessor() {
        this(new PhysicalFilesFileSystemAccess());
    }

    @NotNull
    public <S> S withSchema(@NotNull KClass<S> schemaDefinitionClass, @NotNull Function1<? super SchemaContext, Unit> schemaUsage) {
        Intrinsics.checkNotNullParameter(schemaDefinitionClass, (String)"schemaDefinitionClass");
        Intrinsics.checkNotNullParameter(schemaUsage, (String)"schemaUsage");
        SchemaAccess schema = SchemaCreator.INSTANCE.createSchemaFromSchemaDefinitionClass(schemaDefinitionClass);
        ConceptDataCollector conceptDataCollector = new ConceptDataCollector();
        RevealedSchemaContext revealedSchemaContext = new RevealedSchemaContext(schema, conceptDataCollector, this.fileSystemAccess, this.loggerFacade);
        schemaUsage.invoke((Object)revealedSchemaContext);
        List<ConceptData> conceptData = conceptDataCollector.provideConceptData();
        ConceptGraph conceptGraph = ConceptResolver.INSTANCE.validateAndResolveConcepts(schema, conceptData);
        S schemaInstance = ProxyCreator.INSTANCE.createProxy(schemaDefinitionClass, new SchemaInstanceInvocationHandler(conceptGraph));
        return schemaInstance;
    }
}

