/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.conceptgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.schema.ConceptData;
import org.codeblessing.sourceamazing.schema.ConceptSchema;
import org.codeblessing.sourceamazing.schema.FacetName;
import org.codeblessing.sourceamazing.schema.FacetSchema;
import org.codeblessing.sourceamazing.schema.FacetType;
import org.codeblessing.sourceamazing.schema.SchemaAccess;
import org.codeblessing.sourceamazing.schema.api.ConceptIdentifier;
import org.codeblessing.sourceamazing.schema.conceptgraph.ConceptGraph;
import org.codeblessing.sourceamazing.schema.conceptgraph.MutableConceptNode;
import org.codeblessing.sourceamazing.schema.datacollection.validation.ConceptDataValidator;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.SchemaValidationException;
import org.codeblessing.sourceamazing.schema.util.EnumUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004H\u0002J\u001c\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0017H\u0002J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0017H\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\u00a8\u0006\u001d"}, d2={"Lorg/codeblessing/sourceamazing/schema/conceptgraph/ConceptResolver;", "", "()V", "createConceptNodeMap", "", "Lorg/codeblessing/sourceamazing/schema/api/ConceptIdentifier;", "Lorg/codeblessing/sourceamazing/schema/conceptgraph/MutableConceptNode;", "schema", "Lorg/codeblessing/sourceamazing/schema/SchemaAccess;", "conceptDataEntries", "Lorg/codeblessing/sourceamazing/schema/ConceptData;", "fromStringToEnum", "enumStringValue", "", "enumerationType", "Lkotlin/reflect/KClass;", "transformEnumFacetValues", "", "facetSchema", "Lorg/codeblessing/sourceamazing/schema/FacetSchema;", "conceptData", "transformFacetValues", "conceptNodeMap", "", "transformReferenceFacetValues", "facetName", "Lorg/codeblessing/sourceamazing/schema/FacetName;", "validateAndResolveConcepts", "Lorg/codeblessing/sourceamazing/schema/conceptgraph/ConceptGraph;", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nConceptResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptResolver.kt\norg/codeblessing/sourceamazing/schema/conceptgraph/ConceptResolver\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n215#2,2:90\n215#2:92\n216#2:95\n1855#3,2:93\n1549#3:96\n1620#3,3:97\n1549#3:100\n1620#3,3:101\n*S KotlinDebug\n*F\n+ 1 ConceptResolver.kt\norg/codeblessing/sourceamazing/schema/conceptgraph/ConceptResolver\n*L\n30#1:90,2\n36#1:92\n36#1:95\n40#1:93,2\n68#1:96\n68#1:97,3\n83#1:100\n83#1:101,3\n*E\n"})
public final class ConceptResolver {
    @NotNull
    public static final ConceptResolver INSTANCE = new ConceptResolver();

    private ConceptResolver() {
    }

    @NotNull
    public final ConceptGraph validateAndResolveConcepts(@NotNull SchemaAccess schema, @NotNull List<? extends ConceptData> conceptDataEntries) throws SchemaValidationException {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(conceptDataEntries, (String)"conceptDataEntries");
        Map<ConceptIdentifier, ConceptData> validatedDataEntries = ConceptDataValidator.INSTANCE.validateEntries(schema, conceptDataEntries);
        Map<ConceptIdentifier, MutableConceptNode> conceptNodeMap = this.createConceptNodeMap(schema, validatedDataEntries);
        return new ConceptGraph(conceptNodeMap);
    }

    private final Map<ConceptIdentifier, MutableConceptNode> createConceptNodeMap(SchemaAccess schema, Map<ConceptIdentifier, ? extends ConceptData> conceptDataEntries) {
        ConceptIdentifier conceptIdentifier;
        Map.Entry<ConceptIdentifier, ? extends ConceptData> entry;
        Map.Entry<Object, ConceptData> element$iv;
        Map conceptNodeMap = new LinkedHashMap();
        Map $this$forEach$iv = conceptDataEntries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, ConceptData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            conceptIdentifier = entry.getKey();
            ConceptData conceptData = entry.getValue();
            conceptNodeMap.put(conceptIdentifier, new MutableConceptNode(conceptData.getSequenceNumber(), conceptData.getConceptName(), conceptData.getConceptIdentifier(), null, 8, null));
        }
        $this$forEach$iv = conceptNodeMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            conceptIdentifier = entry.getKey();
            MutableConceptNode conceptNode = (MutableConceptNode)((Object)entry.getValue());
            if ((ConceptData)conceptDataEntries.get(conceptIdentifier) == null) {
                throw new IllegalStateException("Could not resolve " + conceptIdentifier + ". ");
            }
            ConceptSchema conceptSchema = schema.conceptByConceptName(conceptNode.getConceptName());
            Iterable $this$forEach$iv2 = conceptSchema.getFacets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConceptData conceptData;
                FacetSchema facetSchema = (FacetSchema)element$iv2;
                boolean bl2 = false;
                conceptNode.getFacetValues().put(facetSchema.getFacetName(), INSTANCE.transformFacetValues(facetSchema, conceptData, conceptNodeMap));
            }
        }
        return conceptNodeMap;
    }

    private final List<Object> transformFacetValues(FacetSchema facetSchema, ConceptData conceptData, Map<ConceptIdentifier, MutableConceptNode> conceptNodeMap) {
        List<Object> list;
        FacetName facetName = facetSchema.getFacetName();
        switch (WhenMappings.$EnumSwitchMapping$0[facetSchema.getFacetType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                list = conceptData.getFacet(facetName);
                break;
            }
            case 4: {
                list = this.transformEnumFacetValues(facetSchema, conceptData);
                break;
            }
            case 5: {
                list = this.transformReferenceFacetValues(facetName, conceptData, conceptNodeMap);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> transformEnumFacetValues(FacetSchema facetSchema, ConceptData conceptData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KClass<?> kClass = facetSchema.getEnumerationType();
        if (kClass == null) {
            throw new IllegalStateException("Facet " + facetSchema.getFacetName() + " has no enumerationType.");
        }
        KClass<?> enumerationType = kClass;
        Iterable iterable = conceptData.getFacet(facetSchema.getFacetName());
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void value;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(value instanceof String ? INSTANCE.fromStringToEnum((String)value, enumerationType) : value);
        }
        return (List)destination$iv$iv;
    }

    private final Object fromStringToEnum(String enumStringValue, KClass<?> enumerationType) {
        Object object = EnumUtil.INSTANCE.fromStringToEnum(enumStringValue, enumerationType);
        if (object == null) {
            throw new IllegalStateException("Could not convert enum value '" + enumStringValue + "' to enum constants of " + enumerationType);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> transformReferenceFacetValues(FacetName facetName, ConceptData conceptData, Map<ConceptIdentifier, MutableConceptNode> conceptNodeMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.filterIsInstance((Iterable)conceptData.getFacet(facetName), ConceptIdentifier.class);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void referencingConceptIdentifier;
            ConceptIdentifier conceptIdentifier = (ConceptIdentifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MutableConceptNode mutableConceptNode = conceptNodeMap.get(referencingConceptIdentifier);
            if (mutableConceptNode == null) {
                throw new IllegalStateException("Could not resolve reference to " + referencingConceptIdentifier + " from $" + conceptData.getConceptIdentifier() + ". ");
            }
            collection.add(mutableConceptNode);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FacetType.values().length];
            try {
                nArray[FacetType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.BOOLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.TEXT_ENUMERATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

