/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codeblessing.sourceamazing.schema.ConceptData;
import org.codeblessing.sourceamazing.schema.ConceptName;
import org.codeblessing.sourceamazing.schema.FacetName;
import org.codeblessing.sourceamazing.schema.api.ConceptIdentifier;
import org.codeblessing.sourceamazing.schema.datacollection.ConceptDataImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u001e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016J\u001a\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00190\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010(\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/codeblessing/sourceamazing/schema/datacollection/ConceptDataImpl;", "Lorg/codeblessing/sourceamazing/schema/ConceptData;", "sequenceNumber", "", "conceptName", "Lorg/codeblessing/sourceamazing/schema/ConceptName;", "conceptIdentifier", "Lorg/codeblessing/sourceamazing/schema/api/ConceptIdentifier;", "(ILorg/codeblessing/sourceamazing/schema/ConceptName;Lorg/codeblessing/sourceamazing/schema/api/ConceptIdentifier;)V", "getConceptIdentifier", "()Lorg/codeblessing/sourceamazing/schema/api/ConceptIdentifier;", "getConceptName", "()Lorg/codeblessing/sourceamazing/schema/ConceptName;", "mutableFacets", "", "Lorg/codeblessing/sourceamazing/schema/FacetName;", "", "", "getSequenceNumber", "()I", "addFacetValue", "facetName", "facetValue", "addFacetValues", "facetValues", "", "allFacets", "", "assureFacetList", "createEmptyListForFacet", "describe", "", "describeFacet", "key", "value", "getFacet", "getFacetNames", "", "hasFacet", "", "replaceFacetValues", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nConceptDataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptDataImpl.kt\norg/codeblessing/sourceamazing/schema/datacollection/ConceptDataImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n125#2:72\n152#2,3:73\n*S KotlinDebug\n*F\n+ 1 ConceptDataImpl.kt\norg/codeblessing/sourceamazing/schema/datacollection/ConceptDataImpl\n*L\n50#1:72\n50#1:73,3\n*E\n"})
public final class ConceptDataImpl
implements ConceptData {
    private final int sequenceNumber;
    @NotNull
    private final ConceptName conceptName;
    @NotNull
    private final ConceptIdentifier conceptIdentifier;
    @NotNull
    private final Map<FacetName, List<Object>> mutableFacets;

    public ConceptDataImpl(int sequenceNumber, @NotNull ConceptName conceptName, @NotNull ConceptIdentifier conceptIdentifier) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        Intrinsics.checkNotNullParameter((Object)conceptIdentifier, (String)"conceptIdentifier");
        this.sequenceNumber = sequenceNumber;
        this.conceptName = conceptName;
        this.conceptIdentifier = conceptIdentifier;
        this.mutableFacets = new LinkedHashMap();
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    @NotNull
    public ConceptName getConceptName() {
        return this.conceptName;
    }

    @Override
    @NotNull
    public ConceptIdentifier getConceptIdentifier() {
        return this.conceptIdentifier;
    }

    @Override
    public boolean hasFacet(@NotNull FacetName facetName) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        return this.mutableFacets.containsKey(facetName);
    }

    @Override
    @NotNull
    public List<Object> getFacet(@NotNull FacetName facetName) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        List list = this.mutableFacets.get(facetName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Set<FacetName> getFacetNames() {
        return this.mutableFacets.keySet();
    }

    @Override
    @NotNull
    public Map<FacetName, List<Object>> allFacets() {
        return MapsKt.toMap(this.mutableFacets);
    }

    @Override
    @NotNull
    public ConceptDataImpl replaceFacetValues(@NotNull FacetName facetName, @NotNull List<? extends Object> facetValues) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter(facetValues, (String)"facetValues");
        this.mutableFacets.put(facetName, CollectionsKt.toMutableList((Collection)facetValues));
        return this;
    }

    @Override
    @NotNull
    public ConceptDataImpl addFacetValue(@NotNull FacetName facetName, @NotNull Object facetValue) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter((Object)facetValue, (String)"facetValue");
        this.assureFacetList(facetName).add(facetValue);
        return this;
    }

    @Override
    @NotNull
    public ConceptData addFacetValues(@NotNull FacetName facetName, @NotNull List<? extends Object> facetValues) {
        Intrinsics.checkNotNullParameter((Object)facetName, (String)"facetName");
        Intrinsics.checkNotNullParameter(facetValues, (String)"facetValues");
        this.assureFacetList(facetName).addAll((Collection<Object>)facetValues);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String describe() {
        void $this$mapTo$iv$iv;
        Map<FacetName, List<Object>> $this$map$iv = this.mutableFacets;
        boolean $i$f$map = false;
        Map<FacetName, List<Object>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FacetName key = (FacetName)entry.getKey();
            List value = (List)entry.getValue();
            collection.add(this.describeFacet(key, value));
        }
        String facetDescription = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return this.getConceptName().simpleName() + ':' + this.getConceptIdentifier().getName() + " {\n" + facetDescription + "\n}";
    }

    private final String describeFacet(FacetName key, List<Object> value) {
        return "  " + key.simpleName() + ":[ " + CollectionsKt.joinToString$default((Iterable)value, (CharSequence)", ", null, null, (int)0, null, (Function1)describeFacet.1.INSTANCE, (int)30, null) + " ]";
    }

    private final List<Object> assureFacetList(FacetName facetName) {
        List<Object> currentList = this.mutableFacets.get(facetName);
        List<Object> list = currentList;
        if (list == null) {
            list = this.createEmptyListForFacet(facetName);
        }
        return list;
    }

    private final List<Object> createEmptyListForFacet(FacetName facetName) {
        List list = new ArrayList();
        this.mutableFacets.put(facetName, list);
        return list;
    }
}

