/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.datacollection.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.schema.ConceptData;
import org.codeblessing.sourceamazing.schema.ConceptName;
import org.codeblessing.sourceamazing.schema.ConceptSchema;
import org.codeblessing.sourceamazing.schema.FacetName;
import org.codeblessing.sourceamazing.schema.FacetSchema;
import org.codeblessing.sourceamazing.schema.FacetType;
import org.codeblessing.sourceamazing.schema.SchemaAccess;
import org.codeblessing.sourceamazing.schema.api.ConceptIdentifier;
import org.codeblessing.sourceamazing.schema.datacollection.MultipleSchemaValidationException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.DuplicateConceptIdentifierException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.MissingReferencedConceptFacetValueException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.SchemaValidationException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.UnknownConceptException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.UnknownFacetNameException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.WrongCardinalityForFacetValueException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.WrongReferencedConceptFacetValueException;
import org.codeblessing.sourceamazing.schema.datacollection.validation.exceptions.WrongTypeForFacetValueException;
import org.codeblessing.sourceamazing.schema.documentation.TypesAsTextFunctions;
import org.codeblessing.sourceamazing.schema.util.EnumUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002J \u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J2\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J \u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010)\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00142\u0006\u0010*\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010*\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00142\u0006\u0010*\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002\u00a8\u0006."}, d2={"Lorg/codeblessing/sourceamazing/schema/datacollection/validation/ConceptDataValidator;", "", "()V", "facetEnumType", "Lkotlin/reflect/KClass;", "facetSchema", "Lorg/codeblessing/sourceamazing/schema/FacetSchema;", "isValidEnumValue", "", "enumFacetValue", "validateConceptName", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/UnknownConceptException;", "schema", "Lorg/codeblessing/sourceamazing/schema/SchemaAccess;", "conceptDataEntry", "Lorg/codeblessing/sourceamazing/schema/ConceptData;", "validateConceptNameAndIdentifier", "", "Lorg/codeblessing/sourceamazing/schema/api/ConceptIdentifier;", "conceptDataEntries", "", "listOfValidationFailures", "", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/SchemaValidationException;", "validateDataType", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/WrongTypeForFacetValueException;", "expectedFacetType", "Lorg/codeblessing/sourceamazing/schema/FacetType;", "facetValue", "validateDuplicateConceptIdentifiers", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/DuplicateConceptIdentifierException;", "allConceptIdentifiers", "", "validateEntries", "validateFacets", "", "conceptDataMap", "validateForFacetCardinality", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/WrongCardinalityForFacetValueException;", "schemaConcept", "Lorg/codeblessing/sourceamazing/schema/ConceptSchema;", "validateForFacetType", "conceptSchema", "validateForObsoletFacets", "Lorg/codeblessing/sourceamazing/schema/datacollection/validation/exceptions/UnknownFacetNameException;", "validateForReferenceFacet", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nConceptDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptDataValidator.kt\norg/codeblessing/sourceamazing/schema/datacollection/validation/ConceptDataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1855#2:291\n1856#2:293\n1855#2,2:294\n766#2:296\n857#2,2:297\n1855#2:299\n1855#2,2:300\n1856#2:302\n1855#2,2:303\n1855#2:305\n1855#2,2:306\n1856#2:308\n1855#2,2:309\n1#3:292\n*S KotlinDebug\n*F\n+ 1 ConceptDataValidator.kt\norg/codeblessing/sourceamazing/schema/datacollection/validation/ConceptDataValidator\n*L\n46#1:291\n46#1:293\n70#1:294,2\n100#1:296\n100#1:297,2\n101#1:299\n104#1:300,2\n101#1:302\n168#1:303,2\n187#1:305\n191#1:306,2\n187#1:308\n258#1:309,2\n*E\n"})
public final class ConceptDataValidator {
    @NotNull
    public static final ConceptDataValidator INSTANCE = new ConceptDataValidator();

    private ConceptDataValidator() {
    }

    @NotNull
    public final Map<ConceptIdentifier, ConceptData> validateEntries(@NotNull SchemaAccess schema, @NotNull List<? extends ConceptData> conceptDataEntries) throws MultipleSchemaValidationException, SchemaValidationException {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(conceptDataEntries, (String)"conceptDataEntries");
        Set listOfValidationFailures = new LinkedHashSet();
        Map<ConceptIdentifier, ConceptData> validConceptIdentifierWithConceptName = this.validateConceptNameAndIdentifier(schema, conceptDataEntries, listOfValidationFailures);
        this.validateFacets(schema, validConceptIdentifierWithConceptName, listOfValidationFailures);
        if (listOfValidationFailures.isEmpty()) {
            return validConceptIdentifierWithConceptName;
        }
        if (listOfValidationFailures.size() == 1) {
            throw (Throwable)CollectionsKt.single((Iterable)listOfValidationFailures);
        }
        throw new MultipleSchemaValidationException(listOfValidationFailures);
    }

    private final Map<ConceptIdentifier, ConceptData> validateConceptNameAndIdentifier(SchemaAccess schema, List<? extends ConceptData> conceptDataEntries, Set<SchemaValidationException> listOfValidationFailures) {
        Map validConceptIdentifierWithConceptName = new LinkedHashMap();
        Set allConceptIdentifiers = new LinkedHashSet();
        Iterable $this$forEach$iv = conceptDataEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean it;
            ConceptData conceptDataEntry = (ConceptData)element$iv;
            boolean bl = false;
            boolean isValidConcept = false;
            isValidConcept = true;
            SchemaValidationException schemaValidationException = INSTANCE.validateConceptName(schema, conceptDataEntry);
            if (schemaValidationException != null) {
                SchemaValidationException p0 = schemaValidationException;
                boolean bl2 = false;
                it = listOfValidationFailures.add(p0);
                boolean bl3 = false;
                isValidConcept = false;
            }
            schemaValidationException = INSTANCE.validateDuplicateConceptIdentifiers(allConceptIdentifiers, conceptDataEntry);
            if (schemaValidationException != null) {
                SchemaValidationException p0 = schemaValidationException;
                boolean bl4 = false;
                it = listOfValidationFailures.add(p0);
                boolean bl5 = false;
                isValidConcept = false;
            }
            allConceptIdentifiers.add(conceptDataEntry.getConceptIdentifier());
            if (!isValidConcept) continue;
            validConceptIdentifierWithConceptName.put(conceptDataEntry.getConceptIdentifier(), conceptDataEntry);
        }
        return validConceptIdentifierWithConceptName;
    }

    private final void validateFacets(SchemaAccess schema, Map<ConceptIdentifier, ? extends ConceptData> conceptDataMap, Set<SchemaValidationException> listOfValidationFailures) {
        Iterable $this$forEach$iv = conceptDataMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection p0;
            boolean it;
            ConceptData conceptDataEntry = (ConceptData)element$iv;
            boolean bl = false;
            ConceptSchema conceptSchema = schema.conceptByConceptName(conceptDataEntry.getConceptName());
            boolean skipDeeperValidation = false;
            List<WrongCardinalityForFacetValueException> list = INSTANCE.validateForObsoletFacets(conceptSchema, conceptDataEntry);
            if (list != null) {
                SchemaValidationException p02 = (SchemaValidationException)((Object)list);
                boolean bl2 = false;
                it = listOfValidationFailures.add(p02);
                boolean bl3 = false;
                skipDeeperValidation = true;
            }
            list = INSTANCE.validateForFacetType(conceptSchema, conceptDataEntry);
            if (list != null) {
                Collection p03 = list;
                boolean bl4 = false;
                it = listOfValidationFailures.addAll(p03);
                boolean bl5 = false;
                skipDeeperValidation = true;
            }
            if (skipDeeperValidation) continue;
            list = INSTANCE.validateForFacetCardinality(conceptSchema, conceptDataEntry);
            if (list != null) {
                p0 = list;
                boolean bl6 = false;
                listOfValidationFailures.addAll(p0);
            }
            if ((list = INSTANCE.validateForReferenceFacet(conceptSchema, conceptDataEntry, conceptDataMap)) == null) continue;
            p0 = list;
            boolean bl7 = false;
            listOfValidationFailures.addAll(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchemaValidationException> validateForReferenceFacet(ConceptSchema conceptSchema, ConceptData conceptDataEntry, Map<ConceptIdentifier, ? extends ConceptData> conceptDataMap) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List exceptionList = new ArrayList();
        Iterable iterable = conceptSchema.getFacets();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FacetSchema it = (FacetSchema)element$iv$iv;
            boolean bl = false;
            if (!(it.getFacetType() == FacetType.REFERENCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetSchema referenceFacetSchema = (FacetSchema)element$iv;
            boolean bl = false;
            List<Object> facetValues = conceptDataEntry.getFacet(referenceFacetSchema.getFacetName());
            Set<ConceptName> possibleConcepts = referenceFacetSchema.getReferencingConcepts();
            Iterable $this$forEach$iv2 = facetValues;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv2;
                Object facetValue = element$iv2 = iterator2.next();
                boolean bl2 = false;
                Intrinsics.checkNotNull(facetValue, (String)"null cannot be cast to non-null type org.codeblessing.sourceamazing.schema.api.ConceptIdentifier");
                ConceptIdentifier referenceConceptIdentifier = (ConceptIdentifier)facetValue;
                ConceptData referencedConcept = conceptDataMap.get(referenceConceptIdentifier);
                if (referencedConcept == null) {
                    exceptionList.add(new MissingReferencedConceptFacetValueException("Facet '" + referenceFacetSchema.getFacetName() + "' of concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "' points to a reference that was not found. No concept with concept id " + referenceConceptIdentifier + ". Must be one of these concepts: " + possibleConcepts + ". \n" + conceptDataEntry.describe()));
                    continue;
                }
                if (possibleConcepts.contains(referencedConcept.getConceptName())) continue;
                exceptionList.add(new WrongReferencedConceptFacetValueException("Facet '" + referenceFacetSchema.getFacetName() + "' of concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "' points to concept that is not permitted. Referenced concept was '" + referencedConcept.getConceptName() + "'. Must be one of these concepts: " + possibleConcepts + ". \n" + conceptDataEntry.describe()));
            }
        }
        return exceptionList.isEmpty() ? null : exceptionList;
    }

    private final UnknownConceptException validateConceptName(SchemaAccess schema, ConceptData conceptDataEntry) {
        if (!schema.hasConceptName(conceptDataEntry.getConceptName())) {
            return new UnknownConceptException("The entry with the identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' points to a concept '" + conceptDataEntry.getConceptName() + "' that is not known. \n" + conceptDataEntry.describe());
        }
        return null;
    }

    private final DuplicateConceptIdentifierException validateDuplicateConceptIdentifiers(Set<ConceptIdentifier> allConceptIdentifiers, ConceptData conceptDataEntry) {
        if (allConceptIdentifiers.contains(conceptDataEntry.getConceptIdentifier())) {
            return new DuplicateConceptIdentifierException("The identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' (concept: '" + conceptDataEntry.getConceptName() + "') occurred multiple times. A concept identifier must be unique. \n" + conceptDataEntry.describe());
        }
        return null;
    }

    private final UnknownFacetNameException validateForObsoletFacets(ConceptSchema conceptSchema, ConceptData conceptDataEntry) {
        Iterable $this$forEach$iv = conceptDataEntry.getFacetNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetName facetName = (FacetName)element$iv;
            boolean bl = false;
            if (conceptSchema.hasFacet(facetName)) continue;
            return new UnknownFacetNameException("Unknown facet name '" + facetName + "' found for concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "'. Known facets are: " + conceptSchema.getFacetNames() + ". \n" + conceptDataEntry.describe());
        }
        return null;
    }

    private final List<WrongTypeForFacetValueException> validateForFacetType(ConceptSchema conceptSchema, ConceptData conceptDataEntry) {
        List exceptionList = new ArrayList();
        Iterable $this$forEach$iv = conceptSchema.getFacets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetSchema facetSchema = (FacetSchema)element$iv;
            boolean bl = false;
            if (!conceptDataEntry.hasFacet(facetSchema.getFacetName())) continue;
            List<Object> facetValues = conceptDataEntry.getFacet(facetSchema.getFacetName());
            FacetType expectedFacetType = facetSchema.getFacetType();
            Iterable $this$forEach$iv2 = facetValues;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv2;
                Object facetValue = element$iv2 = iterator.next();
                boolean bl2 = false;
                exceptionList.addAll((Collection)INSTANCE.validateDataType(conceptDataEntry, facetSchema, expectedFacetType, facetValue));
            }
        }
        return exceptionList.isEmpty() ? null : exceptionList;
    }

    private final List<WrongTypeForFacetValueException> validateDataType(ConceptData conceptDataEntry, FacetSchema facetSchema, FacetType expectedFacetType, Object facetValue) {
        boolean bl;
        List exceptionList = new ArrayList();
        KClass actualClass = Reflection.getOrCreateKotlinClass(facetValue.getClass());
        switch (WhenMappings.$EnumSwitchMapping$0[expectedFacetType.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)actualClass, (Object)Reflection.getOrCreateKotlinClass(String.class));
                break;
            }
            case 2: {
                bl = Intrinsics.areEqual((Object)actualClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE));
                break;
            }
            case 3: {
                bl = Intrinsics.areEqual((Object)actualClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE));
                break;
            }
            case 4: {
                bl = Intrinsics.areEqual((Object)actualClass, (Object)Reflection.getOrCreateKotlinClass(ConceptIdentifier.class));
                break;
            }
            case 5: {
                bl = this.isValidEnumValue(facetValue, facetSchema);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean isValidType = bl;
        if (!isValidType) {
            String msg = expectedFacetType == FacetType.TEXT_ENUMERATION && facetValue instanceof String ? "The facet value must be one of " + EnumUtil.INSTANCE.enumConstantStringList(this.facetEnumType(facetSchema)) + " but was '" + facetValue + "' (" + TypesAsTextFunctions.INSTANCE.longText(actualClass) + ")." : "A facet of type '" + (Object)((Object)expectedFacetType) + "' can not have a value of type '" + TypesAsTextFunctions.INSTANCE.longText(actualClass) + "' (" + facetValue + ").";
            exceptionList.add(new WrongTypeForFacetValueException("Facet '" + facetSchema.getFacetName() + "' for concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "' has a wrong type. " + msg + " \n" + conceptDataEntry.describe()));
        }
        return exceptionList;
    }

    private final KClass<?> facetEnumType(FacetSchema facetSchema) {
        KClass<?> kClass = facetSchema.getEnumerationType();
        if (kClass == null) {
            throw new IllegalStateException("EnumerationType was empty for facet schema " + facetSchema);
        }
        return kClass;
    }

    private final boolean isValidEnumValue(Object enumFacetValue, FacetSchema facetSchema) {
        KClass<?> enumerationType = this.facetEnumType(facetSchema);
        return enumFacetValue instanceof String ? EnumUtil.INSTANCE.fromStringToEnum((String)enumFacetValue, enumerationType) != null : EnumUtil.INSTANCE.isEnumerationType(enumFacetValue, enumerationType);
    }

    private final List<WrongCardinalityForFacetValueException> validateForFacetCardinality(ConceptSchema schemaConcept, ConceptData conceptDataEntry) {
        List exceptionList = new ArrayList();
        Iterable $this$forEach$iv = schemaConcept.getFacets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FacetSchema facetSchema = (FacetSchema)element$iv;
            boolean bl = false;
            int minimumOccurrences = facetSchema.getMinimumOccurrences();
            int maximumOccurrences = facetSchema.getMaximumOccurrences();
            int numberOfFacetValues = conceptDataEntry.getFacet(facetSchema.getFacetName()).size();
            if (numberOfFacetValues < minimumOccurrences) {
                exceptionList.add(new WrongCardinalityForFacetValueException("Facet '" + facetSchema.getFacetName() + "' for concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "' has a wrong cardinality. The facet must have in minimum " + minimumOccurrences + " entries but had " + numberOfFacetValues + ". \n" + conceptDataEntry.describe()));
            }
            if (numberOfFacetValues <= maximumOccurrences) continue;
            exceptionList.add(new WrongCardinalityForFacetValueException("Facet '" + facetSchema.getFacetName() + "' for concept identifier '" + conceptDataEntry.getConceptIdentifier().getName() + "' in concept '" + conceptDataEntry.getConceptName() + "' has a wrong cardinality. The facet must not have more than " + maximumOccurrences + " entries but had " + numberOfFacetValues + ". \n" + conceptDataEntry.describe()));
        }
        return exceptionList.isEmpty() ? null : exceptionList;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FacetType.values().length];
            try {
                nArray[FacetType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.BOOLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacetType.TEXT_ENUMERATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

