/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.filesystem;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/codeblessing/sourceamazing/schema/filesystem/FileUtil;", "", "()V", "checkFileReadable", "", "file", "Ljava/nio/file/Path;", "sourceamazing-schema"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public final void checkFileReadable(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalArgumentException("File " + file + " with full path " + ((Object)file.toAbsolutePath()).toString() + " does not exists.");
        }
        if (!Files.isReadable(file)) {
            throw new IllegalArgumentException("File " + file + " with full path " + ((Object)file.toAbsolutePath()).toString() + " exists but is not readable.");
        }
    }
}

