/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ByteIterator;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codeblessing.sourceamazing.schema.filesystem.FileSystemAccess;
import org.codeblessing.sourceamazing.schema.filesystem.FileUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/codeblessing/sourceamazing/schema/filesystem/PhysicalFilesFileSystemAccess;", "Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;", "()V", "byteIteratorAsString", "", "byteIterator", "Lkotlin/collections/ByteIterator;", "classpathResourceAsInputStream", "Ljava/io/InputStream;", "classpathResource", "close", "", "createDirectory", "directoryPath", "Ljava/nio/file/Path;", "fileAsInputStream", "filePath", "getFileWriter", "Ljava/io/Writer;", "writeFile", "fileContent", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nPhysicalFilesFileSystemAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalFilesFileSystemAccess.kt\norg/codeblessing/sourceamazing/schema/filesystem/PhysicalFilesFileSystemAccess\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,48:1\n32#2,2:49\n*S KotlinDebug\n*F\n+ 1 PhysicalFilesFileSystemAccess.kt\norg/codeblessing/sourceamazing/schema/filesystem/PhysicalFilesFileSystemAccess\n*L\n43#1:49,2\n*E\n"})
public final class PhysicalFilesFileSystemAccess
implements FileSystemAccess {
    @Override
    @NotNull
    public InputStream classpathResourceAsInputStream(@NotNull String classpathResource) {
        Intrinsics.checkNotNullParameter((Object)classpathResource, (String)"classpathResource");
        InputStream inputStream = this.getClass().getResourceAsStream(classpathResource);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource with name '" + classpathResource + "' not found.");
        }
        return inputStream;
    }

    @Override
    @NotNull
    public InputStream fileAsInputStream(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileUtil.INSTANCE.checkFileReadable(filePath);
        File file = filePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = file;
        return new FileInputStream(file2);
    }

    @Override
    public void createDirectory(@NotNull Path directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        directoryPath.toFile().mkdirs();
    }

    @Override
    public void writeFile(@NotNull Path filePath, @NotNull String fileContent) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Path path = filePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        this.createDirectory(path);
        File file = filePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.writeText$default((File)file, (String)fileContent, null, (int)2, null);
    }

    @Override
    public void writeFile(@NotNull Path filePath, @NotNull ByteIterator fileContent) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        this.writeFile(filePath, this.byteIteratorAsString(fileContent));
    }

    @Override
    @NotNull
    public Writer getFileWriter(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new FileWriter(filePath.toFile());
    }

    @Override
    public void close() {
    }

    private final String byteIteratorAsString(ByteIterator byteIterator) {
        List byteList = new ArrayList();
        Iterator $this$forEach$iv = (Iterator)byteIterator;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            byte by = ((Number)element$iv).byteValue();
            boolean bl = false;
            byteList.add(by);
        }
        byte[] byArray = CollectionsKt.toByteArray((Collection)byteList);
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }
}

