/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.logger;

import java.io.Closeable;
import java.io.InputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.codeblessing.sourceamazing.schema.filesystem.FileSystemAccess;
import org.codeblessing.sourceamazing.schema.logger.LoggerFacade;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/codeblessing/sourceamazing/schema/logger/JavaUtilLoggerFacade;", "Lorg/codeblessing/sourceamazing/schema/logger/LoggerFacade;", "fileSystemAccess", "Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;", "(Lorg/codeblessing/sourceamazing/schema/filesystem/FileSystemAccess;)V", "logger", "Ljava/util/logging/Logger;", "closeLoggerFacade", "", "logDebug", "msgProvider", "Lkotlin/Function0;", "", "msg", "logUserInfo", "logWarnings", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nJavaUtilLoggerFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaUtilLoggerFacade.kt\norg/codeblessing/sourceamazing/schema/logger/JavaUtilLoggerFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 JavaUtilLoggerFacade.kt\norg/codeblessing/sourceamazing/schema/logger/JavaUtilLoggerFacade\n*L\n33#1:65,2\n*E\n"})
public final class JavaUtilLoggerFacade
implements LoggerFacade {
    @NotNull
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaUtilLoggerFacade(@NotNull FileSystemAccess fileSystemAccess) {
        InputStream it2;
        Intrinsics.checkNotNullParameter((Object)fileSystemAccess, (String)"fileSystemAccess");
        Logger logger = Logger.getLogger("sourceamazing");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        Closeable closeable = fileSystemAccess.classpathResourceAsInputStream("/sourceamazing-default-logging.properties");
        Throwable throwable = null;
        try {
            it2 = (InputStream)closeable;
            boolean bl = false;
            LogManager.getLogManager().readConfiguration(it2);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        try {
            closeable = fileSystemAccess.classpathResourceAsInputStream("/sourceamazing-logging.properties");
            throwable = null;
            try {
                it2 = (InputStream)closeable;
                boolean bl = false;
                LogManager.getLogManager().readConfiguration(it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
        }
    }

    @Override
    public void closeLoggerFacade() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        Handler[] handlerArray = this.logger.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        spreadBuilder.addSpread((Object)handlerArray);
        Handler[] handlerArray2 = Logger.getGlobal().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray2, (String)"getHandlers(...)");
        spreadBuilder.addSpread((Object)handlerArray2);
        Handler[] handlerArray3 = Logger.getLogger("").getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray3, (String)"getHandlers(...)");
        spreadBuilder.addSpread((Object)handlerArray3);
        Iterable $this$forEach$iv = SetsKt.setOf((Object[])spreadBuilder.toArray((Object[])new Handler[spreadBuilder.size()]));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler loggerHandler = (Handler)element$iv;
            boolean bl = false;
            loggerHandler.flush();
            loggerHandler.close();
        }
    }

    @Override
    public void logDebug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.log(Level.FINE, msg);
    }

    @Override
    public void logDebug(@NotNull Function0<String> msgProvider) {
        Intrinsics.checkNotNullParameter(msgProvider, (String)"msgProvider");
        this.logger.log(Level.FINE, () -> JavaUtilLoggerFacade.logDebug$lambda$3(msgProvider));
    }

    @Override
    public void logUserInfo(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.log(Level.INFO, msg);
    }

    @Override
    public void logUserInfo(@NotNull Function0<String> msgProvider) {
        Intrinsics.checkNotNullParameter(msgProvider, (String)"msgProvider");
        this.logger.log(Level.INFO, () -> JavaUtilLoggerFacade.logUserInfo$lambda$4(msgProvider));
    }

    @Override
    public void logWarnings(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.log(Level.WARNING, msg);
    }

    @Override
    public void logWarnings(@NotNull Function0<String> msgProvider) {
        Intrinsics.checkNotNullParameter(msgProvider, (String)"msgProvider");
        this.logger.log(Level.WARNING, () -> JavaUtilLoggerFacade.logWarnings$lambda$5(msgProvider));
    }

    private static final String logDebug$lambda$3(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }

    private static final String logUserInfo$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }

    private static final String logWarnings$lambda$5(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke();
    }
}

