/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.schemacreator;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.codeblessing.sourceamazing.schema.ConceptName;
import org.codeblessing.sourceamazing.schema.ConceptSchema;
import org.codeblessing.sourceamazing.schema.SchemaAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001f\u0010\f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0013J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/codeblessing/sourceamazing/schema/schemacreator/SchemaImpl;", "Lorg/codeblessing/sourceamazing/schema/SchemaAccess;", "concepts", "", "Lorg/codeblessing/sourceamazing/schema/ConceptName;", "Lorg/codeblessing/sourceamazing/schema/ConceptSchema;", "(Ljava/util/Map;)V", "allConcepts", "", "component1", "conceptByConceptName", "conceptName", "copy", "equals", "", "other", "", "hasConceptName", "hashCode", "", "numberOfConcepts", "toString", "", "sourceamazing-schema"})
public final class SchemaImpl
implements SchemaAccess {
    @NotNull
    private final Map<ConceptName, ConceptSchema> concepts;

    public SchemaImpl(@NotNull Map<ConceptName, ? extends ConceptSchema> concepts) {
        Intrinsics.checkNotNullParameter(concepts, (String)"concepts");
        this.concepts = concepts;
    }

    @Override
    @NotNull
    public ConceptSchema conceptByConceptName(@NotNull ConceptName conceptName) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        ConceptSchema conceptSchema = this.concepts.get(conceptName);
        if (conceptSchema == null) {
            throw new IllegalStateException("Concept with name '" + conceptName + "' not found in schema: " + this.concepts);
        }
        return conceptSchema;
    }

    @Override
    public boolean hasConceptName(@NotNull ConceptName conceptName) {
        Intrinsics.checkNotNullParameter((Object)conceptName, (String)"conceptName");
        return this.concepts.containsKey(conceptName);
    }

    @Override
    @NotNull
    public Set<ConceptSchema> allConcepts() {
        return CollectionsKt.toSet((Iterable)this.concepts.values());
    }

    public final int numberOfConcepts() {
        return this.concepts.size();
    }

    private final Map<ConceptName, ConceptSchema> component1() {
        return this.concepts;
    }

    @NotNull
    public final SchemaImpl copy(@NotNull Map<ConceptName, ? extends ConceptSchema> concepts) {
        Intrinsics.checkNotNullParameter(concepts, (String)"concepts");
        return new SchemaImpl(concepts);
    }

    public static /* synthetic */ SchemaImpl copy$default(SchemaImpl schemaImpl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = schemaImpl.concepts;
        }
        return schemaImpl.copy(map);
    }

    @NotNull
    public String toString() {
        return "SchemaImpl(concepts=" + this.concepts + ')';
    }

    public int hashCode() {
        return ((Object)this.concepts).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaImpl)) {
            return false;
        }
        SchemaImpl schemaImpl = (SchemaImpl)other;
        return Intrinsics.areEqual(this.concepts, schemaImpl.concepts);
    }
}

