/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.schemacreator.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.schema.api.annotations.Concept;
import org.codeblessing.sourceamazing.schema.api.annotations.QueryConceptIdentifierValue;
import org.codeblessing.sourceamazing.schema.api.annotations.QueryConcepts;
import org.codeblessing.sourceamazing.schema.api.annotations.QueryFacetValue;
import org.codeblessing.sourceamazing.schema.documentation.TypesAsTextFunctions;
import org.codeblessing.sourceamazing.schema.schemacreator.exceptions.MalformedSchemaException;
import org.codeblessing.sourceamazing.schema.schemacreator.exceptions.WrongFacetQueryMalformedSchemaException;
import org.codeblessing.sourceamazing.schema.util.AnnotationUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lorg/codeblessing/sourceamazing/schema/schemacreator/query/ConceptQueryValidator;", "", "()V", "validateAccessorMethodsOfConceptClass", "", "conceptClass", "Lkotlin/reflect/KClass;", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nConceptQueryValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConceptQueryValidator.kt\norg/codeblessing/sourceamazing/schema/schemacreator/query/ConceptQueryValidator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n13309#2:42\n13310#2:47\n1549#3:43\n1620#3,3:44\n*S KotlinDebug\n*F\n+ 1 ConceptQueryValidator.kt\norg/codeblessing/sourceamazing/schema/schemacreator/query/ConceptQueryValidator\n*L\n18#1:42\n18#1:47\n31#1:43\n31#1:44,3\n*E\n"})
public final class ConceptQueryValidator {
    @NotNull
    public static final ConceptQueryValidator INSTANCE = new ConceptQueryValidator();

    private ConceptQueryValidator() {
    }

    /*
     * WARNING - void declaration
     */
    public final void validateAccessorMethodsOfConceptClass(@NotNull KClass<?> conceptClass) throws MalformedSchemaException {
        Intrinsics.checkNotNullParameter(conceptClass, (String)"conceptClass");
        Set possibleFacetClasses = ArraysKt.toSet((Object[])Reflection.getOrCreateKotlinClasses((Class[])((Concept)AnnotationUtil.INSTANCE.getAnnotation(conceptClass, Reflection.getOrCreateKotlinClass(Concept.class))).facets()));
        Method[] methodArray = JvmClassMappingKt.getJavaClass(conceptClass).getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            if (method.getParameterCount() > 0) {
                throw new WrongFacetQueryMalformedSchemaException("The method has arguments/parameters which is not allowed for methods annotated with " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConcepts.class)) + " or " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConceptIdentifierValue.class)) + ". Method: " + method);
            }
            Intrinsics.checkNotNull((Object)method);
            if (AnnotationUtil.INSTANCE.hasAnnotation(method, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(QueryFacetValue.class))) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KClass queryFacetValueClass = Reflection.getOrCreateKotlinClass((Class)((QueryFacetValue)AnnotationUtil.INSTANCE.getAnnotation(method, Reflection.getOrCreateKotlinClass(QueryFacetValue.class))).facetClass());
                if (possibleFacetClasses.contains(queryFacetValueClass)) continue;
                Iterable iterable = possibleFacetClasses;
                StringBuilder stringBuilder = new StringBuilder().append("The method has a invalid facet class ").append(TypesAsTextFunctions.INSTANCE.shortText(queryFacetValueClass)).append(". Valid facet classes are ");
                boolean $i$f$map = false;
                void var14_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KClass kClass = (KClass)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(TypesAsTextFunctions.INSTANCE.shortText((KClass<?>)it));
                }
                String string = stringBuilder.append((List)destination$iv$iv).append(". Method: ").append(method).toString();
                throw new WrongFacetQueryMalformedSchemaException(string);
            }
            if (AnnotationUtil.INSTANCE.hasAnnotation(method, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(QueryConceptIdentifierValue.class))) continue;
            throw new WrongFacetQueryMalformedSchemaException("The method is missing one of the annotations " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryFacetValue.class)) + " or " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConceptIdentifierValue.class)) + ". Method: " + method);
        }
    }
}

