/*
 * Decompiled with CFR 0.152.
 */
package org.codeblessing.sourceamazing.schema.schemacreator.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.codeblessing.sourceamazing.schema.api.annotations.QueryConcepts;
import org.codeblessing.sourceamazing.schema.api.annotations.Schema;
import org.codeblessing.sourceamazing.schema.documentation.TypesAsTextFunctions;
import org.codeblessing.sourceamazing.schema.schemacreator.exceptions.MalformedSchemaException;
import org.codeblessing.sourceamazing.schema.schemacreator.exceptions.WrongConceptQueryMalformedSchemaException;
import org.codeblessing.sourceamazing.schema.util.AnnotationUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lorg/codeblessing/sourceamazing/schema/schemacreator/query/SchemaQueryValidator;", "", "()V", "validateAccessorMethodsOfSchemaDefinitionClass", "", "schemaDefinitionClass", "Lkotlin/reflect/KClass;", "sourceamazing-schema"})
@SourceDebugExtension(value={"SMAP\nSchemaQueryValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaQueryValidator.kt\norg/codeblessing/sourceamazing/schema/schemacreator/query/SchemaQueryValidator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,44:1\n13309#2:45\n13309#2,2:46\n13310#2:48\n*S KotlinDebug\n*F\n+ 1 SchemaQueryValidator.kt\norg/codeblessing/sourceamazing/schema/schemacreator/query/SchemaQueryValidator\n*L\n17#1:45\n34#1:46,2\n17#1:48\n*E\n"})
public final class SchemaQueryValidator {
    @NotNull
    public static final SchemaQueryValidator INSTANCE = new SchemaQueryValidator();

    private SchemaQueryValidator() {
    }

    public final void validateAccessorMethodsOfSchemaDefinitionClass(@NotNull KClass<?> schemaDefinitionClass) throws MalformedSchemaException {
        Intrinsics.checkNotNullParameter(schemaDefinitionClass, (String)"schemaDefinitionClass");
        Set possibleSchemaConceptClasses = ArraysKt.toSet((Object[])Reflection.getOrCreateKotlinClasses((Class[])((Schema)AnnotationUtil.INSTANCE.getAnnotation(schemaDefinitionClass, Reflection.getOrCreateKotlinClass(Schema.class))).concepts()));
        Method[] methodArray = JvmClassMappingKt.getJavaClass(schemaDefinitionClass).getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)method);
            if (!AnnotationUtil.INSTANCE.hasAnnotation(method, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(QueryConcepts.class))) {
                throw new WrongConceptQueryMalformedSchemaException("The method is missing the annotation " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConcepts.class)) + ". Method: " + method);
            }
            KClass[] queryConceptClasses = Reflection.getOrCreateKotlinClasses((Class[])((QueryConcepts)AnnotationUtil.INSTANCE.getAnnotation(method, Reflection.getOrCreateKotlinClass(QueryConcepts.class))).conceptClasses());
            if (queryConceptClasses.length == 0) {
                throw new WrongConceptQueryMalformedSchemaException("The method has an empty list for conceptClasses on " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConcepts.class)) + ". Method: " + method);
            }
            if (method.getParameterCount() > 0) {
                throw new WrongConceptQueryMalformedSchemaException("The method has arguments/parameters which is not allowed for methods annotated with " + TypesAsTextFunctions.INSTANCE.shortText(Reflection.getOrCreateKotlinClass(QueryConcepts.class)) + ". Method: " + method);
            }
            KClass[] $this$forEach$iv2 = queryConceptClasses;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                KClass element$iv2;
                KClass queryConceptClass = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (possibleSchemaConceptClasses.contains(queryConceptClass)) continue;
                throw new WrongConceptQueryMalformedSchemaException("The method has a invalid concept class '" + TypesAsTextFunctions.INSTANCE.longText(queryConceptClass) + "'. Valid concept classes are " + possibleSchemaConceptClasses + ". Method: " + method);
            }
        }
    }
}

