/*
 * Decompiled with CFR 0.152.
 */
package cwinter.codecraft.collisions;

import cwinter.codecraft.collisions.ActiveVisionTracking;
import cwinter.codecraft.collisions.SquareGrid;
import cwinter.codecraft.collisions.VisionTracking;
import cwinter.codecraft.collisions.VisionTracking$VisionTrackingIsPositionable$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0005\u0011A!!\u0004,jg&|g\u000e\u0016:bG.,'O\u0003\u0002\u0004\t\u0005Q1m\u001c7mSNLwN\\:\u000b\u0005\u00151\u0011!C2pI\u0016\u001c'/\u00194u\u0015\u00059\u0011aB2xS:$XM]\u000b\u0003\u0013A\u001a\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011!\t\u0002A!b\u0001\n\u0003\u0019\u0012\u0001\u0002=NS:\u001c\u0001!F\u0001\u0015!\tYQ#\u0003\u0002\u0017\u0019\t\u0019\u0011J\u001c;\t\u0011a\u0001!\u0011!Q\u0001\nQ\tQ\u0001_'j]\u0002B\u0001B\u0007\u0001\u0003\u0006\u0004%\taE\u0001\u0005q6\u000b\u0007\u0010\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0015AX*\u0019=!\u0011!q\u0002A!b\u0001\n\u0003\u0019\u0012\u0001B=NS:D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0006s6Kg\u000e\t\u0005\tE\u0001\u0011)\u0019!C\u0001'\u0005!\u00110T1y\u0011!!\u0003A!A!\u0002\u0013!\u0012!B=NCb\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\n\u0002\rI\fG-[;t\u0011!A\u0003A!A!\u0002\u0013!\u0012a\u0002:bI&,8\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\r1J$h\u000f\u001f>!\ri\u0003AL\u0007\u0002\u0005A\u0011q\u0006\r\u0007\u0001\t\u0015\t\u0004A1\u00013\u0005\u0005!\u0016CA\u001a7!\tYA'\u0003\u00026\u0019\t9aj\u001c;iS:<\u0007CA\u00178\u0013\tA$A\u0001\bWSNLwN\u001c+sC\u000e\\\u0017N\\4\t\u000bEI\u0003\u0019\u0001\u000b\t\u000biI\u0003\u0019\u0001\u000b\t\u000byI\u0003\u0019\u0001\u000b\t\u000b\tJ\u0003\u0019\u0001\u000b\t\u000b\u0019J\u0003\u0019\u0001\u000b\t\u000f}\u0002!\u0019!C\u0001'\u0005)q/\u001b3uQ\"1\u0011\t\u0001Q\u0001\nQ\taa^5ei\"\u0004\u0003bB\"\u0001\u0005\u0004%\taE\u0001\u0007Q\u0016Lw\r\u001b;\t\r\u0015\u0003\u0001\u0015!\u0003\u0015\u0003\u001dAW-[4ii\u0002Bqa\u0012\u0001C\u0002\u0013\u00051#A\u0004sC\u0012LWo\u001d\u001a\t\r%\u0003\u0001\u0015!\u0003\u0015\u0003!\u0011\u0018\rZ5vgJ\u0002\u0003bB&\u0001\u0005\u0004%I\u0001T\u0001\u000e[>4\u0018N\\4PE*,7\r^:\u0016\u00035\u00032AT*/\u001b\u0005y%B\u0001)R\u0003\u001diW\u000f^1cY\u0016T!A\u0015\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\n\u00191+\u001a;\t\rY\u0003\u0001\u0015!\u0003N\u00039iwN^5oO>\u0013'.Z2ug\u0002Bq\u0001\u0017\u0001C\u0002\u0013%\u0011,A\bue\u0006\u001c7.\u001b8h\u001f\nTWm\u0019;t+\u0005Q\u0006c\u0001(T7J\u0019AL\f0\u0007\tu\u0003\u0001a\u0017\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003[}K!\u0001\u0019\u0002\u0003)\u0005\u001bG/\u001b<f-&\u001c\u0018n\u001c8Ue\u0006\u001c7.\u001b8h\u0011\u0019\u0011\u0007\u0001)A\u00055\u0006\u0001BO]1dW&twm\u00142kK\u000e$8\u000f\t\u0005\bI\u0002\u0011\r\u0011\"\u0003M\u0003)\tG\u000e\\(cU\u0016\u001cGo\u001d\u0005\u0007M\u0002\u0001\u000b\u0011B'\u0002\u0017\u0005dGn\u00142kK\u000e$8\u000f\t\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0003\u00119'/\u001b3\u0016\u0003)\u00042!L6/\u0013\ta'A\u0001\u0006TcV\f'/Z$sS\u0012DaA\u001c\u0001!\u0002\u0013Q\u0017!B4sS\u0012\u0004\u0003b\u00029\u0001\u0001\u0004%IaE\u0001\u0005i&lW\rC\u0004s\u0001\u0001\u0007I\u0011B:\u0002\u0011QLW.Z0%KF$\"\u0001^<\u0011\u0005-)\u0018B\u0001<\r\u0005\u0011)f.\u001b;\t\u000fa\f\u0018\u0011!a\u0001)\u0005\u0019\u0001\u0010J\u0019\t\ri\u0004\u0001\u0015)\u0003\u0015\u0003\u0015!\u0018.\\3!\u0011\u0015a\b\u0001\"\u0001~\u00031Ign]3si\u0006\u001bG/\u001b<f+\rq\u0018Q\u0001\u000b\u0003i~Dq!!\u0001|\u0001\u0004\t\u0019!A\u0002pE*\u00042aLA\u0003\t\u001d\t9a\u001fb\u0001\u0003\u0013\u0011\u0011aU\t\u0004g\u0005-!\u0003BA\u0007]y3Q!\u0018\u0001\u0001\u0003\u0017Aq!!\u0005\u0001\t\u0003\t\u0019\"A\u0007j]N,'\u000f\u001e)bgNLg/Z\u000b\u0005\u0003+\tY\u0002F\u0002u\u0003/A\u0001\"!\u0001\u0002\u0010\u0001\u0007\u0011\u0011\u0004\t\u0004_\u0005mA\u0001CA\u0004\u0003\u001f\u0011\r!!\b\u0012\u0007M\nyBE\u0003\u0002\"9\n\u0019CB\u0003^\u0001\u0001\ty\u0002E\u0002.\u0003KI1!a\n\u0003\u0005U\u0001\u0016m]:jm\u00164\u0016n]5p]R\u0013\u0018mY6j]\u001eD\u0001\"a\u000b\u0001A\u0013%\u0011QF\u0001\u0007S:\u001cXM\u001d;\u0015\u0007Q\fy\u0003C\u0004\u0002\u0002\u0005%\u0002\u0019\u0001\u0018\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005i!/Z7pm\u0016\u0004\u0016m]:jm\u0016,B!a\u000e\u0002>Q\u0019A/!\u000f\t\u0011\u0005\u0005\u0011\u0011\u0007a\u0001\u0003w\u00012aLA\u001f\t!\t9!!\rC\u0002\u0005}\u0012cA\u001a\u0002BI)\u00111\t\u0018\u0002$\u0019)Q\f\u0001\u0001\u0002B!9\u0011q\t\u0001\u0005\u0002\u0005%\u0013\u0001\u0004:f[>4X-Q2uSZ,W\u0003BA&\u0003#\"2\u0001^A'\u0011!\t\t!!\u0012A\u0002\u0005=\u0003cA\u0018\u0002R\u0011A\u0011qAA#\u0005\u0004\t\u0019&E\u00024\u0003+\u0012B!a\u0016/=\u001a)Q\f\u0001\u0001\u0002V!A\u00111\f\u0001!\n\u0013\ti&\u0001\u0004sK6|g/\u001a\u000b\u0004i\u0006}\u0003bBA\u0001\u00033\u0002\rA\f\u0005\b\u0003G\u0002A\u0011AA3\u0003%)\b\u000fZ1uK\u0006cG\u000eF\u0001u\u0011\u001d\tI\u0007\u0001C\u0001\u0003K\nQc\u00195fG.4uN]\"fY2$&/\u00198tM\u0016\u00148\u000fC\u0004\u0002n\u0001!I!!\u001a\u0002%\rDWmY6G_J\u001cu\u000e\u001c7jg&|gn\u001d\u0005\b\u0003c\u0002A\u0011BA:\u00031)\b\u000fZ1uK:+\u0017M\u001d2z)\u0015!\u0018QOA<\u0011\u001d\t\t!a\u001cA\u00029B\u0001\"!\u001f\u0002p\u0001\u0007\u00111P\u0001\u0007]\u0016\f'OY=\u0011\u000b\u0005u\u0014Q\u0012\u0018\u000f\t\u0005}\u0014\u0011\u0012\b\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011\n\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011bAAF\u0019\u00059\u0001/Y2lC\u001e,\u0017\u0002BAH\u0003#\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u0017c\u0001")
public final class VisionTracker<T extends VisionTracking> {
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final int radius;
    private final int width;
    private final int height;
    private final int radius2;
    private final Set<T> movingObjects;
    private final Set<T> trackingObjects;
    private final Set<T> allObjects;
    private final SquareGrid<T> cwinter$codecraft$collisions$VisionTracker$$grid;
    private int cwinter$codecraft$collisions$VisionTracker$$time;

    public int xMin() {
        return this.xMin;
    }

    public int xMax() {
        return this.xMax;
    }

    public int yMin() {
        return this.yMin;
    }

    public int yMax() {
        return this.yMax;
    }

    public int radius() {
        return this.radius;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int radius2() {
        return this.radius2;
    }

    private Set<T> movingObjects() {
        return this.movingObjects;
    }

    private Set<T> trackingObjects() {
        return this.trackingObjects;
    }

    private Set<T> allObjects() {
        return this.allObjects;
    }

    public SquareGrid<T> cwinter$codecraft$collisions$VisionTracker$$grid() {
        return this.cwinter$codecraft$collisions$VisionTracker$$grid;
    }

    public int cwinter$codecraft$collisions$VisionTracker$$time() {
        return this.cwinter$codecraft$collisions$VisionTracker$$time;
    }

    private void cwinter$codecraft$collisions$VisionTracker$$time_$eq(int x$1) {
        this.cwinter$codecraft$collisions$VisionTracker$$time = x$1;
    }

    public <S extends T> void insertActive(S obj) {
        this.trackingObjects().$plus$eq(obj);
        this.insert(obj);
    }

    public <S extends T> void insertPassive(S obj) {
        this.insert(obj);
    }

    private void insert(T obj) {
        this.allObjects().$plus$eq(obj);
        Object object = obj.maxSpeed() != 0.0 ? this.movingObjects().$plus$eq(obj) : BoxedUnit.UNIT;
        Tuple2<Object, Object> tuple2 = this.cwinter$codecraft$collisions$VisionTracker$$grid().computeCell(obj, VisionTracking$VisionTrackingIsPositionable$.MODULE$);
        if (tuple2 != null) {
            Tuple3 tuple3;
            int x = tuple2._1$mcI$sp();
            int y = tuple2._2$mcI$sp();
            Tuple3 tuple32 = tuple3 = new Tuple3(tuple2, (Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToInteger((int)y));
            Tuple2 cell = (Tuple2)tuple32._1();
            int x2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int y2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            obj.cell_$eq((Tuple2<Object, Object>)cell);
            this.cwinter$codecraft$collisions$VisionTracker$$updateNearby(obj, this.cwinter$codecraft$collisions$VisionTracker$$grid().nearbyObjects(x2, y2));
            this.cwinter$codecraft$collisions$VisionTracker$$grid().insert(obj, x2, y2);
            obj.removed_$eq(false);
            return;
        }
        throw new MatchError(tuple2);
    }

    public <S extends T> void removePassive(S obj) {
        this.remove(obj);
        this.cwinter$codecraft$collisions$VisionTracker$$grid().nearbyObjects(obj.x(), obj.y()).foreach((Function1)new Serializable(this, obj){
            public static final long serialVersionUID = 0L;
            private final VisionTracking obj$2;

            public final void apply(T nearby) {
                nearby.objectRemoved(this.obj$2);
            }
            {
                this.obj$2 = obj$2;
            }
        });
    }

    public <S extends T> void removeActive(S obj) {
        this.trackingObjects().$minus$eq(obj);
        this.remove(obj);
        ((ActiveVisionTracking)obj).nearbyObjects().foreach((Function1)new Serializable(this, obj){
            public static final long serialVersionUID = 0L;
            private final VisionTracking obj$3;

            public final void apply(VisionTracking nearby) {
                nearby.objectRemoved(this.obj$3);
            }
            {
                this.obj$3 = obj$3;
            }
        });
    }

    private void remove(T obj) {
        this.movingObjects().$minus$eq(obj);
        this.allObjects().$minus$eq(obj);
        this.cwinter$codecraft$collisions$VisionTracker$$grid().remove(obj, obj.x(), obj.y());
        obj.removed_$eq(true);
    }

    public void updateAll() {
        this.checkForCellTransfers();
        this.checkForCollisions();
    }

    public void checkForCellTransfers() {
        this.movingObjects().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VisionTracker $outer;

            public final void apply(T obj) {
                Tuple2<Object, Object> tuple2 = this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().computeCell(obj, VisionTracking$VisionTrackingIsPositionable$.MODULE$);
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp2;
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(newX, newY);
                    int newX2 = sp3._1$mcI$sp();
                    int newY2 = sp3._2$mcI$sp();
                    int dx = newX2 - obj.x();
                    int dy = newY2 - obj.y();
                    if (dx < -1 || dx > 1 || dy < -1 || dy > 1) {
                        this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().remove(obj, obj.cell());
                        obj.cell_$eq((Tuple2<Object, Object>)new Tuple2.mcII.sp(newX2, newY2));
                        this.$outer.cwinter$codecraft$collisions$VisionTracker$$updateNearby(obj, this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().nearbyObjects(newX2, newY2));
                        this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().insert(obj, newX2, newY2);
                    } else {
                        if (obj.x() != newX2) {
                            this.$outer.cwinter$codecraft$collisions$VisionTracker$$updateNearby(obj, this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().xTransfer(obj, obj.cell(), dx));
                            obj.x_$eq(newX2);
                        }
                        if (obj.y() != newY2) {
                            this.$outer.cwinter$codecraft$collisions$VisionTracker$$updateNearby(obj, this.$outer.cwinter$codecraft$collisions$VisionTracker$$grid().yTransfer(obj, obj.cell(), dy));
                            obj.y_$eq(newY2);
                        }
                    }
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void checkForCollisions() {
        this.trackingObjects().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VisionTracker $outer;

            public final void apply(T x$4) {
                ((ActiveVisionTracking)x$4).recomputeVisible(this.$outer.cwinter$codecraft$collisions$VisionTracker$$time(), this.$outer.radius());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.cwinter$codecraft$collisions$VisionTracker$$time_$eq(this.cwinter$codecraft$collisions$VisionTracker$$time() + 1);
    }

    public void cwinter$codecraft$collisions$VisionTracker$$updateNearby(T obj, Iterator<T> nearby) {
        nearby.foreach((Function1)new Serializable(this, obj){
            public static final long serialVersionUID = 0L;
            private final VisionTracking obj$1;

            public final void apply(T obj2) {
                this.obj$1.objectIsNearby((VisionTracking)obj2);
                obj2.objectIsNearby(this.obj$1);
            }
            {
                this.obj$1 = obj$1;
            }
        });
    }

    public VisionTracker(int xMin, int xMax, int yMin, int yMax, int radius) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.radius = radius;
        Predef$.MODULE$.require((xMax - xMin) % radius == 0);
        Predef$.MODULE$.require((yMax - yMin) % radius == 0);
        Predef$.MODULE$.require(yMax > yMin);
        Predef$.MODULE$.require(xMax > xMin);
        this.width = (xMax - xMin) / radius;
        this.height = (yMax - yMin) / radius;
        this.radius2 = radius * radius;
        this.movingObjects = Set$.MODULE$.empty();
        this.trackingObjects = Set$.MODULE$.empty();
        this.allObjects = Set$.MODULE$.empty();
        this.cwinter$codecraft$collisions$VisionTracker$$grid = new SquareGrid<VisionTracking>(xMin, xMax, yMin, yMax, radius, VisionTracking$VisionTrackingIsPositionable$.MODULE$);
        this.cwinter$codecraft$collisions$VisionTracker$$time = 0;
    }
}

