/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.test;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.tool.exception.Exceptions;
import org.mariadb.jdbc.MariaDbDataSource;

public class MariaDBEmbeddableDataSource
extends UrlAwareDataSource
implements Closeable {
    public static final int DEFAULT_PORT = 3306;
    private static final Map<Integer, DB> USED_PORTS = new HashMap<Integer, DB>();
    private DB db;
    private final int port;

    public MariaDBEmbeddableDataSource() {
        this(3306);
    }

    public MariaDBEmbeddableDataSource(int port) {
        this(port, "test" + Integer.toHexString(new Random().nextInt()));
    }

    private MariaDBEmbeddableDataSource(int port, String databaseName) {
        super("jdbc:mariadb://localhost:" + port + "/" + databaseName);
        MariaDbDataSource delegate;
        this.port = port;
        this.start();
        try {
            delegate = new MariaDbDataSource(this.getUrl());
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        this.setDelegate((DataSource)delegate);
        try {
            this.db.createDB(databaseName);
        }
        catch (ManagedProcessException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
    }

    private void start() {
        this.db = USED_PORTS.get(this.port);
        if (this.db == null) {
            try {
                DBConfigurationBuilder configBuilder = DBConfigurationBuilder.newBuilder();
                configBuilder.setPort(this.port);
                configBuilder.addArg("--user=root");
                this.db = DB.newEmbeddedDB((DBConfiguration)configBuilder.build());
                this.db.start();
                USED_PORTS.put(this.port, this.db);
            }
            catch (ManagedProcessException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.db.stop();
            USED_PORTS.remove(this.port);
        }
        catch (ManagedProcessException e) {
            throw new IOException(e);
        }
    }
}

