/*
 * Decompiled with CFR 0.152.
 */
package org.codegas.service.jpa;

import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.codegas.commons.domain.entity.DomainEntity;
import org.codegas.commons.lang.value.Id;
import org.codegas.service.api.Repository;

public abstract class RepositoryImpl<T extends DomainEntity>
implements Repository<T> {
    @PersistenceContext
    protected EntityManager entityManager;
    protected final Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public T add(T t) {
        this.entityManager.persist(t);
        return t;
    }

    public T remove(T t) {
        this.entityManager.remove(t);
        return t;
    }

    public Optional<T> find(Id id) {
        return Optional.ofNullable(this.entityManager.find(this.entityClass, id.toJpaQueryObject()));
    }

    public Stream<T> get() {
        return this.entityManager.createQuery(" SELECT entity FROM " + this.entityClass.getSimpleName() + " entity", this.entityClass).getResultStream();
    }
}

