/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.development;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.fabric3.host.runtime.Bootstrapper;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.host.runtime.RuntimeLifecycleCoordinator;
import org.fabric3.host.runtime.ScdlBootstrapper;
import org.fabric3.host.runtime.ShutdownException;
import org.fabric3.host.runtime.StartException;
import org.fabric3.runtime.development.InvalidConfigurationException;
import org.fabric3.runtime.development.InvalidFabric3HomeException;
import org.fabric3.runtime.development.RuntimeShutdownException;
import org.fabric3.runtime.development.host.DevelopmentHostInfoImpl;
import org.fabric3.runtime.development.host.DevelopmentRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    public static final String FABRIC3_DEV_HOME = "fabric3.dev.home";
    public static final String SYSTEM_SCDL = "/system/system.composite";
    public static final URI DOMAIN_URI = URI.create("fabric3://./domain");
    private DevelopmentRuntime runtime;
    private RuntimeLifecycleCoordinator<DevelopmentRuntime, Bootstrapper> coordinator;
    private String extensionsDirectory;

    public void setExtensionsDirectory(String extensionsDirectory) {
        this.extensionsDirectory = extensionsDirectory;
    }

    public void activate(URL compositeFile) {
        if (this.runtime == null) {
            this.bootRuntime();
        }
        this.runtime.activate(compositeFile);
    }

    public <T> T connectTo(Class<T> interfaze, String componentUri) {
        if (this.runtime == null) {
            throw new IllegalStateException("No composite is activated");
        }
        return this.runtime.connectTo(interfaze, componentUri);
    }

    public <T> void registerMockReference(String name, Class<T> interfaze, T mock) {
        if (this.runtime == null) {
            this.bootRuntime();
        }
        this.runtime.registerMockReference(name, interfaze, mock);
    }

    public void stop() {
        try {
            Future future = this.coordinator.shutdown();
            future.get();
        }
        catch (ShutdownException e) {
            throw new RuntimeShutdownException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeShutdownException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeShutdownException(e);
        }
        this.runtime = null;
    }

    private void bootRuntime() {
        File baseDir;
        String home = System.getProperty(FABRIC3_DEV_HOME);
        if (home == null) {
            home = this.calculateHome();
            baseDir = new File(home).getParentFile();
            if (baseDir == null || !baseDir.exists()) {
                throw new InvalidFabric3HomeException("Fabric3 home system property not set", FABRIC3_DEV_HOME);
            }
        } else {
            baseDir = new File(home);
        }
        if (!baseDir.exists()) {
            throw new InvalidFabric3HomeException("Fabric3 home system directory does not exist", home);
        }
        File libDir = new File(baseDir, "boot");
        if (!libDir.exists()) {
            throw new InvalidFabric3HomeException("Invalid Fabric3 installation: boot directory not found", home);
        }
        File[] libraries = libDir.listFiles();
        URL[] urls = new URL[libraries.length];
        for (int i = 0; i < libraries.length; ++i) {
            try {
                urls[i] = libraries[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            URLClassLoader cl = new URLClassLoader(urls, this.getClass().getClassLoader());
            this.getClass().getClassLoader().loadClass("org.osoa.sca.ServiceUnavailableException");
            URL systemSCDL = new File(baseDir, SYSTEM_SCDL).toURI().toURL();
            Class<?> bootstrapperClass = cl.loadClass("org.fabric3.fabric.runtime.ScdlBootstrapperImpl");
            ScdlBootstrapper bootstrapper = (ScdlBootstrapper)bootstrapperClass.newInstance();
            bootstrapper.setScdlLocation(systemSCDL);
            Class<?> runtimeClass = cl.loadClass("org.fabric3.runtime.development.host.DevelopmentRuntimeImpl");
            this.runtime = (DevelopmentRuntime)runtimeClass.newInstance();
            URL baseDirUrl = baseDir.toURI().toURL();
            File dir = this.extensionsDirectory == null ? new File(baseDir, "extensions") : new File(this.extensionsDirectory);
            this.runtime.setHostInfo(new DevelopmentHostInfoImpl(DOMAIN_URI, baseDirUrl, dir));
            this.runtime.setHostClassLoader(cl);
            Class<?> coordinatorClass = cl.loadClass("org.fabric3.runtime.development.host.DevelopmentCoordinator");
            this.coordinator = (RuntimeLifecycleCoordinator)coordinatorClass.newInstance();
            this.coordinator.bootPrimordial((Fabric3Runtime)this.runtime, (Bootstrapper)bootstrapper, (ClassLoader)cl, (ClassLoader)cl);
            this.coordinator.initialize();
            Future future = this.coordinator.joinDomain(-1L);
            future.get();
            future = this.coordinator.recover();
            future.get();
            future = this.coordinator.start();
            future.get();
        }
        catch (InstantiationException e) {
            throw new InvalidConfigurationException("Error instantiating runtime classes are missing", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfigurationException("Invalid configuration", e);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Runtime classes are missing", e);
        }
        catch (InitializationException e) {
            throw new InvalidConfigurationException("Error initializing runtime", e);
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigurationException("Error initializing runtime", e);
        }
        catch (StartException e) {
            throw new InvalidConfigurationException("Error initializing runtime", e);
        }
        catch (ExecutionException e) {
            throw new InvalidConfigurationException("Error initializing runtime", e);
        }
        catch (InterruptedException e) {
            throw new InvalidConfigurationException("Error initializing runtime", e);
        }
    }

    private String calculateHome() {
        String path = Domain.class.getResource("Domain.class").toString();
        path = path.substring(0, path.indexOf("!"));
        path = path.substring(0, path.lastIndexOf("/"));
        String home = path.substring(path.lastIndexOf(":") + 1);
        return home;
    }
}

