/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ftp.generator;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.binding.ftp.common.Constants;
import org.fabric3.binding.ftp.model.FtpBindingDefinition;
import org.fabric3.binding.ftp.model.TransferMode;
import org.fabric3.binding.ftp.provision.FtpSecurity;
import org.fabric3.binding.ftp.provision.FtpSourceDefinition;
import org.fabric3.binding.ftp.provision.FtpTargetDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.generator.BindingGenerator;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.oasisopen.sca.annotation.Property;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpBindingGenerator
implements BindingGenerator<FtpBindingDefinition> {
    private int connectTimeout = 120000;
    private int socketTimeout = 1800000;

    @Property(required=false)
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Property(required=false)
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public FtpSourceDefinition generateSource(LogicalBinding<FtpBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        if (contract.getOperations().size() != 1) {
            throw new GenerationException("Expects only one operation");
        }
        FtpSourceDefinition hwsd = new FtpSourceDefinition();
        URI targetUri = ((FtpBindingDefinition)binding.getDefinition()).getTargetUri();
        hwsd.setUri(targetUri);
        return hwsd;
    }

    public FtpTargetDefinition generateTarget(LogicalBinding<FtpBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        if (operations.size() != 1) {
            throw new GenerationException("Expects only one operation");
        }
        URI id = ((LogicalCompositeComponent)((LogicalComponent)((Bindable)binding.getParent()).getParent()).getParent()).getUri();
        FtpBindingDefinition definition = (FtpBindingDefinition)binding.getDefinition();
        boolean active = definition.getTransferMode() == TransferMode.ACTIVE;
        FtpSecurity security = this.processPolicies(policy);
        FtpTargetDefinition hwtd = new FtpTargetDefinition(id, active, security, this.connectTimeout, this.socketTimeout);
        hwtd.setUri(definition.getTargetUri());
        if (!definition.getSTORCommands().isEmpty()) {
            hwtd.setSTORCommands(definition.getSTORCommands());
        }
        hwtd.setTmpFileSuffix(((FtpBindingDefinition)binding.getDefinition()).getTmpFileSuffix());
        return hwtd;
    }

    public PhysicalTargetDefinition generateServiceBindingTarget(LogicalBinding<FtpBindingDefinition> serviceBinding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        throw new UnsupportedOperationException();
    }

    private FtpSecurity processPolicies(EffectivePolicy policy) throws GenerationException {
        Set policySets = policy.getEndpointPolicySets();
        if (policySets == null || policySets.size() == 0) {
            return null;
        }
        if (policySets.size() != 1) {
            throw new GenerationException("Invalid policy configuration, only supports security policy");
        }
        PolicySet policySet = (PolicySet)policySets.iterator().next();
        QName policyQName = policySet.getExpressionName();
        if (!policyQName.equals(Constants.POLICY_QNAME)) {
            throw new GenerationException("Unexpected policy element " + policyQName);
        }
        Element expression = policySet.getExpression();
        String user = expression.getAttribute("user");
        if (user == null) {
            throw new GenerationException("User name not specified in security policy");
        }
        String password = expression.getAttribute("password");
        if (password == null) {
            throw new GenerationException("Password not specified in security policy");
        }
        return new FtpSecurity(user, password);
    }
}

