/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ftp.introspection;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.ftp.model.FtpBindingDefinition;
import org.fabric3.binding.ftp.model.TransferMode;
import org.fabric3.host.failure.ValidationFailure;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpBindingLoader
extends AbstractValidatingTypeLoader<FtpBindingDefinition> {
    private final LoaderHelper loaderHelper;

    public FtpBindingLoader(@Reference LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"uri", "requires", "policySets", "mode", "tmpFileSuffix"});
    }

    public FtpBindingDefinition load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        FtpBindingDefinition bd = null;
        String uri = null;
        try {
            uri = reader.getAttributeValue(null, "uri");
            String transferMode = reader.getAttributeValue(null, "mode");
            if (uri == null) {
                MissingAttribute failure = new MissingAttribute("A binding URI must be specified ", startLocation, new ModelObject[0]);
                introspectionContext.addError((ValidationFailure)failure);
                return null;
            }
            if (!uri.startsWith("ftp://") && !uri.startsWith("FTP://")) {
                uri = "ftp://" + uri;
            }
            TransferMode tMode = transferMode != null ? TransferMode.valueOf(transferMode) : TransferMode.PASSIVE;
            URI endpointUri = new URI(uri);
            bd = new FtpBindingDefinition(endpointUri, tMode);
            String tmpFileSuffix = reader.getAttributeValue(null, "tmpFileSuffix");
            if (tmpFileSuffix != null) {
                bd.setTmpFileSuffix(tmpFileSuffix);
            }
            this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)bd, reader, introspectionContext);
            this.validateAttributes(reader, introspectionContext, new ModelObject[]{bd});
            block6: while (true) {
                switch (reader.next()) {
                    case 2: {
                        if ("binding.ftp".equals(reader.getName().getLocalPart())) {
                            return bd;
                        }
                    }
                    case 1: {
                        boolean success;
                        if (!"commands".equals(reader.getName().getLocalPart()) || (success = this.parseCommands(bd, reader, introspectionContext))) continue block6;
                        do {
                            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                        } while (!"binding.ftp".equals(reader.getName().getLocalPart()));
                        return bd;
                    }
                }
            }
        }
        catch (URISyntaxException ex) {
            InvalidValue failure = new InvalidValue("The FTP binding URI is not valid: " + uri, startLocation, new ModelObject[0]);
            introspectionContext.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return bd;
        }
    }

    private boolean parseCommands(FtpBindingDefinition bd, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        while (true) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!"commands".equals(reader.getName().getLocalPart())) break;
                    return true;
                }
                case 1: {
                    Location location = reader.getLocation();
                    if ("command".equals(reader.getName().getLocalPart())) {
                        reader.next();
                        bd.addSTORCommand(reader.getText());
                        break;
                    }
                    UnrecognizedElement error = new UnrecognizedElement(reader, location, new ModelObject[]{bd});
                    context.addError((ValidationFailure)error);
                    return false;
                }
            }
        }
    }
}

