/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ftp.runtime;

import java.net.URI;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.ftp.provision.FtpSourceDefinition;
import org.fabric3.binding.ftp.runtime.BindingFtpLet;
import org.fabric3.binding.ftp.runtime.BindingMonitor;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Wire;
import org.fabric3.transport.ftp.api.FtpLet;
import org.fabric3.transport.ftp.spi.FtpLetContainer;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpSourceWireAttacher
implements SourceWireAttacher<FtpSourceDefinition> {
    private FtpLetContainer ftpLetContainer;
    private BindingMonitor monitor;

    public FtpSourceWireAttacher(@Reference(required=false) FtpLetContainer ftpLetContainer, @Monitor BindingMonitor monitor) {
        this.ftpLetContainer = ftpLetContainer;
        this.monitor = monitor;
    }

    public void attach(FtpSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        URI uri = source.getUri();
        String servicePath = uri.getSchemeSpecificPart();
        if (servicePath.startsWith("//")) {
            servicePath = servicePath.substring(2);
        }
        BindingFtpLet bindingFtpLet = new BindingFtpLet(servicePath, wire, this.monitor);
        if (this.ftpLetContainer == null) {
            throw new WiringException("An FTP server was not configured for this runtime. Ensure the FTP server extension is installed and configured properly.");
        }
        this.ftpLetContainer.registerFtpLet(servicePath, (FtpLet)bindingFtpLet);
    }

    public void detach(FtpSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(FtpSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    public void attachObjectFactory(FtpSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalTargetDefinition definition) throws WiringException {
        throw new UnsupportedOperationException();
    }
}

