/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ftp.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.net.SocketFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.fabric3.binding.ftp.provision.FtpSecurity;
import org.fabric3.binding.ftp.runtime.FtpInterceptorMonitor;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.wire.Interceptor;
import org.oasisopen.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpTargetInterceptor
implements Interceptor {
    private Interceptor next;
    private final int port;
    private final InetAddress hostAddress;
    private String remotePath;
    private String tmpFileSuffix;
    private final int timeout;
    private SocketFactory factory;
    private List<String> commands;
    private FtpInterceptorMonitor monitor;
    private final FtpSecurity security;
    private final boolean active;

    public FtpTargetInterceptor(InetAddress hostAddress, int port, FtpSecurity security, boolean active, int timeout, SocketFactory factory, List<String> commands, FtpInterceptorMonitor monitor) throws UnknownHostException {
        this.hostAddress = hostAddress;
        this.port = port;
        this.security = security;
        this.active = active;
        this.timeout = timeout;
        this.factory = factory;
        this.commands = commands;
        this.monitor = monitor;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public Message invoke(Message msg) {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setSocketFactory(this.factory);
        try {
            String fileName;
            if (this.timeout > 0) {
                ftpClient.setDefaultTimeout(this.timeout);
                ftpClient.setDataTimeout(this.timeout);
            }
            this.monitor.onConnect(this.hostAddress, this.port);
            ftpClient.connect(this.hostAddress, this.port);
            this.monitor.onResponse(ftpClient.getReplyString());
            String type = (String)msg.getWorkContext().getHeader(String.class, "f3.contentType");
            if (type != null && type.equalsIgnoreCase("BINARY")) {
                this.monitor.onCommand("TYPE I");
                ftpClient.setFileType(2);
                this.monitor.onResponse(ftpClient.getReplyString());
            } else if (type != null && type.equalsIgnoreCase("TEXT")) {
                this.monitor.onCommand("TYPE A");
                ftpClient.setFileType(0);
                this.monitor.onResponse(ftpClient.getReplyString());
            }
            this.monitor.onAuthenticate();
            ftpClient.login(this.security.getUser(), this.security.getPassword());
            this.monitor.onResponse(ftpClient.getReplyString());
            Object[] args = (Object[])msg.getBody();
            String remoteFileLocation = fileName = (String)args[0];
            InputStream data = (InputStream)args[1];
            if (this.active) {
                this.monitor.onCommand("ACTV");
                ftpClient.enterLocalActiveMode();
                this.monitor.onResponse(ftpClient.getReplyString());
            } else {
                this.monitor.onCommand("PASV");
                ftpClient.enterLocalPassiveMode();
                this.monitor.onResponse(ftpClient.getReplyString());
            }
            if (this.commands != null) {
                for (String command : this.commands) {
                    this.monitor.onCommand(command);
                    ftpClient.sendCommand(command);
                    this.monitor.onResponse(ftpClient.getReplyString());
                }
            }
            if (this.remotePath != null && this.remotePath.length() > 0) {
                remoteFileLocation = this.remotePath.endsWith("/") ? this.remotePath + fileName : this.remotePath + "/" + fileName;
            }
            String remoteTmpFileLocation = remoteFileLocation;
            if (this.tmpFileSuffix != null && this.tmpFileSuffix.length() > 0) {
                remoteTmpFileLocation = remoteTmpFileLocation + this.tmpFileSuffix;
            }
            this.monitor.onCommand("STOR " + remoteFileLocation);
            if (!ftpClient.storeFile(remoteTmpFileLocation, data)) {
                throw new ServiceUnavailableException("Unable to upload data. Response sent from server: " + ftpClient.getReplyString() + " ,remoteFileLocation:" + remoteFileLocation);
            }
            this.monitor.onResponse(ftpClient.getReplyString());
            if (!remoteTmpFileLocation.equals(remoteFileLocation)) {
                ftpClient.rename(remoteTmpFileLocation, remoteFileLocation);
            }
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        msg.reset();
        return msg;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }
}

