/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ftp.runtime;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.net.SocketFactory;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.ftp.provision.FtpSecurity;
import org.fabric3.binding.ftp.provision.FtpTargetDefinition;
import org.fabric3.binding.ftp.runtime.ExpiringSocketFactory;
import org.fabric3.binding.ftp.runtime.FtpInterceptorMonitor;
import org.fabric3.binding.ftp.runtime.FtpTargetInterceptor;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpTargetWireAttacher
implements TargetWireAttacher<FtpTargetDefinition> {
    private FtpInterceptorMonitor monitor;

    public FtpTargetWireAttacher(@Monitor FtpInterceptorMonitor monitor) {
        this.monitor = monitor;
    }

    public void attach(PhysicalSourceDefinition source, FtpTargetDefinition target, Wire wire) throws WiringException {
        InvocationChain invocationChain = (InvocationChain)wire.getInvocationChains().iterator().next();
        URI uri = target.getUri();
        try {
            String host = uri.getHost();
            int port = uri.getPort() == -1 ? 23 : uri.getPort();
            InetAddress hostAddress = "localhost".equals(host) ? InetAddress.getLocalHost() : InetAddress.getByName(host);
            String remotePath = uri.getPath();
            String tmpFileSuffix = target.getTmpFileSuffix();
            FtpSecurity security = target.getSecurity();
            boolean active = target.isActive();
            int connectTimeout = target.getConectTimeout();
            ExpiringSocketFactory factory = new ExpiringSocketFactory(connectTimeout);
            int socketTimeout = target.getSocketTimeout();
            List<String> cmds = target.getSTORCommands();
            FtpTargetInterceptor targetInterceptor = new FtpTargetInterceptor(hostAddress, port, security, active, socketTimeout, (SocketFactory)factory, cmds, this.monitor);
            targetInterceptor.setTmpFileSuffix(tmpFileSuffix);
            targetInterceptor.setRemotePath(remotePath);
            invocationChain.addInterceptor((Interceptor)targetInterceptor);
        }
        catch (UnknownHostException e) {
            throw new WiringException((Throwable)e);
        }
    }

    public void detach(PhysicalSourceDefinition source, FtpTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(FtpTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }
}

