/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.hessian.runtime;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.binding.hessian.runtime.InvalidTransportException;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.ConversationContext;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.osoa.sca.Conversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HessianServiceHandler
extends HttpServlet {
    private Map<String, Map.Entry<PhysicalOperationDefinition, InvocationChain>> ops;
    private String callbackUri;
    private final ClassLoader classLoader;
    private final SerializerFactory serializerFactory;

    public HessianServiceHandler(Map<String, Map.Entry<PhysicalOperationDefinition, InvocationChain>> ops, String callbackUri, ClassLoader classLoader, SerializerFactory serializerFactory) {
        this.ops = ops;
        this.callbackUri = callbackUri;
        this.classLoader = classLoader;
        this.serializerFactory = serializerFactory;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream in = request.getInputStream();
        Hessian2Input hessianInput = new Hessian2Input((InputStream)in);
        hessianInput.setSerializerFactory(this.serializerFactory);
        String header = hessianInput.readHeader();
        if (!"callFrames".equals(header)) {
            throw new InvalidTransportException("CallFrames header not found");
        }
        List callFrames = (List)hessianInput.readObject();
        hessianInput.readMethod();
        String methodName = hessianInput.getMethod();
        PhysicalOperationDefinition op = this.ops.get(methodName).getKey();
        Interceptor head = this.ops.get(methodName).getValue().getHeadInterceptor();
        Object[] args = new Object[op.getParameters().size()];
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            for (int i = 0; i < args.length; ++i) {
                args[i] = hessianInput.readObject();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        hessianInput.completeCall();
        WorkContext workContext = new WorkContext();
        workContext.addCallFrames(callFrames);
        CallFrame previous = workContext.peekCallFrame();
        Object id = previous.getCorrelationId(Object.class);
        ConversationContext context = previous.getConversationContext();
        Conversation conversation = previous.getConversation();
        CallFrame frame = new CallFrame(this.callbackUri, id, conversation, context);
        callFrames.add(frame);
        MessageImpl input = new MessageImpl((Object)args, false, workContext);
        Message output = head.invoke((Message)input);
        ServletOutputStream out = response.getOutputStream();
        Hessian2Output hessianOutput = new Hessian2Output((OutputStream)out);
        hessianOutput.setSerializerFactory(this.serializerFactory);
        hessianOutput.startReply();
        if (output.isFault()) {
            Throwable t = (Throwable)output.getBody();
            hessianOutput.writeFault("ServiceException", t.getMessage(), t.getClass());
        } else {
            hessianOutput.writeObject(output.getBody());
        }
        hessianOutput.completeReply();
        hessianOutput.flush();
        out.close();
    }
}

