/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.hessian.runtime;

import com.caucho.hessian.io.SerializerFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.fabric3.api.annotation.Monitor;
import org.fabric3.binding.hessian.provision.HessianWireSourceDefinition;
import org.fabric3.binding.hessian.runtime.HessianServiceHandler;
import org.fabric3.binding.hessian.runtime.HessianWireAttacherMonitor;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.services.classloading.ClassLoaderRegistry;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HessianSourceWireAttacher
implements SourceWireAttacher<HessianWireSourceDefinition> {
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ServletHost servletHost;
    private final HessianWireAttacherMonitor monitor;
    private final SerializerFactory serializerFactory;

    public HessianSourceWireAttacher(@Reference ServletHost servletHost, @Reference ClassLoaderRegistry classLoaderRegistry, @Monitor HessianWireAttacherMonitor monitor) {
        this.servletHost = servletHost;
        this.classLoaderRegistry = classLoaderRegistry;
        this.monitor = monitor;
        this.serializerFactory = new SerializerFactory();
    }

    public void attachToSource(HessianWireSourceDefinition sourceDefinition, PhysicalWireTargetDefinition targetDefinition, Wire wire) throws WiringException {
        HashMap<String, Map.Entry<PhysicalOperationDefinition, InvocationChain>> ops = new HashMap<String, Map.Entry<PhysicalOperationDefinition, InvocationChain>>();
        for (Map.Entry entry : wire.getInvocationChains().entrySet()) {
            ops.put(((PhysicalOperationDefinition)entry.getKey()).getName(), entry);
        }
        URI id = sourceDefinition.getClassLoaderId();
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(id);
        if (loader == null) {
            throw new WiringException("Classloader not found", id.toString());
        }
        String callbackUri = null;
        if (targetDefinition.getCallbackUri() != null) {
            callbackUri = targetDefinition.getCallbackUri().toString();
        }
        HessianServiceHandler handler = new HessianServiceHandler(ops, callbackUri, loader, this.serializerFactory);
        URI uri = sourceDefinition.getUri();
        String servicePath = uri.getPath();
        this.servletHost.registerMapping(servicePath, (Servlet)handler);
        this.monitor.provisionedEndpoint(uri);
    }

    public void attachObjectFactory(HessianWireSourceDefinition source, ObjectFactory<?> objectFactory) throws WiringException {
        throw new AssertionError();
    }
}

