/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.hessian.runtime;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianServiceException;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.wire.Interceptor;
import org.osoa.sca.ServiceUnavailableException;

public class HessianTargetInterceptor
implements Interceptor {
    private Interceptor next;
    private final URL referenceUrl;
    private final String methodName;
    private final ClassLoader classLoader;
    private final SerializerFactory serializerFactory;

    public HessianTargetInterceptor(URL referenceUrl, String methodName, ClassLoader classLoader, SerializerFactory serializerFactory) {
        this.referenceUrl = referenceUrl;
        this.methodName = methodName;
        this.classLoader = classLoader;
        this.serializerFactory = serializerFactory;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public Message invoke(Message message) {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)this.referenceUrl.openConnection();
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        try {
            this.sendRequest(con, message);
            Message e = this.receiveResponse(con);
            return e;
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        finally {
            con.disconnect();
        }
    }

    private void sendRequest(HttpURLConnection conn, Message message) throws IOException {
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "x-application/hessian");
        OutputStream os = conn.getOutputStream();
        Hessian2Output output = new Hessian2Output(os);
        output.setSerializerFactory(this.serializerFactory);
        output.startCall();
        output.writeHeader("callFrames");
        output.writeObject((Object)message.getWorkContext().getCallFrameStack());
        output.writeMethod(this.methodName);
        Object[] args = (Object[])message.getBody();
        if (args != null) {
            for (Object arg : args) {
                output.writeObject(arg);
            }
        }
        output.completeCall();
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveResponse(HttpURLConnection con) throws IOException {
        Hessian2Input input = new Hessian2Input(con.getInputStream());
        input.setSerializerFactory(this.serializerFactory);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            MessageImpl result = new MessageImpl();
            try {
                Object retValue = input.readReply(null);
                result.setBody(retValue);
            }
            catch (IOException e) {
                throw e;
            }
            catch (HessianServiceException e) {
                result.setBodyWithFault((Object)this.workAroundThrowableSerialization(e));
            }
            catch (Throwable throwable) {
                result.setBodyWithFault((Object)throwable);
            }
            MessageImpl messageImpl = result;
            return messageImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private Throwable workAroundThrowableSerialization(HessianServiceException e) {
        String text = e.getMessage();
        Class type = (Class)e.getDetail();
        try {
            Constructor ctr = type.getConstructor(String.class);
            return (Throwable)ctr.newInstance(text);
        }
        catch (Exception ex) {
            throw new ServiceUnavailableException((Throwable)ex);
        }
    }
}

