/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.hessian.runtime;

import com.caucho.hessian.io.SerializerFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.fabric3.api.annotation.Monitor;
import org.fabric3.binding.hessian.provision.HessianWireTargetDefinition;
import org.fabric3.binding.hessian.runtime.HessianTargetInterceptor;
import org.fabric3.binding.hessian.runtime.HessianWireAttacherMonitor;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.services.classloading.ClassLoaderRegistry;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class HessianTargetWireAttacher
implements TargetWireAttacher<HessianWireTargetDefinition> {
    private final ClassLoaderRegistry classLoaderRegistry;
    private final HessianWireAttacherMonitor monitor;
    private final SerializerFactory serializerFactory;

    public HessianTargetWireAttacher(@Reference ClassLoaderRegistry classLoaderRegistry, @Monitor HessianWireAttacherMonitor monitor) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.monitor = monitor;
        this.serializerFactory = new SerializerFactory();
    }

    @Init
    public void start() {
        this.monitor.extensionStarted();
    }

    @Destroy
    public void stop() {
        this.monitor.extensionStopped();
    }

    public void attachToTarget(PhysicalWireSourceDefinition sourceDefinition, HessianWireTargetDefinition targetDefinition, Wire wire) throws WiringException {
        URI id = targetDefinition.getClassLoaderId();
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(id);
        URI uri = targetDefinition.getUri();
        try {
            for (Map.Entry entry : wire.getInvocationChains().entrySet()) {
                PhysicalOperationDefinition op = (PhysicalOperationDefinition)entry.getKey();
                InvocationChain chain = (InvocationChain)entry.getValue();
                chain.addInterceptor((Interceptor)new HessianTargetInterceptor(uri.toURL(), op.getName(), loader, this.serializerFactory));
            }
        }
        catch (MalformedURLException ex) {
            throw new WireAttachException("Invalid URI", sourceDefinition.getUri(), uri, (Throwable)ex);
        }
    }

    public ObjectFactory<?> createObjectFactory(HessianWireTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }
}

