/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.control.jaxb;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.WebFault;
import org.fabric3.binding.ws.axis2.control.jaxb.InvalidWebFaultException;
import org.fabric3.binding.ws.axis2.control.jaxb.MissingFaultInfoException;
import org.fabric3.binding.ws.axis2.provision.jaxb.JaxbInterceptorDefinition;
import org.fabric3.model.type.service.DataType;
import org.fabric3.model.type.service.Operation;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.InterceptorDefinitionGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalService;
import org.osoa.sca.annotations.EagerInit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JaxbInterceptorDefinitionGenerator
implements InterceptorDefinitionGenerator {
    public JaxbInterceptorDefinition generate(Element policySet, Operation<?> operation, LogicalBinding<?> logicalBinding) throws GenerationException {
        boolean service = logicalBinding.getParent() instanceof LogicalService;
        List inputTypes = (List)operation.getInputType().getLogical();
        List faultTypes = operation.getFaultTypes();
        DataType outputType = operation.getOutputType();
        HashSet<String> classNames = new HashSet<String>(inputTypes.size() + 1);
        for (DataType inputType : inputTypes) {
            String className = ((Class)inputType.getPhysical()).getName();
            classNames.add(className);
        }
        HashSet<String> faultNames = new HashSet<String>(faultTypes.size());
        for (DataType faultType : faultTypes) {
            Method getFaultInfo;
            Class webFaultClass = (Class)faultType.getPhysical();
            if (!webFaultClass.isAnnotationPresent(WebFault.class)) {
                throw new InvalidWebFaultException(webFaultClass.getName());
            }
            try {
                getFaultInfo = webFaultClass.getMethod("getFaultInfo", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MissingFaultInfoException(webFaultClass.getName());
            }
            Class<?> faultClass = getFaultInfo.getReturnType();
            faultNames.add(webFaultClass.getName());
            classNames.add(faultClass.getName());
        }
        classNames.add(((Class)outputType.getPhysical()).getName());
        return new JaxbInterceptorDefinition(classNames, faultNames, service);
    }
}

