/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.fabric3.api.annotation.Monitor;
import org.fabric3.binding.ws.axis2.provision.Axis2WireSourceDefinition;
import org.fabric3.binding.ws.axis2.provision.AxisPolicy;
import org.fabric3.binding.ws.axis2.runtime.Axis2ServiceProvisioner;
import org.fabric3.binding.ws.axis2.runtime.InOnlyServiceProxyHandler;
import org.fabric3.binding.ws.axis2.runtime.InOutServiceProxyHandler;
import org.fabric3.binding.ws.axis2.runtime.ServiceProvisionerMonitor;
import org.fabric3.binding.ws.axis2.runtime.config.F3Configurator;
import org.fabric3.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.fabric3.binding.ws.axis2.runtime.servlet.F3AxisServlet;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.services.expression.ExpressionExpander;
import org.fabric3.spi.services.expression.ExpressionExpansionException;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Element;

@EagerInit
public class Axis2ServiceProvisionerImpl
implements Axis2ServiceProvisioner {
    private final ServletHost servletHost;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final PolicyApplier policyApplier;
    private final F3Configurator f3Configurator;
    private ExpressionExpander expander;
    private ServiceProvisionerMonitor monitor;
    private ConfigurationContext configurationContext;
    private String servicePath = "axis2";
    private F3AxisServlet axisServlet;

    public Axis2ServiceProvisionerImpl(@Reference ServletHost servletHost, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference PolicyApplier policyApplier, @Reference F3Configurator f3Configurator, @Reference ExpressionExpander expander, @Monitor ServiceProvisionerMonitor monitor) {
        this.servletHost = servletHost;
        this.classLoaderRegistry = classLoaderRegistry;
        this.policyApplier = policyApplier;
        this.f3Configurator = f3Configurator;
        this.expander = expander;
        this.monitor = monitor;
    }

    @Property
    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Init
    public void start() throws Exception {
        this.configurationContext = this.f3Configurator.getConfigurationContext();
        this.axisServlet = new F3AxisServlet(this.configurationContext);
        String mapping = "/" + this.servicePath + "/*";
        if (this.servletHost.isMappingRegistered(mapping)) {
            this.servletHost.unregisterMapping(mapping);
        }
        this.servletHost.registerMapping(mapping, (Servlet)this.axisServlet);
        this.monitor.extensionStarted();
    }

    public void provision(Axis2WireSourceDefinition pwsd, Wire wire) throws WiringException {
        try {
            String uri = this.expandUri(pwsd.getUri());
            URI classLoaderUri = pwsd.getClassLoaderId();
            String serviceClass = pwsd.getServiceInterface();
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderUri);
            AxisService axisService = new AxisService();
            axisService.setName(uri);
            axisService.setDocumentation("Fabric3 enabled axis service");
            axisService.setClientSide(false);
            axisService.setClassLoader(classLoader);
            axisService.setEndpointURL(uri);
            Parameter interfaceParameter = new Parameter("ServiceClass", (Object)serviceClass);
            axisService.addParameter(interfaceParameter);
            this.setMessageReceivers(wire, axisService);
            axisService.setName(uri);
            this.configurationContext.getAxisConfiguration().addService(axisService);
            this.applyPolicies(pwsd, axisService);
            this.axisServlet.registerClassLoader("/" + this.servicePath + "/" + uri, classLoader);
            this.monitor.endpointProvisioned("/" + this.servicePath + "/" + uri);
        }
        catch (Exception e) {
            throw new WiringException((Throwable)e);
        }
    }

    private void applyPolicies(Axis2WireSourceDefinition pwsd, AxisService axisService) throws WiringException, AxisFault {
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)i.next();
            String operation = axisOperation.getName().getLocalPart();
            Set<AxisPolicy> policies = pwsd.getPolicies(operation);
            if (policies == null || policies.size() == 0) continue;
            AxisOperation axisDescription = axisOperation;
            for (AxisPolicy axisPolicy : policies) {
                String message = axisPolicy.getMessage();
                String module = axisPolicy.getModule();
                Element opaquePolicy = axisPolicy.getOpaquePolicy();
                AxisModule axisModule = this.f3Configurator.getModule(module);
                axisOperation.addModule(axisModule.getName());
                axisOperation.engageModule(axisModule);
                if (message != null) {
                    axisDescription = axisOperation.getMessage(message);
                }
                this.policyApplier.applyPolicy((AxisDescription)axisDescription, opaquePolicy);
            }
        }
    }

    private void setMessageReceivers(Wire wire, AxisService axisService) throws Exception {
        HashMap<String, InvocationChain> interceptors = new HashMap<String, InvocationChain>();
        for (InvocationChain chain : wire.getInvocationChains()) {
            interceptors.put(chain.getPhysicalOperation().getName(), chain);
        }
        Utils.fillAxisService((AxisService)axisService, (AxisConfiguration)this.configurationContext.getAxisConfiguration(), null, null);
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOp = (AxisOperation)i.next();
            InvocationChain invocationChain = (InvocationChain)interceptors.get(axisOp.getName().getLocalPart());
            Object messageReceiver = null;
            messageReceiver = "http://www.w3.org/ns/wsdl/in-only".equals(axisOp.getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(axisOp.getMessageExchangePattern()) ? new InOnlyServiceProxyHandler(invocationChain) : new InOutServiceProxyHandler(invocationChain);
            axisOp.setMessageReceiver((MessageReceiver)messageReceiver);
        }
    }

    private String expandUri(URI uri) throws WiringException {
        try {
            String decoded = URLDecoder.decode(uri.getPath(), "UTF-8");
            return this.expander.expand(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExpressionExpansionException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

