/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime;

import java.net.ConnectException;
import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.fabric3.binding.ws.axis2.provision.AxisPolicy;
import org.fabric3.binding.ws.axis2.runtime.config.F3Configurator;
import org.fabric3.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.wire.Interceptor;
import org.oasisopen.sca.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2TargetInterceptor
implements Interceptor {
    private Interceptor next;
    private List<String> endpointUris;
    private final String operation;
    private final Set<AxisPolicy> policies;
    private Map<String, String> operationInfo;
    private Map<String, String> config;
    private final F3Configurator f3Configurator;
    private final PolicyApplier policyApplier;
    private Random random = new Random();
    private AxisService axisService;
    private ClassLoader classLoader;

    public Axis2TargetInterceptor(List<String> endpointUris, String operation, Set<AxisPolicy> policies, Map<String, String> operationInfo, Map<String, String> config, F3Configurator f3Configurator, PolicyApplier policyApplier, AxisService axisService, ClassLoader classLoader) {
        this.operation = operation;
        this.endpointUris = endpointUris;
        this.policies = policies;
        this.f3Configurator = f3Configurator;
        this.policyApplier = policyApplier;
        this.operationInfo = operationInfo;
        this.config = config;
        this.axisService = axisService;
        this.classLoader = classLoader;
    }

    public Interceptor getNext() {
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        LinkedList<String> failedUris = new LinkedList<String>();
        String endpointUri = this.getEndpointUri(failedUris);
        Object[] payload = (Object[])msg.getBody();
        OMElement message = payload == null ? null : (OMElement)payload[0];
        Options options = new Options();
        options.setTo(new EndpointReference(endpointUri));
        options.setTransportInProtocol("http");
        options.setProperty("enableMTOM", (Object)"true");
        Subject subject = msg.getWorkContext().getSubject();
        if (subject != null && !subject.getPrincipals().isEmpty()) {
            Principal primaryPrincipal = subject.getPrincipals().iterator().next();
            options.setUserName(primaryPrincipal.getName());
        }
        this.applyOperationInfo(options);
        this.applyConfig(options);
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        try {
            if (this.classLoader instanceof MultiParentClassLoader) {
                MultiParentClassLoader mpcl = (MultiParentClassLoader)this.classLoader;
                mpcl.addParent(this.getClass().getClassLoader());
            }
            currentThread.setContextClassLoader(this.classLoader);
            ServiceClient sender = new ServiceClient(this.f3Configurator.getConfigurationContext(), null);
            sender.setOptions(options);
            sender.getOptions().setTimeOutInMilliSeconds(0L);
            this.applyPolicies(sender, this.operation);
            AxisOperation axisOperation = this.getAxisOperation(this.axisService, this.operation);
            MessageImpl ret = new MessageImpl();
            if ("http://www.w3.org/ns/wsdl/out-only".equals(axisOperation.getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(axisOperation.getMessageExchangePattern())) {
                try {
                    sender.sendRobust(message);
                }
                catch (AxisFault e) {
                    if (e.getCause() instanceof ConnectException) {
                        throw e;
                    }
                    ret.setBodyWithFault((Object)e.getDetail());
                }
            } else {
                OMElement result = sender.sendReceive(message);
                if (result instanceof Throwable) {
                    ret.setBodyWithFault((Object)result);
                } else {
                    ret.setBody((Object)result);
                }
            }
            failedUris.clear();
            MessageImpl messageImpl = ret;
            return messageImpl;
        }
        catch (AxisFault e) {
            Message message2 = this.handleFault(msg, endpointUri, e, failedUris);
            return message2;
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
    }

    private AxisOperation getAxisOperation(AxisService axisService, String opName) {
        OutInAxisOperation axisOperation = new OutInAxisOperation();
        if (axisService != null) {
            Iterator i = axisService.getOperations();
            while (i.hasNext()) {
                AxisOperation axisOp = (AxisOperation)i.next();
                if (!axisOp.getName().getLocalPart().equals(opName)) continue;
                axisOperation = axisOp;
                break;
            }
        }
        return axisOperation;
    }

    private Message handleFault(Message msg, String endpointUri, AxisFault e, List<String> failedUris) {
        SOAPFaultDetail element;
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            failedUris.add(endpointUri);
            if (failedUris.size() != this.endpointUris.size()) {
                return this.invoke(msg);
            }
        }
        if ((element = e.getFaultDetailElement()) == null) {
            throw new ServiceUnavailableException("Service fault was: \n" + (Object)((Object)e) + "\n\n", (Throwable)e);
        }
        OMNode child = element.getFirstOMChild();
        if (child == null) {
            throw new ServiceUnavailableException("Service fault was: \n" + (Object)((Object)e) + "\n\n", (Throwable)e);
        }
        throw new ServiceUnavailableException("Service fault was: \n" + child + "\n\n", (Throwable)e);
    }

    private String getEndpointUri(List<String> failedUris) {
        int index = this.random.nextInt(this.endpointUris.size());
        String endpointUri = this.endpointUris.get(index);
        if (failedUris.contains(endpointUri)) {
            endpointUri = this.getEndpointUri(failedUris);
        }
        return endpointUri;
    }

    private void applyOperationInfo(Options options) {
        String soapActionInfo;
        String soapAction = "urn:" + this.operation;
        if (this.operationInfo != null && (soapActionInfo = this.operationInfo.get("soapAction")) != null) {
            soapAction = soapActionInfo;
        }
        options.setAction(soapAction);
    }

    private void applyConfig(Options options) {
        boolean mtomEnabled;
        if (this.config != null && !(mtomEnabled = this.config.get("enableMTOM").equalsIgnoreCase("true"))) {
            options.setProperty("enableMTOM", (Object)"false");
            return;
        }
        options.setProperty("enableMTOM", (Object)"true");
    }

    private void applyPolicies(ServiceClient sender, String operation) throws AxisFault {
        if (this.policies == null) {
            return;
        }
        AxisService axisService = sender.getAxisService();
        AxisOperation axisOperation = axisService.getOperationBySOAPAction("urn:" + operation);
        if (axisOperation == null) {
            axisOperation = axisService.getOperation(ServiceClient.ANON_OUT_IN_OP);
        }
        AxisOperation axisDescription = axisOperation;
        for (AxisPolicy policy : this.policies) {
            String moduleName = policy.getModule();
            String message = policy.getMessage();
            AxisModule axisModule = this.f3Configurator.getModule(moduleName);
            axisOperation.addModule(axisModule.getName());
            axisOperation.engageModule(axisModule);
            if (message != null) {
                axisDescription = axisOperation.getMessage(message);
            }
            this.policyApplier.applyPolicy((AxisDescription)axisDescription, policy.getOpaquePolicy());
        }
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }
}

