/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisService;
import org.fabric3.binding.ws.axis2.provision.Axis2WireTargetDefinition;
import org.fabric3.binding.ws.axis2.provision.AxisPolicy;
import org.fabric3.binding.ws.axis2.runtime.Axis2TargetInterceptor;
import org.fabric3.binding.ws.axis2.runtime.config.F3Configurator;
import org.fabric3.binding.ws.axis2.runtime.policy.PolicyApplier;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.services.expression.ExpressionExpander;
import org.fabric3.spi.services.expression.ExpressionExpansionException;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class Axis2TargetWireAttacher
implements TargetWireAttacher<Axis2WireTargetDefinition> {
    @Reference
    protected PolicyApplier policyApplier;
    @Reference
    protected F3Configurator f3Configurator;
    @Reference
    protected ExpressionExpander expander;
    @Reference
    protected ClassLoaderRegistry classLoaderRegistry;

    public void attachToTarget(PhysicalWireSourceDefinition source, Axis2WireTargetDefinition target, Wire wire) throws WiringException {
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        LinkedList<String> endpointUris = new LinkedList<String>();
        String endpointUri = this.expandUri(target.getUri());
        StringTokenizer tok = new StringTokenizer(endpointUri);
        while (tok.hasMoreElements()) {
            endpointUris.add(tok.nextToken().trim());
        }
        AxisService axisService = this.createAxisClientService(target, classLoader);
        for (InvocationChain chain : wire.getInvocationChains()) {
            String operation = chain.getPhysicalOperation().getName();
            Set<AxisPolicy> policies = target.getPolicies(operation);
            Map<String, String> opInfo = target.getOperationInfo() != null ? target.getOperationInfo().get(operation) : null;
            Axis2TargetInterceptor interceptor = new Axis2TargetInterceptor(endpointUris, operation, policies, opInfo, target.getConfig(), this.f3Configurator, this.policyApplier, axisService, classLoader);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detachFromTarget(PhysicalWireSourceDefinition source, Axis2WireTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(Axis2WireTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    private String expandUri(URI uri) throws WiringException {
        try {
            String decoded = URLDecoder.decode(uri.toASCIIString(), "UTF-8");
            return this.expander.expand(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExpressionExpansionException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private URL getWsdlURL(String wsdlLocation, ClassLoader classLoader) {
        if (wsdlLocation == null) {
            return null;
        }
        try {
            return new URL(wsdlLocation);
        }
        catch (MalformedURLException e) {
            return classLoader.getResource(wsdlLocation);
        }
    }

    private AxisService createAxisClientService(Axis2WireTargetDefinition target, ClassLoader classLoader) throws WiringException {
        URL wsdlURL = this.getWsdlURL(target.getWsdlLocation(), classLoader);
        if (wsdlURL != null) {
            try {
                return AxisService.createClientSideAxisService((URL)wsdlURL, (QName)target.getWsdlElement().getServiceName(), (String)target.getWsdlElement().getPortName().getLocalPart(), (Options)new Options());
            }
            catch (AxisFault e) {
                throw new WiringException((Throwable)e);
            }
        }
        return null;
    }
}

