/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime.config;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.fabric3.binding.ws.axis2.runtime.config.F3Configurator;
import org.fabric3.binding.ws.axis2.runtime.config.F3ThreadFactory;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.work.WorkScheduler;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class F3ConfiguratorImpl
implements F3Configurator {
    private WorkScheduler scheduler;
    private HostInfo info;
    private ConfigurationContext configurationContext;
    private String servicePath = "axis2";
    private Map<String, AxisModule> modules = new HashMap<String, AxisModule>();
    private ClassLoader extensionClassLoader;
    private String chunkTransferEncoding = "true";
    private String cacheLargeAttachements = "true";
    private String cacheThreshold = "100000";

    public F3ConfiguratorImpl(@Reference WorkScheduler scheduler, @Reference HostInfo info) {
        this.scheduler = scheduler;
        this.info = info;
    }

    @Property
    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Property
    public void setCacheLargeAttachements(String val) {
        this.cacheLargeAttachements = val;
    }

    @Property
    public void setCacheThreshold(String threshold) {
        this.cacheThreshold = threshold;
    }

    @Property
    public void setChunkTransferEncoding(String val) {
        this.chunkTransferEncoding = val;
    }

    @Init
    public void start() throws Exception {
        this.configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        this.configurationContext.setServicePath(this.servicePath);
        F3ThreadFactory factory = new F3ThreadFactory(this.scheduler);
        this.configurationContext.setThreadPool((ThreadFactory)factory);
        this.configurationContext.setProperty("__CHUNKED__", (Object)this.chunkTransferEncoding);
        this.configurationContext.setProperty("cacheAttachments", (Object)this.cacheLargeAttachements);
        this.configurationContext.setProperty("sizeThreshold", (Object)this.cacheThreshold);
        File dir = this.info.getTempDir();
        File attachementDir = new File(dir, "axis2");
        attachementDir.mkdir();
        this.configurationContext.setProperty("attachmentDIR", (Object)attachementDir.toString());
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> modules = classLoader.getResources("META-INF/module.xml");
        while (modules.hasMoreElements()) {
            AxisModule axisModule = new AxisModule();
            axisModule.setParent(axisConfiguration);
            axisModule.setModuleClassLoader(classLoader);
            InputStream moduleStream = modules.nextElement().openStream();
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, axisModule, axisConfiguration);
            moduleBuilder.populateModule();
            this.addNewModule(axisModule, axisConfiguration);
        }
        Utils.calculateDefaultModuleVersion((HashMap)axisConfiguration.getModules(), (AxisConfiguration)axisConfiguration);
        axisConfiguration.validateSystemPredefinedPhases();
    }

    public void registerExtensionClassLoader(ClassLoader loader) {
        this.extensionClassLoader = loader;
    }

    public ClassLoader getExtensionClassLoader() {
        if (this.extensionClassLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.extensionClassLoader;
    }

    public AxisModule getModule(String name) {
        return this.modules.get(name);
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    private void addNewModule(AxisModule axisModule, AxisConfiguration axisConfiguration) throws AxisFault {
        ClassLoader moduleClassLoader = axisModule.getModuleClassLoader();
        this.addFlowHandlers(axisModule.getInFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getOutFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getFaultInFlow(), moduleClassLoader);
        this.addFlowHandlers(axisModule.getFaultOutFlow(), moduleClassLoader);
        axisConfiguration.addModule(axisModule);
        this.modules.put(axisModule.getName(), axisModule);
    }

    private void addFlowHandlers(Flow flow, ClassLoader moduleClassLoader) throws AxisFault {
        if (flow != null) {
            org.apache.axis2.deployment.util.Utils.addFlowHandlers((Flow)flow, (ClassLoader)moduleClassLoader);
        }
    }
}

