/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebFault;
import org.apache.axiom.om.OMElement;
import org.fabric3.binding.ws.axis2.runtime.jaxb.Jaxb2OMElement;
import org.fabric3.binding.ws.axis2.runtime.jaxb.OMElement2Jaxb;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.transform.TransformContext;
import org.fabric3.spi.wire.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbInterceptor
implements Interceptor {
    private Interceptor next;
    private final ClassLoader classLoader;
    private final OMElement2Jaxb inTransformer;
    private final Jaxb2OMElement outTransformer;
    private final boolean service;
    private final Map<Class<?>, Constructor<?>> faultMapping;

    public JaxbInterceptor(ClassLoader classLoader, JAXBContext jaxbContext, boolean service, Map<Class<?>, Constructor<?>> faultMapping) throws JAXBException {
        this.classLoader = classLoader;
        this.inTransformer = new OMElement2Jaxb(jaxbContext);
        this.outTransformer = new Jaxb2OMElement(jaxbContext);
        this.service = service;
        this.faultMapping = faultMapping;
    }

    public Interceptor getNext() {
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message message) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Message message2 = this.service ? this.interceptService(message) : this.interceptReference(message);
            return message2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private Message interceptService(Message message) {
        Object result;
        Message response;
        Object[] payload = (Object[])message.getBody();
        if (payload != null && payload.length > 0) {
            OMElement omElement = (OMElement)payload[0];
            Object jaxbObject = this.inTransformer.transform(omElement, (TransformContext)null);
            message.setBody((Object)new Object[]{jaxbObject});
        }
        if ((response = this.next.invoke(message)).isFault()) {
            Object webFault = response.getBody();
            result = this.getFault(webFault);
        } else {
            result = response.getBody();
        }
        if (result != null) {
            OMElement omElement = this.outTransformer.transform(result, null);
            response.setBody((Object)omElement);
        }
        return response;
    }

    private Object getFault(Object webFault) {
        WebFault annotation = webFault.getClass().getAnnotation(WebFault.class);
        if (annotation == null) {
            if (webFault instanceof RuntimeException) {
                throw (RuntimeException)webFault;
            }
            if (webFault instanceof Exception) {
                throw new AssertionError((Object)((Exception)webFault));
            }
        }
        try {
            Method getFaultInfo = webFault.getClass().getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.invoke(webFault, new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private Message interceptReference(Message message) {
        Message response;
        Object result;
        System.err.println("Intercepting reference");
        Object[] payload = (Object[])message.getBody();
        if (payload != null && payload.length > 0) {
            Object jaxbObject = payload[0];
            OMElement omElement = this.outTransformer.transform(jaxbObject, null);
            message.setBody((Object)new Object[]{omElement});
        }
        if ((result = (response = this.next.invoke(message)).getBody()) != null) {
            OMElement omElement = (OMElement)result;
            Object jaxbObject = this.inTransformer.transform(omElement, (TransformContext)null);
            Constructor<?> faultConstructor = this.faultMapping.get(jaxbObject.getClass());
            if (faultConstructor != null) {
                try {
                    Object fault = faultConstructor.newInstance(null, jaxbObject);
                    response.setBodyWithFault(fault);
                }
                catch (InstantiationException e) {
                    throw new AssertionError();
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError();
                }
            } else {
                response.setBody(jaxbObject);
            }
        }
        return response;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }
}

