/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.axis2.runtime.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebFault;
import org.fabric3.binding.ws.axis2.provision.jaxb.JaxbInterceptorDefinition;
import org.fabric3.binding.ws.axis2.runtime.jaxb.JaxbBuilderException;
import org.fabric3.binding.ws.axis2.runtime.jaxb.JaxbInterceptor;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.wire.Interceptor;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbInterceptorBuilder
implements InterceptorBuilder<JaxbInterceptorDefinition> {
    private ClassLoaderRegistry classLoaderRegistry;

    public JaxbInterceptorBuilder(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public Interceptor build(JaxbInterceptorDefinition definition) throws BuilderException {
        URI classLoaderId = definition.getWireClassLoaderId();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderId);
        try {
            Set<String> classNames = definition.getClassNames();
            Set<String> faultNames = definition.getFaultNames();
            Map<Class<?>, Constructor<?>> faultMapping = this.getFaultMapping(classLoader, faultNames);
            JAXBContext context = this.getJAXBContext(classLoader, classNames);
            return new JaxbInterceptor(classLoader, context, definition.isService(), faultMapping);
        }
        catch (NoSuchMethodException e) {
            throw new JaxbBuilderException(e);
        }
        catch (ClassNotFoundException e) {
            throw new JaxbBuilderException(e);
        }
        catch (JAXBException e) {
            throw new JaxbBuilderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext(ClassLoader classLoader, Set<String> classNames) throws JAXBException, ClassNotFoundException {
        Class[] classes = new Class[classNames.size()];
        int i = 0;
        for (String className : classNames) {
            classes[i++] = this.classLoaderRegistry.loadClass(classLoader, className);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes);
            return jAXBContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Map<Class<?>, Constructor<?>> getFaultMapping(ClassLoader classLoader, Set<String> faultNames) throws ClassNotFoundException, NoSuchMethodException {
        HashMap mapping = new HashMap(faultNames.size());
        for (String faultName : faultNames) {
            Class clazz = this.classLoaderRegistry.loadClass(classLoader, faultName);
            WebFault fault = clazz.getAnnotation(WebFault.class);
            if (fault == null) {
                throw new RuntimeException();
            }
            Method getFaultInfo = clazz.getMethod("getFaultInfo", new Class[0]);
            Class<?> faultType = getFaultInfo.getReturnType();
            Constructor constructor = clazz.getConstructor(String.class, faultType);
            mapping.put(faultType, constructor);
        }
        return mapping;
    }
}

